<?php
/**
 * Forwards base inclusion file.
 *
 * This file brings in all of the dependencies that every Forwards script will
 * need, and sets up objects that all scripts use.
 *
 * $Horde: forwards/lib/base.php,v 1.38.2.2 2007/01/02 13:54:05 jan Exp $
 *
 * Copyright 2001-2007 Eric Rostetter <eric.rostetter@physics.utexas.edu>
 *
 * See the enclosed file LICENSE for license information (BSDL). If you
 * did not receive this file, see http://www.horde.org/licenses/bsdl.php.
 */

// Check for a prior definition of HORDE_BASE (perhaps by an auto_prepend_file
// definition for site customization).
if (!defined('HORDE_BASE')) {
    @define('HORDE_BASE', dirname(__FILE__) . '/../..');
}

// Load the Horde Framework core, and set up inclusion paths.
require_once HORDE_BASE . '/lib/core.php';

// Registry.
$registry = &Registry::singleton();
if (is_a(($pushed = $registry->pushApp('forwards', !defined('AUTH_HANDLER'))), 'PEAR_Error')) {
    if ($pushed->getCode() == 'permission_denied') {
        Horde::authenticationFailureRedirect();
    }
    Horde::fatal($pushed, __FILE__, __LINE__, false);
}
$conf = &$GLOBALS['conf'];
@define('FORWARDS_TEMPLATES', $registry->get('templates'));

// Notification system.
$notification = &Notification::singleton();
$notification->attach('status');

// Don't allow access unless there is a Horde login. NOTE: We explicitely do
// NOT honor the guests flag here.
if (!Auth::isAuthenticated()) {
    Horde::authenticationFailureRedirect();
}

// Find the base file path of Forwards.
@define('FORWARDS_BASE', dirname(__FILE__) . '/..');

// Help.
require_once 'Horde/Help.php';
