
#include "backend_plugins.h"
#include "config.h"
#include "tools.h"

#include <qfile.h>
#include <qfileinfo.h>
#include <qdir.h>

#include <klocale.h>
#include <kstandarddirs.h>

Extension::Extension()
{
}

Extension::Extension(QString ext,int size)
{
    extension=ext;
    fileSize=size;
}

Extension::~Extension()
{
}

BackendPlugins::PluginStructure::PluginStructure()
{
    PluginStructure(i18n("Unnamed"));
}

BackendPlugins::PluginStructure::PluginStructure(QString name)
{
    info.name=name;
}

BackendPlugins::PluginStructure::~PluginStructure()
{
}

BackendPlugins::BackendPlugins()
{
    load();
}

bool BackendPlugins::loadFile(QString fileName)
{
    QString info_format_descriptions, info_about, info_short_info, info_author, info_version, info_name;
    int t_int;
    float t_float;
    QString t_str;

    QFile opmlFile( fileName );
    if ( !opmlFile.open( IO_ReadOnly ) ) {
        return false;
    }
    if ( !domTree.setContent( &opmlFile ) ) {
        return false;
    }
    opmlFile.close();

    QDomElement root = domTree.documentElement();
    if( root.attribute("type") != "converter" ) return false;
    QDomNode node, sub1Node, sub2Node, sub3Node;
    node = root.firstChild();
    while ( !node.isNull() ) {
        if ( node.isElement() && node.nodeName() == "info" ) {
            info_format_descriptions=node.toElement().attribute("format_descriptions");
            info_about=node.toElement().attribute("about");
            info_short_info=node.toElement().attribute("short_info");
            info_author=node.toElement().attribute("author");
            info_version=node.toElement().attribute("version");
            info_name=node.toElement().attribute("name");
            break;
        }
        node = node.nextSibling();
    }

    PluginStructureList::Iterator it=plugins.append(PluginStructure(info_name+" v. "+info_version));
    (*it).info.format_descriptions=info_format_descriptions;
    (*it).info.about=info_about;
    (*it).info.short_info=info_short_info;
    (*it).info.author=info_author;
    sscanf(info_version,"%i",&t_int);
    (*it).info.version=t_int;
    (*it).file_name=fileName;

    while ( !node.isNull() ) {
        if ( node.isElement() && node.nodeName() == "enc" ) {
            (*it).enc.bin=node.toElement().attribute("bin");
            (*it).enc.param=node.toElement().attribute("param");
            (*it).enc.overwrite=node.toElement().attribute("overwrite");
            sscanf(node.toElement().attribute("max_version"),"%i",&t_int);
            (*it).enc.max_version=t_int;
            sscanf(node.toElement().attribute("min_version"),"%i",&t_int);
            (*it).enc.min_version=t_int;
            (*it).enc.inOutFiles=node.toElement().attribute("inOutFiles");
            (*it).enc.formats=QStringList::split(',',node.toElement().attribute("formats"));
            if(node.toElement().attribute("level")=="Full") (*it).enc.level=Full;
            else if(node.toElement().attribute("level")=="Most") (*it).enc.level=Most;
            else (*it).enc.level=Basic;
            (*it).enc.silent_param=node.toElement().attribute("silent_param");
            if(node.toElement().attribute("enabled")=="true") (*it).enc.enabled=true;
            else (*it).enc.enabled=false;
            sub1Node = node.toElement().firstChild();
            while ( !sub1Node.isNull() ) {
                if ( sub1Node.isElement() && sub1Node.nodeName() == "strength" ) {
                    sscanf(sub1Node.toElement().attribute("range_min"),"%f",&t_float);
                    (*it).enc.strength.range_min=t_float;
                    (*it).enc.strength.seperator=sub1Node.toElement().attribute("seperator").at(0);
                    sscanf(sub1Node.toElement().attribute("range_max"),"%f",&t_float);
                    (*it).enc.strength.range_max=t_float;
                    (*it).enc.strength.param=sub1Node.toElement().attribute("param");
                    sscanf(sub1Node.toElement().attribute("step"),"%f",&t_float);
                    (*it).enc.strength.step=t_float;
                    (*it).enc.strength.profiles=QStringList::split(',',sub1Node.toElement().attribute("profiles"));
                    if(sub1Node.toElement().attribute("enabled")=="true") (*it).enc.strength.enabled=true;
                    else (*it).enc.strength.enabled=false;
//                     break;
                }
                else if ( sub1Node.isElement() && sub1Node.nodeName() == "quality" ) {
                    sscanf(sub1Node.toElement().attribute("range_min"),"%f",&t_float);
                    (*it).enc.quality.range_min=t_float;
                    (*it).enc.quality.seperator=sub1Node.toElement().attribute("seperator").at(0);
                    sscanf(sub1Node.toElement().attribute("range_max"),"%f",&t_float);
                    (*it).enc.quality.range_max=t_float;
                    (*it).enc.quality.help=sub1Node.toElement().attribute("help");
                    (*it).enc.quality.output=sub1Node.toElement().attribute("output");
                    (*it).enc.quality.param=sub1Node.toElement().attribute("param");
                    sscanf(sub1Node.toElement().attribute("step"),"%f",&t_float);
                    (*it).enc.quality.step=t_float;
                    (*it).enc.quality.profiles=QStringList::split(',',sub1Node.toElement().attribute("profiles"));
                    if(sub1Node.toElement().attribute("enabled")=="true") (*it).enc.quality.enabled=true;
                    else (*it).enc.quality.enabled=false;
//                     break;
                }
                else if ( sub1Node.isElement() && sub1Node.nodeName() == "bitrate" ) {
                    sub2Node = sub1Node.toElement().firstChild();
                    while ( !sub2Node.isNull() ) {
                       if ( sub2Node.isElement() && sub2Node.nodeName() == "abr" ) {
                           (*it).enc.bitrate.abr.output=sub2Node.toElement().attribute("output");
                           (*it).enc.bitrate.abr.param=sub2Node.toElement().attribute("param");
                           if(sub2Node.toElement().attribute("enabled")=="true") (*it).enc.bitrate.abr.enabled=true;
                           else (*it).enc.bitrate.abr.enabled=false;
                           sub3Node = sub2Node.toElement().firstChild();
                           while ( !sub3Node.isNull() ) {
                               if ( sub3Node.isElement() && sub3Node.nodeName() == "bitrate_range" ) {
                                   (*it).enc.bitrate.abr.bitrate_range.param_min=sub3Node.toElement().attribute("min_param");
                                   (*it).enc.bitrate.abr.bitrate_range.param_max=sub3Node.toElement().attribute("max_param");
                                   if(sub3Node.toElement().attribute("enabled")=="true") (*it).enc.bitrate.abr.bitrate_range.enabled=true;
                                   else (*it).enc.bitrate.abr.bitrate_range.enabled=false;
//                                    break;
                               }
                               sub3Node = sub3Node.nextSibling();
                           }
//                            break;
                       }
                       else if ( sub2Node.isElement() && sub2Node.nodeName() == "cbr" ) {
                           (*it).enc.bitrate.cbr.output=sub2Node.toElement().attribute("output");
                           (*it).enc.bitrate.cbr.param=sub2Node.toElement().attribute("param");
                           if(sub2Node.toElement().attribute("enabled")=="true") (*it).enc.bitrate.cbr.enabled=true;
                           else (*it).enc.bitrate.cbr.enabled=false;
//                            break;
                       }
                       sub2Node = sub2Node.nextSibling();
                   }
//                    break;
                }
                else if ( sub1Node.isElement() && sub1Node.nodeName() == "resample" ) {
                    if(sub1Node.toElement().attribute("unit")=="Hz") (*it).enc.resample.unit=Hz;
                    else (*it).enc.resample.unit=KHz;
                    (*it).enc.resample.param=sub1Node.toElement().attribute("param");
                    if(sub1Node.toElement().attribute("enabled")=="true") (*it).enc.resample.enabled=true;
                    else (*it).enc.resample.enabled=false;
//                     break;
                }
                else if ( sub1Node.isElement() && sub1Node.nodeName() == "channels" ) {
                    (*it).enc.channels.stereo_param=sub1Node.toElement().attribute("stereo_param");
                    if(sub1Node.toElement().attribute("stereo_enabled")=="true") (*it).enc.channels.stereo_enabled=true;
                    else (*it).enc.channels.stereo_enabled=false;
                    (*it).enc.channels.mono_param=sub1Node.toElement().attribute("mono_param");
                    if(sub1Node.toElement().attribute("mono_enabled")=="true") (*it).enc.channels.mono_enabled=true;
                    else (*it).enc.channels.mono_enabled=false;
//                     break;
                }
                else if ( sub1Node.isElement() && sub1Node.nodeName() == "lossless" ) {
                    (*it).enc.lossless.output=sub1Node.toElement().attribute("output");
                    (*it).enc.lossless.param=sub1Node.toElement().attribute("param");
                    if(sub1Node.toElement().attribute("enabled")=="true") (*it).enc.lossless.enabled=true;
                    else (*it).enc.lossless.enabled=false;
//                     break;
                }
                else if ( sub1Node.isElement() && sub1Node.nodeName() == "lossy" ) {
                    if(sub1Node.toElement().attribute("enabled")=="true") (*it).enc.lossy.enabled=true;
                    else (*it).enc.lossy.enabled=false;
//                     break;
                }
                else if ( sub1Node.isElement() && sub1Node.nodeName() == "replay_gain" ) {
                    (*it).enc.replaygain.avoid=sub1Node.toElement().attribute("avoid");
                    (*it).enc.replaygain.use=sub1Node.toElement().attribute("use");
                    if(sub1Node.toElement().attribute("enabled")=="true") (*it).enc.replaygain.enabled=true;
                    else (*it).enc.replaygain.enabled=false;
//                     break;
                }
                else if ( sub1Node.isElement() && sub1Node.nodeName() == "tag" ) {
                    (*it).enc.tag.param=sub1Node.toElement().attribute("param");
                    (*it).enc.tag.artist=sub1Node.toElement().attribute("artist");
                    (*it).enc.tag.album=sub1Node.toElement().attribute("album");
                    (*it).enc.tag.title=sub1Node.toElement().attribute("title");
                    (*it).enc.tag.genre=sub1Node.toElement().attribute("genre");
                    (*it).enc.tag.comment=sub1Node.toElement().attribute("comment");
                    (*it).enc.tag.track=sub1Node.toElement().attribute("track");
                    (*it).enc.tag.year=sub1Node.toElement().attribute("year");
                    if(sub1Node.toElement().attribute("enabled")=="true") (*it).enc.tag.enabled=true;
                    else (*it).enc.tag.enabled=false;
//                     break;
                }
                sub1Node = sub1Node.nextSibling();
            }
//             break;
        }
        else if ( node.isElement() && node.nodeName() == "dec" ) {
            (*it).dec.bin=node.toElement().attribute("bin");
            (*it).dec.output=node.toElement().attribute("output");
            (*it).dec.param=node.toElement().attribute("param");
            (*it).dec.overwrite=node.toElement().attribute("overwrite");
            sscanf(node.toElement().attribute("max_version"),"%i",&t_int);
            (*it).dec.max_version=t_int;
            sscanf(node.toElement().attribute("min_version"),"%i",&t_int);
            (*it).dec.min_version=t_int;
            (*it).dec.mime_types=node.toElement().attribute("mimeTypes");
            (*it).dec.formats=QStringList::split(',',node.toElement().attribute("formats"));
            (*it).dec.synonymous_formats=QStringList::split(',',node.toElement().attribute("synonymous_formats"));
            (*it).dec.inOutFiles=node.toElement().attribute("inOutFiles");
            if(node.toElement().attribute("level")=="Full") (*it).dec.level=Full;
            else if(node.toElement().attribute("level")=="Most") (*it).dec.level=Most;
            else (*it).dec.level=Basic;
            QString fileSizesString=node.toElement().attribute("file_sizes");
            //#ifdef DEBUG
            //system( QString("echo \"").append(fileSizesString).append("\" >> ~/debug.txt") );
            //#endif
            while(fileSizesString.length() > 0) {
                int index=fileSizesString.find("{");
                QString extension=fileSizesString.left(index);
                fileSizesString.remove(0,index+1);
                index=fileSizesString.find("}");
                QString sSize=fileSizesString.left(index);
                //#ifdef DEBUG
                //system( QString("echo \"").append(sSize).append("\" >> ~/debug.txt") );
                //#endif
                fileSizesString.remove(0,index+2);
                int size=0;
                sscanf(sSize,"%i",&size);
                //system( "echo debug >> ~/debug.txt" );
                //if( extensionList.findIndex() == -1 ) {
                    extensionList.append(Extension(extension,size));
                //}
                /*for( ExtensionList::Iterator it=extensionList.begin(); it!=extensionList.end(); ++it )
                {
                    if( (*it).extension == extension ) {
                        (*it).fileSize=size;
                        //#ifdef DEBUG
                        //system( QString("echo \"(*it).fileSize (").append(extension).append("): %1").arg((*it).fileSize).append("\" >> ~/debug.txt") );
                        //#endif
                        break;
                    }
                    //system( "echo hopp >> ~/debug.txt" );
                }*/

            }
            /*QValueList<uint>::Iterator kt=(*it).dec.file_sizes.append(10000);
            for(QStringList::Iterator jt=(*it).dec.formats.begin(); jt!=(*it).dec.formats.end(); ++jt) {
                t_str=tools.getFormatInfoString(fileSizesString,*jt);
                sscanf(t_str,"%i",&t_uint);
                *kt=t_uint;
                kt++;
            }*/
            (*it).dec.silent_param=node.toElement().attribute("silent_param");
            if(node.toElement().attribute("enabled")=="true") (*it).dec.enabled=true;
            else (*it).dec.enabled=false;
//             break;
        }
        node = node.nextSibling();
    }

    return true;
}

void BackendPlugins::load()
{
    QStringList list;
    QDir dir;
    QFileInfo file;
    bool add;

    KStandardDirs stddir;
    QStringList directories = stddir.findDirs("data","soundkonverter/plugins");
    for( QStringList::Iterator jt=directories.begin(); jt!=directories.end(); ++jt )
    {
        dir.setPath(*jt);
        list=dir.entryList("*",QDir::All,QDir::Name);
        for( QStringList::Iterator it=list.begin(); it!=list.end(); ++it )
        {
            if( *it != "." && *it != ".." && (*it).find("soundkonverter.xml") != -1 )
            {
                add=true;

                for( PluginStructureList::Iterator kt=plugins.begin(); kt!=plugins.end(); ++kt )
                {
                    //if( tools.fileName((*kt).file_name) == (*it) )
                    if( tools.fileName((*kt).file_name).left(3) == (*it).left(3) )
                    {
                        add=false;
                        break;
                    }
                }

                if(add)
                {
                    file.setFile((*jt)+(*it));
                    if( file.isFile() ) {
                        loadFile((*jt)+(*it));
                    }
                }
            }
        }
    }
}

void BackendPlugins::reload()
{
    plugins.clear();
    load();
    //prefs.rebuildFormatList();
    prefs.write();
    prefs.read();
}

void BackendPlugins::unload(QString plugin)
{
    for( PluginStructureList::Iterator it=plugins.begin(); it!=plugins.end(); ++it )
    {
        if( (*it).info.name == plugin ) { plugins.remove(it); break; }
    }
}

void BackendPlugins::remove(QString plugin)
{
    for( PluginStructureList::Iterator it=plugins.begin(); it!=plugins.end(); ++it )
    {
        if( (*it).info.name == plugin ) {
            QString fileName=(*it).file_name;
            plugins.remove(it);
            QFile::remove(fileName); // TODO fehlermeldung bei fehlschlag
            break;
        }
    }
}

QStringList BackendPlugins::loadedPlugins()
{
    QStringList list;

    for( PluginStructureList::Iterator it=plugins.begin(); it!=plugins.end(); ++it )
    {
        list.append((*it).info.name);
    }

    return list;
}

BackendPlugins::PluginStructure BackendPlugins::plugin(QString bin)
{
    if( !bin ) return BackendPlugins::PluginStructure(i18n("Unnamed"));

    for( PluginStructureList::Iterator it=plugins.begin(); it!=plugins.end(); ++it )
    {
        if( (*it).enc.bin == bin || (*it).dec.bin == bin ) return *it;
    }

    return BackendPlugins::PluginStructure(i18n("Unnamed")); // NOTE irgendwo wird ein ungültiger Parameter übergeben -> fehler
}

int BackendPlugins::fileSize(QString ext)
{
    for( ExtensionList::Iterator it=extensionList.begin(); it!=extensionList.end(); ++it )
    {
        if( (*it).extension == ext ) {
            return (*it).fileSize;
        }
    }

    return 20000;
}

QStringList BackendPlugins::allFileFormats()
{
    QStringList list;

    for( PluginStructureList::Iterator it=plugins.begin(); it!=plugins.end(); ++it )
    {
        for( QStringList::Iterator jt=(*it).enc.formats.begin(); jt!=(*it).enc.formats.end(); ++jt ) {
            if( list.findIndex(*jt) == -1 ) list+=(*jt);
        }
    }

    return list;
}

QStringList BackendPlugins::allLosslessFileFormats()
{
    QStringList list;

    for( PluginStructureList::Iterator it=plugins.begin(); it!=plugins.end(); ++it )
    {
        if( (*it).enc.lossless.enabled ) {
            for( QStringList::Iterator jt=(*it).enc.formats.begin(); jt!=(*it).enc.formats.end(); ++jt ) {
                if( list.findIndex(*jt) == -1 ) list+=(*jt);
            }
        }
    }

    return list;
}

QStringList BackendPlugins::allLossyFileFormats()
{
    QStringList list;

    for( PluginStructureList::Iterator it=plugins.begin(); it!=plugins.end(); ++it )
    {
        if( (*it).enc.lossy.enabled ) {
            for( QStringList::Iterator jt=(*it).enc.formats.begin(); jt!=(*it).enc.formats.end(); ++jt ) {
                if( list.findIndex(*jt) == -1 ) list+=(*jt);
            }
        }
    }

    return list;
}

