
#include "config_dialogue_en_decoder.h"

#include "calibrate.h"
#include "tools.h"
#include "backend_plugins.h"
#include "replaygain_plugins.h"

#include <qlabel.h>
#include <qcombobox.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qtooltip.h>
#include <qscrollview.h>
#include <qvbox.h>
#include <qdir.h>

#include <kconfig.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kpushbutton.h>
#include <kfiledialog.h>
#include <kstandarddirs.h>
#include <kpushbutton.h>

FormatOptions::FormatOptions()
{
}

FormatOptions::FormatOptions(QString f)
{
    format=f;
}

FormatOptions::~FormatOptions()
{
}

ConfigDialogueEnDecoder::ConfigDialogueEnDecoder( QWidget *parent, const char *name )
    : QWidget( parent, name )
{
    char cTime[8];

    grid = new QGridLayout( this );
    sv = new QScrollView( this, "sv" );
    sv->setResizePolicy(QScrollView::AutoOneFit);
    grid->addWidget(sv,0,0);
    box = new QVBox( sv->viewport() );
    box->setMargin(10);
    box->setSpacing(5);
    sv->addChild(box);

    QHBox *fileBox = new QHBox(box);
    fileBox->setMargin(0);
    fileBox->setSpacing(5);
    QLabel *lTestFileLabel = new QLabel(i18n("File for calibration")+":",fileBox,"lTestFileLabel");
    lTestFile = new QLineEdit(fileBox,"lTestFile");
    lTestFile->setText(prefs.calibrationFile);
    QToolTip::add(lTestFile,i18n("A file for test en- and decoding to detect the conversion speed."));
    connect(lTestFile,SIGNAL(textChanged(const QString&)),this,SLOT(updateCalibrateButtons()));
    pSelectFile = new QPushButton( " ", fileBox, "pSelectFile" );
    pSelectFile->setPixmap( KGlobal::iconLoader()->loadIcon("folder",KIcon::Toolbar) );
    QToolTip::add( pSelectFile, i18n("Select a file for the calibration.") );
    connect(pSelectFile,SIGNAL(clicked()),this,SLOT(showFileDialogue()));

    QHBox *legendBox = new QHBox(box);
    legendBox->setMargin(0);
    legendBox->setSpacing(0);
    KStandardDirs *stdDirs = new KStandardDirs();
    QLabel *lLegendLabel = new QLabel(i18n("Legend")+":",legendBox,"lLegendLabel");
    QLabel *lLegendGreen = new QLabel("",legendBox,"lLegendGreen");
    lLegendGreen->setPixmap(QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledgreen.png")));
    QLabel *lLegendFull = new QLabel("= "+i18n("Full support")+"    ",legendBox,"lLegendFull");
    QLabel *lLegendYellow = new QLabel("",legendBox,"lLegendYellow");
    lLegendYellow->setPixmap(QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledyellow.png")));
    QLabel *lLegendMost = new QLabel("= "+i18n("Most supported")+"    ",legendBox,"lLegendMost");
    QLabel *lLegendRed = new QLabel("",legendBox,"lLegendRed");
    lLegendRed->setPixmap(QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledred.png")));
    QLabel *lLegendBasic = new QLabel("= "+i18n("Basic support"),legendBox,"lLegendBasic");
    legendBox->setStretchFactor(lLegendLabel,1);

    for( FileFormatList::Iterator it=prefs.fileFormatList.begin(); it!=prefs.fileFormatList.end(); ++it )
    {
        FormatOptionsList::Iterator options=formatOptions.append(FormatOptions((*it).extension));

        (*options).group = new QGroupBox((*options).format,box,"group");
        (*options).group->setColumnLayout(0,Qt::Vertical);
        (*options).group->layout()->setSpacing(5);
        (*options).group->layout()->setMargin(10);
        (*options).grid = new QGridLayout((*options).group->layout());

        (*options).lEncoder = new QLabel(i18n("Encoder")+":",(*options).group,"lEncoder");
        (*options).grid->addWidget((*options).lEncoder,0,0);
        (*options).cEncoder = new QComboBox((*options).group,(*options).format);
        connect((*options).cEncoder,SIGNAL(activated(int)),this,SLOT(cfgChanged()));
        connect((*options).cEncoder,SIGNAL(activated(int)),this,SLOT(encoderChanged()));
        (*options).sEncoder = new QStringList();
        (*options).grid->addWidget((*options).cEncoder,0,1);
        (*options).lEncTimeLabel = new QLabel(i18n("Time")+":",(*options).group,"lEncTimeLabel");
        (*options).grid->addWidget((*options).lEncTimeLabel,0,2);
        sprintf(cTime,"%.4f",(*it).encTime);
        (*options).lEncTime = new QLabel(cTime,(*options).group,"lEncTime");
        (*options).lEncTime->setFont(QFont("Courier"));
        (*options).grid->addWidget((*options).lEncTime,0,3);

        (*options).lDecoder = new QLabel(i18n("Decoder")+":",(*options).group,"lDecoder");
        (*options).grid->addWidget((*options).lDecoder,1,0);
        (*options).cDecoder = new QComboBox((*options).group,"cDecoder");
        connect((*options).cDecoder,SIGNAL(activated(int)),this,SLOT(cfgChanged()));
        (*options).sDecoder = new QStringList();
        (*options).grid->addWidget((*options).cDecoder,1,1);
        (*options).lDecTimeLabel = new QLabel(i18n("Time")+":",(*options).group,"lDecTimeLabel");
        (*options).grid->addWidget((*options).lDecTimeLabel,1,2);
        sprintf(cTime,"%.4f",(*it).decTime);
        (*options).lDecTime = new QLabel(cTime,(*options).group,"lDecTime");
        (*options).lDecTime->setFont(QFont("Courier"));
        (*options).grid->addWidget((*options).lDecTime,1,3);

        (*options).lReplayGain = new QLabel(i18n("ReplayGain")+":",(*options).group,"lReplayGain");
        (*options).grid->addWidget((*options).lReplayGain,2,0);
        (*options).cReplayGain = new QComboBox((*options).group,"cReplayGain");
        connect((*options).cReplayGain,SIGNAL(activated(int)),this,SLOT(cfgChanged()));
        (*options).sReplayGain = new QStringList();
        (*options).grid->addWidget((*options).cReplayGain,2,1);
        (*options).lRepTimeLabel = new QLabel(i18n("Time")+":",(*options).group,"lRepTimeLabel");
        (*options).grid->addWidget((*options).lRepTimeLabel,2,2);
        sprintf(cTime,"%.4f",(*it).repTime);
        (*options).lRepTime = new QLabel(cTime,(*options).group,"lRepTime");
        (*options).lRepTime->setFont(QFont("Courier"));
        (*options).grid->addWidget((*options).lRepTime,2,3);

        (*options).pCalibrate = new KPushButton(KGlobal::iconLoader()->loadIcon("configure",KIcon::Small),i18n("Calibrate"),(*options).group,(*options).format);
        QToolTip::add((*options).pCalibrate,i18n("By calibrating the en- and decoder the time needed for en- and decoding is measured.\nThis time is only used to calculate the progress bar and the \"remaining time\"."));
        (*options).grid->addWidget((*options).pCalibrate,3,1);
        connect((*options).pCalibrate,SIGNAL(clicked()),this,SLOT(startCalibration()));

        // NOTE gleiche Breite der Buttons wäre nett
        (*options).pCancel = new KPushButton(KGlobal::iconLoader()->loadIcon("cancel",KIcon::Small),i18n("Cancel"),(*options).group,(*options).format);
        (*options).grid->addWidget((*options).pCancel,3,1);
        (*options).pCancel->hide();
        connect((*options).pCancel,SIGNAL(clicked()),this,SLOT(cancelCalibration()));
    }

    //QWidget *w = new QWidget(box,"w");
    //w->setMinimumSize(1,500);

    /*QVBoxLayout *stretchBox = new QVBoxLayout(box);
    stretchBox->addStretch();*/

    recalc();

    calibrate = new Calibrate();
    connect(this,SIGNAL(calibrationStart(QString,QString)),calibrate,SLOT(start(QString,QString)));
    connect(this,SIGNAL(calibrationCancel()),calibrate,SLOT(cancel()));
    connect(calibrate,SIGNAL(exited(int)),this,SLOT(calibrationExited(int)));
}

ConfigDialogueEnDecoder::~ConfigDialogueEnDecoder()
{
}

void ConfigDialogueEnDecoder::resetDefaults()
{
    KStandardDirs *stdDirs = new KStandardDirs();
    lTestFile->setText(stdDirs->findResource("data","soundkonverter/test.ogg"));
}

void ConfigDialogueEnDecoder::saveSettings()
{
    prefs.calibrationFile=lTestFile->text();

    for( FormatOptionsList::Iterator it=formatOptions.begin(); it!=formatOptions.end(); ++it ) {
        for( FileFormatList::Iterator jt=prefs.fileFormatList.begin(); jt!=prefs.fileFormatList.end(); ++jt ) {
            if( (*jt).extension == (*it).format ) {
                (*jt).encoder=(*it).cEncoder->currentText();
                (*jt).decoder=(*it).cDecoder->currentText();
                (*jt).replaygain=(*it).cReplayGain->currentText();
                /*for( BackendPlugins::PluginStructureList::Iterator kt=backendPlugins.plugins.begin(); kt!=backendPlugins.plugins.end(); ++kt ) {
                    if( (*kt).enc.bin == (*jt).encoder ) {
                        if( (*kt).enc.strength.enabled ) {
                            (*jt).compressionLevel=(*kt).enc.strength.range_max/(*kt).enc.strength.step;
                        }
                    }
                }
                if( (*jt).encTime == 0 ) (*jt).encTime=0.1; // NOTE I don't know, but this could be obsoleted by config.cpp:160
                if( (*jt).decTime == 0 ) (*jt).decTime=0.02;
                if( (*jt).repTime == 0 ) (*jt).repTime=0.02;*/
            }
        }
    }

    tools.calculateFileOpenStrings();

    generateServiceMenu();
}

void ConfigDialogueEnDecoder::showFileDialogue()
{
    KFileDialog *fileDialog;
    fileDialog = new KFileDialog( QDir::homeDirPath(), tools.sFileOpenString, 0, i18n("Choose a test file for the calibration!" ), true);
    fileDialog->setMode( KFile::ExistingOnly | KFile::LocalOnly );
    if( fileDialog->exec() == KDialog::Accepted ) {
        lTestFile->setText(fileDialog->selectedFile());
        emit configChanged();
    }
}

void ConfigDialogueEnDecoder::cfgChanged()
{
    emit configChanged();
}

void ConfigDialogueEnDecoder::encoderChanged()
{
    KStandardDirs *stdDirs = new KStandardDirs();

    for( FormatOptionsList::Iterator it=formatOptions.begin(); it!=formatOptions.end(); ++it)
    {
        if( (*it).format == QObject::sender()->name() ) {
            /*for( int i=0; i < (*it).cReplayGain->count(); i++ ) {
                if( (*it).cReplayGain->text(i) == i18n("built-in") ) (*it).cReplayGain->removeItem(i);
            }*/
            int i;
            if( i=(*it).sReplayGain->findIndex(i18n("built-in")) != -1 ) {
                (*it).sReplayGain->remove(i18n("built-in"));
                (*it).cReplayGain->removeItem(i);
            }
            BackendPlugins::PluginStructure plugin=backendPlugins.plugin((*it).cEncoder->currentText());
            if( plugin.enc.replaygain.enabled ) {
                (*it).cReplayGain->insertItem(QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledgreen.png")),i18n("built-in"));
                (*it).sReplayGain->append(i18n("built-in"));
            }
        }
    }
}

void ConfigDialogueEnDecoder::recalc()
{
    bool decoder=false;

    for( FormatOptionsList::Iterator it=formatOptions.begin(); it!=formatOptions.end(); ++it )
    {
        (*it).cEncoder->clear();
        (*it).sEncoder->clear();
        (*it).cDecoder->clear();
        (*it).sDecoder->clear();
        (*it).cReplayGain->clear();
        (*it).sReplayGain->clear();
        (*it).pCalibrate->setEnabled(false);
    }

    KStandardDirs *stdDirs = new KStandardDirs();

    for( BackendPlugins::PluginStructureList::Iterator it=backendPlugins.plugins.begin(); it!=backendPlugins.plugins.end(); ++it )
    {
        for( FormatOptionsList::Iterator jt=formatOptions.begin(); jt!=formatOptions.end(); ++jt )
        {
            if( (*it).enc.formats.findIndex((*jt).format) != -1 ) {
                for( QStringList::Iterator kt=prefs.backend.programs.begin(); kt!=prefs.backend.programs.end(); ++kt ) {
                    QString bin=(*kt).right((*kt).length()-(*kt).findRev('/')-1);
                    if( bin == (*it).enc.bin ) {
                        if( (*it).enc.level == BackendPlugins::Basic ) {
                            (*jt).cEncoder->insertItem(QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledred.png")),(*it).enc.bin);
                        }
                        else if( (*it).enc.level == BackendPlugins::Most ) {
                            (*jt).cEncoder->insertItem(QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledyellow.png")),(*it).enc.bin);
                        }
                        else {
                            (*jt).cEncoder->insertItem(QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledgreen.png")),(*it).enc.bin);
                        }
                        (*jt).sEncoder->append((*it).enc.bin);
                    }
                }
            }
            if( (*it).dec.formats.findIndex((*jt).format) != -1 ) {
                for( QStringList::Iterator kt=prefs.backend.programs.begin(); kt!=prefs.backend.programs.end(); ++kt ) {
                    QString bin=(*kt).right((*kt).length()-(*kt).findRev('/')-1);
                    if( bin == (*it).dec.bin ) {
                        if( (*it).dec.level == BackendPlugins::Basic ) {
                            (*jt).cDecoder->insertItem(QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledred.png")),(*it).dec.bin);
                        }
                        else if( (*it).dec.level == BackendPlugins::Most ) {
                            (*jt).cDecoder->insertItem(QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledyellow.png")),(*it).dec.bin);
                        }
                        else {
                            (*jt).cDecoder->insertItem(QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledgreen.png")),(*it).dec.bin);
                        }
                        (*jt).sDecoder->append((*it).dec.bin);
                    }
                }
            }
        }
    }

    for( ReplayGainPlugins::PluginStructureList::Iterator it=replayGainPlugins.plugins.begin(); it!=replayGainPlugins.plugins.end(); ++it )
    {
        for( FormatOptionsList::Iterator jt=formatOptions.begin(); jt!=formatOptions.end(); ++jt )
        {
            if( (*it).replaygain.formats.findIndex((*jt).format) != -1 ) {
                for( QStringList::Iterator kt=prefs.backend.programs.begin(); kt!=prefs.backend.programs.end(); ++kt ) {
                    QString bin=(*kt).right((*kt).length()-(*kt).findRev('/')-1);
                    if( bin == (*it).replaygain.bin ) {
                        if( (*it).replaygain.level == ReplayGainPlugins::Basic ) {
                            (*jt).cReplayGain->insertItem(QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledred.png")),(*it).replaygain.bin);
                        }
                        else if( (*it).replaygain.level == ReplayGainPlugins::Most ) {
                            (*jt).cReplayGain->insertItem(QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledyellow.png")),(*it).replaygain.bin);
                        }
                        else {
                            (*jt).cReplayGain->insertItem(QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledgreen.png")),(*it).replaygain.bin);
                        }
                        (*jt).sReplayGain->append((*it).replaygain.bin);
                        break;
                    }
                }
            }
        }
    }

    for( FormatOptionsList::Iterator it=formatOptions.begin(); it!=formatOptions.end(); ++it )
    {
        BackendPlugins::PluginStructure plugin=backendPlugins.plugin(prefs.fileFormat((*it).format).encoder);
        if( plugin.enc.replaygain.enabled && plugin.enc.bin == (*it).cEncoder->currentText() ) {
            (*it).cReplayGain->insertItem(QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledgreen.png")),i18n("built-in"));
            (*it).sReplayGain->append(i18n("built-in"));
        }
    }

    QString testExt=tools.fileExtension(lTestFile->text());

    for( FormatOptionsList::Iterator it=formatOptions.begin(); it!=formatOptions.end(); ++it)
    {
        for( int index = 0; index < (*it).cEncoder->count(); index++)
        {
            if( (*it).cEncoder->text(index) == prefs.fileFormat((*it).format).encoder ) {
                (*it).cEncoder->setCurrentItem(index);
                break;
            }
        }
        for( int index = 0; index < (*it).cDecoder->count(); index++)
        {
            if( (*it).cDecoder->text(index) == prefs.fileFormat((*it).format).decoder ) {
                (*it).cDecoder->setCurrentItem(index);
                break;
            }
        }
        for( int index = 0; index < (*it).cReplayGain->count(); index++)
        {
            if( (*it).cReplayGain->text(index) == prefs.fileFormat((*it).format).replaygain ) {
                (*it).cReplayGain->setCurrentItem(index);
                break;
            }
        }

        if( ( (*it).cEncoder->count() > 0 || (*it).format == testExt ) /*&& (*it).format != "swav"*/ ) { //FIXME very bad hack
            (*it).pCalibrate->setEnabled(true);
        }

        if( (*it).format == testExt && (*it).cDecoder->count() > 0 ) {
            decoder=true;
        }
    }

    if( !decoder && testExt != "wav" ) {
        for( FormatOptionsList::Iterator it=formatOptions.begin(); it!=formatOptions.end(); ++it )
        {
            (*it).pCalibrate->setEnabled(false);
        }
    }
}

void ConfigDialogueEnDecoder::reload()
{
    for( FormatOptionsList::Iterator it=formatOptions.begin(); it!=formatOptions.end(); ++it)
    {
        delete (*it).lEncoder;
        disconnect((*it).cEncoder,SIGNAL(activated(int)),0,0);
        delete (*it).cEncoder;
        delete (*it).sEncoder;
        delete (*it).lEncTimeLabel;
        delete (*it).lEncTime;

        delete (*it).lDecoder;
        disconnect((*it).cDecoder,SIGNAL(activated(int)),0,0);
        delete (*it).cDecoder;
        delete (*it).sDecoder;
        delete (*it).lDecTimeLabel;
        delete (*it).lDecTime;

        delete (*it).lReplayGain;
        disconnect((*it).cReplayGain,SIGNAL(activated(int)),0,0);
        delete (*it).cReplayGain;
        delete (*it).sReplayGain;
        delete (*it).lRepTimeLabel;
        delete (*it).lRepTime;

        disconnect((*it).pCalibrate,SIGNAL(clicked()),0,0);
        delete (*it).pCalibrate;

        disconnect((*it).pCancel,SIGNAL(clicked()),0,0);
        delete (*it).pCancel;

        delete (*it).grid;
        delete (*it).group;
    }

    formatOptions.clear();

    delete box;
    delete sv;
    delete grid;

    char cTime[8];

    grid = new QGridLayout( this );
    sv = new QScrollView( this, "sv" );
    sv->setResizePolicy(QScrollView::AutoOneFit);
    grid->addWidget(sv,0,0);
    box = new QVBox( sv->viewport() );
    box->setMargin(10);
    box->setSpacing(5);
    sv->addChild(box);

    QHBox *fileBox = new QHBox(box);
    fileBox->setMargin(0);
    fileBox->setSpacing(5);
    QLabel *lTestFileLabel = new QLabel(i18n("File for calibration")+":",fileBox,"lTestFileLabel");
    lTestFile = new QLineEdit(fileBox,"lTestFile");
    lTestFile->setText(prefs.calibrationFile);
    QToolTip::add(lTestFile,i18n("A file for test en- and decoding to detect the conversion speed."));
    connect(lTestFile,SIGNAL(textChanged(const QString&)),this,SLOT(updateCalibrateButtons()));
    pSelectFile = new QPushButton( " ", fileBox, "pSelectFile" );
    pSelectFile->setPixmap( KGlobal::iconLoader()->loadIcon("folder",KIcon::Toolbar) );
    QToolTip::add( pSelectFile, i18n("Select a file for the calibration.") );
    connect(pSelectFile,SIGNAL(clicked()),this,SLOT(showFileDialogue()));

    QHBox *legendBox = new QHBox(box);
    legendBox->setMargin(0);
    legendBox->setSpacing(0);
    KStandardDirs *stdDirs = new KStandardDirs();
    QLabel *lLegendLabel = new QLabel(i18n("Legend")+":",legendBox,"lLegendLabel");
    QLabel *lLegendGreen = new QLabel("",legendBox,"lLegendGreen");
    lLegendGreen->setPixmap(QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledgreen.png")));
    QLabel *lLegendFull = new QLabel("= "+i18n("Full support")+"    ",legendBox,"lLegendFull");
    QLabel *lLegendYellow = new QLabel("",legendBox,"lLegendYellow");
    lLegendYellow->setPixmap(QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledyellow.png")));
    QLabel *lLegendMost = new QLabel("= "+i18n("Most supported")+"    ",legendBox,"lLegendMost");
    QLabel *lLegendRed = new QLabel("",legendBox,"lLegendRed");
    lLegendRed->setPixmap(QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledred.png")));
    QLabel *lLegendBasic = new QLabel("= "+i18n("Basic support"),legendBox,"lLegendBasic");
    legendBox->setStretchFactor(lLegendLabel,1);

    for( FileFormatList::Iterator it=prefs.fileFormatList.begin(); it!=prefs.fileFormatList.end(); ++it )
    {
        FormatOptionsList::Iterator options=formatOptions.append(FormatOptions((*it).extension));

        (*options).group = new QGroupBox((*options).format,box,"group");
        (*options).group->setColumnLayout(0,Qt::Vertical);
        (*options).group->layout()->setSpacing(5);
        (*options).group->layout()->setMargin(10);
        (*options).grid = new QGridLayout((*options).group->layout());

        (*options).lEncoder = new QLabel(i18n("Encoder")+":",(*options).group,"lEncoder");
        (*options).grid->addWidget((*options).lEncoder,0,0);
        (*options).cEncoder = new QComboBox((*options).group,(*options).format);
        connect((*options).cEncoder,SIGNAL(activated(int)),this,SLOT(cfgChanged()));
        connect((*options).cEncoder,SIGNAL(activated(int)),this,SLOT(encoderChanged()));
        (*options).sEncoder = new QStringList();
        (*options).grid->addWidget((*options).cEncoder,0,1);
        (*options).lEncTimeLabel = new QLabel(i18n("Time")+":",(*options).group,"lEncTimeLabel");
        (*options).grid->addWidget((*options).lEncTimeLabel,0,2);
        sprintf(cTime,"%.4f",(*it).encTime);
        (*options).lEncTime = new QLabel(cTime,(*options).group,"lEncTime");
        (*options).lEncTime->setFont(QFont("Courier"));
        (*options).grid->addWidget((*options).lEncTime,0,3);

        (*options).lDecoder = new QLabel(i18n("Decoder")+":",(*options).group,"lDecoder");
        (*options).grid->addWidget((*options).lDecoder,1,0);
        (*options).cDecoder = new QComboBox((*options).group,"cDecoder");
        connect((*options).cDecoder,SIGNAL(activated(int)),this,SLOT(cfgChanged()));
        (*options).sDecoder = new QStringList();
        (*options).grid->addWidget((*options).cDecoder,1,1);
        (*options).lDecTimeLabel = new QLabel(i18n("Time")+":",(*options).group,"lDecTimeLabel");
        (*options).grid->addWidget((*options).lDecTimeLabel,1,2);
        sprintf(cTime,"%.4f",(*it).decTime);
        (*options).lDecTime = new QLabel(cTime,(*options).group,"lDecTime");
        (*options).lDecTime->setFont(QFont("Courier"));
        (*options).grid->addWidget((*options).lDecTime,1,3);

        (*options).lReplayGain = new QLabel(i18n("ReplayGain")+":",(*options).group,"lReplayGain");
        (*options).grid->addWidget((*options).lReplayGain,2,0);
        (*options).cReplayGain = new QComboBox((*options).group,"cReplayGain");
        connect((*options).cReplayGain,SIGNAL(activated(int)),this,SLOT(cfgChanged()));
        (*options).sReplayGain = new QStringList();
        (*options).grid->addWidget((*options).cReplayGain,2,1);
        (*options).lRepTimeLabel = new QLabel(i18n("Time")+":",(*options).group,"lRepTimeLabel");
        (*options).grid->addWidget((*options).lRepTimeLabel,2,2);
        sprintf(cTime,"%.4f",(*it).repTime);
        (*options).lRepTime = new QLabel(cTime,(*options).group,"lRepTime");
        (*options).lRepTime->setFont(QFont("Courier"));
        (*options).grid->addWidget((*options).lRepTime,2,3);

        (*options).pCalibrate = new KPushButton(KGlobal::iconLoader()->loadIcon("kgpg_edit",KIcon::Small),i18n("Calibrate"),(*options).group,(*options).format);
        QToolTip::add((*options).pCalibrate,i18n("By calibrating the en- and decoder the time needed for en- and decoding is measured.\nThis time is only used to calculate the progress bar and the \"remaining time\"."));
        (*options).grid->addWidget((*options).pCalibrate,3,1);
        connect((*options).pCalibrate,SIGNAL(clicked()),this,SLOT(startCalibration()));

        // NOTE gleiche Breite der Buttons wäre nett
        (*options).pCancel = new KPushButton(KGlobal::iconLoader()->loadIcon("cancel",KIcon::Small),i18n("Cancel"),(*options).group,(*options).format);
        (*options).grid->addWidget((*options).pCancel,3,1);
        (*options).pCancel->hide();
        connect((*options).pCancel,SIGNAL(clicked()),this,SLOT(cancelCalibration()));
    }

    recalc();
}

void ConfigDialogueEnDecoder::updateCalibrateButtons()
{
    QString testExt=tools.fileExtension(lTestFile->text());

    for( FormatOptionsList::Iterator it=formatOptions.begin(); it!=formatOptions.end(); ++it)
    {
        if( (*it).cEncoder->count() > 0 || (*it).format == testExt ) {
            (*it).pCalibrate->setEnabled(true);
        }
        else {
            (*it).pCalibrate->setEnabled(false);
        }
    }
}

void ConfigDialogueEnDecoder::startCalibration()
{
    for( FormatOptionsList::Iterator it=formatOptions.begin(); it!=formatOptions.end(); ++it)
    {
        (*it).pCalibrate->setEnabled(false);
        if( (*it).format == QObject::sender()->name() ) {
            (*it).pCalibrate->hide();
            (*it).pCancel->show();
        }
    }

    emit calibrationStart(lTestFile->text(),QObject::sender()->name());
}

void ConfigDialogueEnDecoder::cancelCalibration()
{
    emit calibrationCancel();
}

void ConfigDialogueEnDecoder::calibrationExited(int)
{
    char cTime[16];
    QString testExt=tools.fileExtension(lTestFile->text());

    formatOptions.first().pCalibrate->setEnabled(true);

    for( FormatOptionsList::Iterator it=formatOptions.begin(); it!=formatOptions.end(); ++it)
    {
        sprintf(cTime,"%.4f",prefs.fileFormat((*it).format).encTime);
        (*it).lEncTime->setText(cTime);
        sprintf(cTime,"%.4f",prefs.fileFormat((*it).format).decTime);
        (*it).lDecTime->setText(cTime);
        sprintf(cTime,"%.4f",prefs.fileFormat((*it).format).repTime);
        (*it).lRepTime->setText(cTime);

        if( (*it).cEncoder->count() > 0 || (*it).format == testExt ) {
            (*it).pCalibrate->setEnabled(true);
        }

        (*it).pCancel->hide(); // This could stand in the if case above
        (*it).pCalibrate->show(); // "
    }
}

void ConfigDialogueEnDecoder::generateServiceMenu()
{
    int num=0;
    QString content;
    content += "[Desktop Entry]\n";
    content += "ServiceTypes=";

    for( BackendPlugins::PluginStructureList::Iterator it=backendPlugins.plugins.begin(); it!=backendPlugins.plugins.end(); ++it ) {
        if( (*it).dec.mime_types != "" ) {
            content += (*it).dec.mime_types+",";
            num++;
        }
    }

    if(num==0) return;

    content += "audio/x-wav";

    content += "\n";
    content += "Icon=soundkonverter\n";
    content += "Actions=ConvertWithSoundkonverter\n\n";

    content += "[Desktop Action ConvertWithSoundkonverter]\n";
    content += "Name="+i18n("Convert with soundKonverter...")+"\n";
    content += "Icon=soundkonverter\n";
    content += "Exec=soundkonverter %F\n";

    QFile file( locateLocal("data","konqueror/servicemenus/")+"convert_with_soundkonverter.desktop" );
    if ( file.open( IO_WriteOnly ) ) {
        QTextStream stream( &file );
        stream << content;
        file.close();
    }


    num=0;
    content="";
    content += "[Desktop Entry]\n";
    content += "ServiceTypes=";

    for( ReplayGainPlugins::PluginStructureList::Iterator it=replayGainPlugins.plugins.begin(); it!=replayGainPlugins.plugins.end(); ++it ) {
        if( (*it).replaygain.mime_types != "" ) {
            content += (*it).replaygain.mime_types+",";
            num++;
        }
    }

    if(num==0) return;

    content = content.left(content.length()-1);

    content += "\n";
    content += "Icon=soundkonverter_replaygain\n";
    content += "Actions=AddReplayGainWithSoundkonverter\n\n";

    content += "[Desktop Action AddReplayGainWithSoundkonverter]\n";
    content += "Name="+i18n("Add ReplayGain with soundKonverter...")+"\n";
    content += "Icon=soundkonverter_replaygain\n";
    content += "Exec=soundkonverter --replaygain %F\n";

    file.setName( locateLocal("data","konqueror/servicemenus/")+"add_replaygain_with_soundkonverter.desktop" );
    if ( file.open( IO_WriteOnly ) ) {
        QTextStream stream( &file );
        stream << content;
        file.close();
    }
}


