

#include "filelist.h"
#include "processoptions.h"
#include "config.h"
#include "tools.h"

#include <qlayout.h>
#include <qstringlist.h>
#include <qfileinfo.h>
#include <qevent.h>
#include <qdragobject.h>
#include <qdir.h>
#include <qheader.h>
#include <qtooltip.h>

#include <klocale.h>
#include <klistview.h>
#include <kstandarddirs.h>
#include <kiconloader.h>
#include <kpushbutton.h>


FileList::FileList( QWidget *parent, const char *name )
    : QWidget( parent, name )
{
    setAcceptDrops(true);

    QGridLayout *grid = new QGridLayout( this, 1, 2, 0, 5 );

    lList = new KListView( this, "lList" );
    lList->addColumn( "Params", 0 );
    lList->addColumn( i18n("State") );
    lList->addColumn( i18n("File") );
    lList->addColumn( i18n("Output") );
    lList->addColumn( i18n("Quality") );
    lList->addColumn( i18n("Bitrate range") );
    lList->addColumn( i18n("Mode") );
    lList->addColumn( i18n("Sampling rate") );
    lList->addColumn( i18n("Channels") );
    lList->addColumn( i18n("ReplayGain") );
    //lList->setResizeMode( QListView::LastColumn );
    lList->setSelectionMode( QListView::Extended );
    lList->setAllColumnsShowFocus(true);
    lList->setSorting(-1);
    lList->setMinimumHeight( 130 );
    updateLook();
    grid->addWidget( lList, 0, 0 );

    QVBoxLayout *editBox = new QVBoxLayout( -1, "editBox" );
    grid->addLayout( editBox, 0, 1 );

    KPushButton *pTop = new KPushButton( " ", this, "pTop" );
    pTop->setPixmap( KGlobal::iconLoader()->loadIcon("top",KIcon::Toolbar) );
    QToolTip::add( pTop, i18n("Move the selection to the top.") );
    editBox->addWidget( pTop );
    connect(pTop,SIGNAL(clicked()),this,SLOT(top()));

    KPushButton *pUp = new KPushButton( " ", this, "pUp" );
    pUp->setPixmap( KGlobal::iconLoader()->loadIcon("up",KIcon::Toolbar) );
    QToolTip::add( pUp, i18n("Move the selection one step up.") );
    editBox->addWidget( pUp );
    connect(pUp,SIGNAL(clicked()),this,SLOT(up()));

    KPushButton *pInvert = new KPushButton( " ", this, "pInvert" );
    pInvert->setPixmap( KGlobal::iconLoader()->loadIcon("reload",KIcon::Toolbar) );
    QToolTip::add( pInvert, i18n("Invert the selection.") );
    editBox->addWidget( pInvert );
    connect(pInvert,SIGNAL(clicked()),this,SLOT(invert()));

    KPushButton *pRemove = new KPushButton( " ", this, "pRemove" );
    pRemove->setPixmap( KGlobal::iconLoader()->loadIcon("fileclose",KIcon::Toolbar) );
    QToolTip::add( pRemove, i18n("Remove the selection.") );
    editBox->addWidget( pRemove );
    connect(pRemove,SIGNAL(clicked()),this,SLOT(remove()));

    KPushButton *pDown = new KPushButton( " ", this, "pDown" );
    pDown->setPixmap( KGlobal::iconLoader()->loadIcon("down",KIcon::Toolbar) );
    QToolTip::add( pDown, i18n("Move the selection one step down.") );
    editBox->addWidget( pDown );
    connect(pDown,SIGNAL(clicked()),this,SLOT(down()));

    KPushButton *pBottom = new KPushButton( " ", this, "pBottom" );
    pBottom->setPixmap( KGlobal::iconLoader()->loadIcon("bottom",KIcon::Toolbar) );
    QToolTip::add( pBottom, i18n("Move the selection to the bottom.") );
    editBox->addWidget( pBottom );
    connect(pBottom,SIGNAL(clicked()),this,SLOT(bottom()));

    editBox->addStretch();

    readList();
}

FileList::~FileList()
{
}

void FileList::updateLook()
{
    lList->setFont(prefs.fileListFont);
    lList->adjustColumn(1);
    lList->adjustColumn(2);
    lList->adjustColumn(3);
    lList->adjustColumn(4);
    lList->adjustColumn(5);
    lList->adjustColumn(6);
    lList->adjustColumn(7);
    lList->adjustColumn(8);
    lList->adjustColumn(9);
}

void FileList::addFile( QStringList options )
{
    QStringList::Iterator it=options.begin();

    KListViewItem *item=new KListViewItem(lList,lList->lastItem());

    item->setText(0,*it); it++;
    item->setText(column(i18n("File")),*it); it++;
    item->setText(column(i18n("Output")),*it); it++;
    item->setText(column(i18n("Quality")),*it); it++;
    item->setText(column(i18n("Bitrate range")),*it); it++;
    item->setText(column(i18n("Mode")),*it); it++;
    item->setText(column(i18n("Sampling rate")),*it); it++;
    item->setText(column(i18n("Channels")),*it); it++;
    item->setText(column(i18n("ReplayGain")),*it); it++;
    item->setText(column(i18n("State")),*it);
}

void FileList::invert()
{
    lList->invertSelection();
}

// TODO werden die Zeiten richtig abgezogen? ich glaube ja - 30.01.06
void FileList::remove()
{
    QListViewItem *item = lList->firstChild(), *nextitem = 0;

    while( item != 0 ) {
        if( lList->isSelected( item ) ) {
            if( item != actFile.pItem ) {
                nextitem = item->nextSibling();
                lList->takeItem( item );

                QString params = item->text( 0 );
                QStringList paramList = QStringList::split("$soundkonverter-spacer$",params);
                QStringList::Iterator it=paramList.begin();
                QString sInputFormat = tools.fileExtension(*it);
                it++;
                QString sOutputFormat = *it;
                it+=6;
                QString sReplayGain = *it;
                if( sInputFormat != "wav" ) {
                    emit timeRemoved( tools.timeByFile(item->text(column(i18n("File"))))*prefs.fileFormat(sInputFormat).decTime );
                }
                if( sOutputFormat != "wav" ) {
                    emit timeRemoved( tools.timeByFile(item->text(column(i18n("File"))))*prefs.fileFormat(sOutputFormat).encTime );
                }
                if( sReplayGain == i18n("yes") ) {
                    emit timeRemoved( tools.timeByFile(item->text(column(i18n("File"))))*prefs.fileFormat(sOutputFormat).repTime );
                }
                //#ifdef DEBUG
                //system( QString("echo \"remove file: ").append(item->text(column(i18n("File")))).append("\" >> ~/debug.txt") );
                //#endif

            }
        }

        if( nextitem != 0 ) { item = nextitem; nextitem = 0; }
        else { item = item->nextSibling(); }
    }
}

void FileList::up()
{
    QListViewItem *item = lList->firstChild(), *topItem;
    bool prev = false;

    while( item != 0 ) {
        if( lList->isSelected( item ) ) {
            if( !prev ) {
                topItem = item->itemAbove();
                if( topItem != 0 ) { topItem->moveItem( item ); }
                prev = true;
            }
        }
        else {
            prev = false;
        }
        item = item->nextSibling( );
    }
}

void FileList::down()
{
    QListViewItem *item = lList->firstChild(), *topItem, *lastItem;
    int count = 0;

    while( item != 0 ) {
        if( lList->isSelected( item ) ) {
            count++;
            item = item->nextSibling( );
        }
        else {
            lastItem = item->nextSibling( );
            while( count > 0 ) {
                topItem = item->itemAbove();
                if( topItem != 0 ) { topItem->moveItem( item ); }
                count--;
            }
            item = lastItem;
        }
    }
}

void FileList::top()
{
    QListViewItem *item = lList->firstChild(), *topItem, *lastItem;
    int count = 0, i;

    while( item != 0 ) {
        count++;
        if( lList->isSelected( item ) ) {
            i = --count;
            lastItem = item->nextSibling( );
            while( i-- > 0 ) {
                topItem = item->itemAbove();
                if( topItem != 0 ) { topItem->moveItem( item ); }
            }
            item = lastItem;
        }
        else {
            item = item->nextSibling( );
        }
    }
}

void FileList::bottom()
{
    QListViewItem *item = lList->firstChild(), *topItem;
    int count = 0;

    while( item != 0 ) {
        if( lList->isSelected( item ) ) {
            count++;
        }
        else {
            while( count > 0 ) {
                topItem = item->itemAbove();
                if( topItem != 0 ) { topItem->moveItem( item ); }
                count--;
            }
        }
        item = item->nextSibling( );
    }
}

void FileList::removeFirstFile()
{
    lList->takeItem( actFile.pItem );
    actFile.pItem=0;
}

QListViewItem* FileList::firstFile()
{
    return lList->firstChild();
}

void FileList::dragEnterEvent(QDragEnterEvent *e)
{
    e->accept( QUriDrag::canDecode(e) );
}

void FileList::dropEvent(QDropEvent *e)
{
    emit dropped(e);
}

void FileList::listAllFiles(QString directory)
{
    QStringList list;
    QDir dir;
    QFileInfo file;
    QString format;

    dir.setPath(directory);
    list=dir.entryList("*",QDir::All,QDir::Name);

    for( QStringList::Iterator it=list.begin(); it!=list.end(); ++it )
    {
        if( *it != "." && *it != ".." )
        {
            file.setFile(directory+"/"+*it);
            if( file.isFile() ) {
                format=tools.fileExtension(*it);
                if( tools.supportedFormats.contains(format) ) {
                    dirFileList.append(file.filePath());
                }
            }
            else if( file.isDir() ) {
                listAllFiles(file.filePath());
            }
        }
    }
}

int FileList::column(QString text)
{
    for( int i=0; i<lList->columns(); i++ )
    {
        if( text == lList->columnText(i) ) return i;
    }

    return -1;
}

void FileList::readList()
{
    QStringList params;

    QFile file( locateLocal("data","soundkonverter/")+"filelist" );
    if ( file.open( IO_ReadOnly ) ) {
        QTextStream stream( &file );
        while ( !stream.atEnd() ) {
            params.clear();
            params.append(stream.readLine().latin1());
            params.append(stream.readLine().latin1());
            params.append(stream.readLine().latin1());
            params.append(stream.readLine().latin1());
            params.append(stream.readLine().latin1());
            params.append(stream.readLine().latin1());
            params.append(stream.readLine().latin1());
            params.append(stream.readLine().latin1());
            params.append(stream.readLine().latin1());
            params.append(stream.readLine().latin1());
            addFile(params);
            emit timeAdded(200); // FIXME That's not correct, but it just happens when soundkonverter crashs
        }
        file.close();
    }
}

void FileList::saveList()
{
    QListViewItem *item = lList->firstChild();

    QFile file( locateLocal("data","soundkonverter/")+"filelist" );
    if ( file.open( IO_WriteOnly ) ) {
        QTextStream stream( &file );
        while( item != 0 ) {
            stream << item->text(0) << "\n";
            stream << item->text(column(i18n("File"))) << "\n";
            stream << item->text(column(i18n("Output"))) << "\n";
            stream << item->text(column(i18n("Quality"))) << "\n";
            stream << item->text(column(i18n("Bitrate range"))) << "\n";
            stream << item->text(column(i18n("Mode"))) << "\n";
            stream << item->text(column(i18n("Sampling rate"))) << "\n";
            stream << item->text(column(i18n("Channels"))) << "\n";
            stream << item->text(column(i18n("ReplayGain"))) << "\n";
            stream << item->text(column(i18n("State"))) << "\n";
            item = item->nextSibling( );
        }
        file.close();
    }
}

void FileList::resetList()
{
    QFile file( locateLocal("data","soundkonverter/")+"filelist" );
    file.remove();
}

