
#include "logviewer.h"
#include "logger.h"

#include <qlayout.h>
#include <qstring.h>
#include <qheader.h>
#include <qcolor.h>

#include <klocale.h>
#include <kiconloader.h>
#include <klistview.h>
#include <kpushbutton.h>
#include <kurl.h>
//#include <kdebug.h>

// ### soundkonverter 0.4: make sub items for the output

LogViewerItem::LogViewerItem( KListView* parent, LogViewerItem* after, QString label1 )
    : KListViewItem( parent, after, label1 )
{
    converting = false;
}

LogViewerItem::LogViewerItem( LogViewerItem* parent, LogViewerItem* after, QString label1 )
    : KListViewItem( parent, after, label1 )
{
    converting = false;
}

LogViewerItem::~LogViewerItem()
{}

void LogViewerItem::paintCell( QPainter *p, const QColorGroup &cg, int column, int width, int alignment )
{
    // NOTE calculate the red color

    QColorGroup _cg( cg );
    QColor c;

    if( isSelected() && converting ) {
        _cg.setColor( QColorGroup::Highlight, QColor( 215, 62, 62 ) );
        QListViewItem::paintCell( p, _cg, column, width, alignment );
        return;
    }
    else if( converting && column != listView()->sortColumn() ) {
        _cg.setColor( QColorGroup::Base, QColor( 255, 234, 234 ) );
        QListViewItem::paintCell( p, _cg, column, width, alignment );
        return;
    }
    else if( converting && column == listView()->sortColumn() ) {
        _cg.setColor( QColorGroup::Base, QColor( 247, 227, 227 ) );
        QListViewItem::paintCell( p, _cg, column, width, alignment );
        return;
    }

    KListViewItem::paintCell( p, _cg, column, width, alignment );
}


LogViewerList::LogViewerList( QWidget* parent, const char* name )
    : KListView( parent, name )
{}

LogViewerList::~LogViewerList()
{}


LogViewer::LogViewer( Logger* _logger, QWidget *parent, const char *name, bool modal, WFlags f )
    : KDialog( parent, name, modal, f )
{
    logger = _logger;
    connect( logger, SIGNAL(removedProcess(int)),
               this, SLOT(processRemoved(int))
             );
    connect( logger, SIGNAL(updateProcess(int)),
               this, SLOT(updateProcess(int))
             );

    // create an icon loader object for loading icons
    KIconLoader* iconLoader = new KIconLoader();

    setCaption( i18n("Log Viewer") );
    resize( 600, 400 );
    setIcon( iconLoader->loadIcon("view_text",KIcon::Small) );

    QGridLayout *grid = new QGridLayout( this, 4, 1, 11, 6 );

    lLogs = new LogViewerList( this, "lLogs" );
    lLogs->addColumn( i18n("Job/File") );
    //lLogs->setSelectionMode( QListView::Extended );
    //lLogs->setAllColumnsShowFocus( true );
    lLogs->setResizeMode( QListView::LastColumn );
    lLogs->setSorting( -1 );
    lLogs->setRootIsDecorated( true );
    lLogs->header()->setClickEnabled( false );
    grid->addWidget( lLogs, 0, 0 );

    QHBoxLayout *buttonBox = new QHBoxLayout();
    grid->addLayout( buttonBox, 3, 0 );

    pReload = new KPushButton(iconLoader->loadIcon("reload",KIcon::Small), i18n("Reload"), this, "pReload" );
    buttonBox->addWidget( pReload );
    connect( pReload, SIGNAL(clicked()),
               this, SLOT(refillLogs())
             );

    buttonBox->addStretch();

    pOk = new KPushButton(iconLoader->loadIcon("exit",KIcon::Small), i18n("Close"), this, "pOk" );
    pOk->setFocus();
    buttonBox->addWidget( pOk );
    connect( pOk, SIGNAL(clicked()),
               this, SLOT(accept())
             );

    // delete the icon loader object
    delete iconLoader;

    refillLogs();
}

LogViewer::~LogViewer()
{}

void LogViewer::refillLogs()
{
    LogViewerItem *parent = 0, *last = 0;

    lLogs->clear();
    QValueList<LoggerItem*> logs = logger->getLogs();
    for( QValueList<LoggerItem*>::Iterator a = logs.begin(); a != logs.end(); ++a ) {
        parent = new LogViewerItem( lLogs, parent, KURL::decode_string((*a)->filename).replace("%2f","/").replace("%%","%") + " - " + QString::number((*a)->id) );
        parent->converting = !(*a)->completed;
        //parent->setOpen( true );
        last = 0;
        for( QStringList::Iterator b = (*a)->data.begin(); b != (*a)->data.end(); ++b ) {
            last = new LogViewerItem( parent, last, *b );
            last->setMultiLinesEnabled( true );
            last->converting = !(*a)->completed;
        }
    }
}

void LogViewer::processRemoved( int id )
{
    LoggerItem* item = logger->getLog( id ); // this is ok, because the item still exists.
                                             // it will be deleted after is function is completed

    QListViewItem* it = lLogs->firstChild();

    while( it != 0 ) {
        if( it->text(0) == KURL::decode_string(item->filename).replace("%2f","/").replace("%%","%") + " - " + QString::number(item->id) ) {
            delete it;
            return;
        }
        it = it->nextSibling();
    }
}

void LogViewer::updateProcess( int id )
{
    LoggerItem* item = logger->getLog( id );

    LogViewerItem* it = lLogs->firstChild();

    LogViewerItem *lastItem = 0, *oldItem = 0;

    while( it != 0 ) {
        if( it->text(0) == KURL::decode_string(item->filename).replace("%2f","/").replace("%%","%") + " - " + QString::number(item->id) ) {
            LogViewerItem *a = it->firstChild(), *b;
            while( a != 0 ) {
                b = a->nextSibling();
                delete a;
                a = b;
            }
            it->converting = !item->completed;
            LogViewerItem* last = 0;
            for( QStringList::Iterator b = item->data.begin(); b != item->data.end(); ++b ) {
                last = new LogViewerItem( (LogViewerItem*)it, last, *b );
                last->setMultiLinesEnabled( true );
            }
            return;
        }
        it = it->nextSibling();
    }

    LogViewerItem *parent = 0;

    // get the last list view item
    for( QListViewItem* it = lLogs->firstChild(); it != 0; it = it->nextSibling() ) {
        lastItem = (LogViewerItem*)it;
    }

    parent = new LogViewerItem( lLogs, lastItem, KURL::decode_string(item->filename).replace("%2f","/").replace("%%","%") + " - " + QString::number(item->id) );
    parent->converting = !item->completed;
    LogViewerItem* last = 0;
    for( QStringList::Iterator b = item->data.begin(); b != item->data.end(); ++b ) {
        last = new LogViewerItem( parent, last, *b );
        last->setMultiLinesEnabled( true );
    }
}


