// (c) 2006 Martin Aumueller <aumuell@reserv.at>
// modified 2006 Daniel Faust <hessijames@gmail.com>
// See COPYING file for licensing information

#include "taglib_optimfrogfiletyperesolver.h"
#include <taglib/mpcfile.h>

TagLib::File *OptimFrogFileTypeResolver::createFile(const char *fileName,
        bool readProperties,
        TagLib::AudioProperties::ReadStyle propertiesStyle) const
{
    const char *ext = strrchr(fileName, '.');
    if(ext && !strcasecmp(ext, ".ofr"))
    {
        return new TagLib::MPC::File(fileName, readProperties, propertiesStyle);
    }

    return 0;
}
