
#include "replaygainscanner.h"
#include "logger.h"
#include "combobutton.h"
#include "config.h"
#include "dirdialog.h"

#include <qlayout.h>
#include <qstringlist.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qtooltip.h>

#include <klocale.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include <kpushbutton.h>
#include <kprogress.h>

// FIXME file name encoding !!!


ReplayGainScanner::ReplayGainScanner( TagEngine* _tagEngine, Config* _config, Logger* _logger, QWidget *parent, const char *name, bool modal, WFlags f )
    : KDialog( parent, name, modal, f )
{
    tagEngine = _tagEngine;
    config = _config;
    logger = _logger;

    // create an icon loader object for loading icons
    KIconLoader* iconLoader = new KIconLoader();

    setCaption( i18n("Replay Gain Tool") );
    resize( 600, 400 );
    setIcon( iconLoader->loadIcon("soundkonverter_replaygain",KIcon::Small) );

    QGridLayout* grid = new QGridLayout( this, 4, 1, 11, 6 );

    QHBoxLayout* filterBox = new QHBoxLayout();
    grid->addLayout( filterBox, 0, 0 );

    cAdd = new ComboButton( this, "cAdd" );
    cAdd->insertItem( iconLoader->loadIcon("folder",KIcon::Small),i18n("Add Folder ...") );
    cAdd->insertItem( iconLoader->loadIcon("sound",KIcon::Small),i18n("Add Files ...") );
    filterBox->addWidget( cAdd );
    connect( cAdd, SIGNAL(clicked(int)),
               this, SLOT(addClicked(int))
             );

    filterBox->addStretch();

    cForce = new QCheckBox( i18n("Force recalculation"), this, "cForce" );
    QToolTip::add( cForce, i18n("Recalculate Replay Gain tag for files that already have a Replay Gain tag set.") );
    filterBox->addWidget( cForce );

    /*QLabel *lFilter=new QLabel(i18n("Show:"),this,"lFilter");
    filterBox->addWidget(lFilter);

    cFilter=new QComboBox(this,"cFilter");
    cFilter->insertItem(i18n("All"));
    cFilter->insertItem(i18n("With Replay Gain"));
    cFilter->insertItem(i18n("Without Replay Gain"));
    cFilter->insertItem(i18n("Unknown"));
    filterBox->addWidget(cFilter);*/

    lList = new ReplayGainFileList( tagEngine, config, logger, this, "lList" );
    grid->addWidget( lList, 1, 0 );
    connect( this, SIGNAL(addFile(const QString&)),
               lList, SLOT(addFile(const QString&))
             );
    connect( this, SIGNAL(addDir(const QString&,const QStringList&)),
               lList, SLOT(addDir(const QString&,const QStringList&))
             );
    connect( this, SIGNAL(calcAllReplayGain(bool)),
               lList, SLOT(calcAllReplayGain(bool))
             );
    connect( this, SIGNAL(removeAllReplayGain()),
               lList, SLOT(removeAllReplayGain())
             );
    connect( this, SIGNAL(cancelProcess()),
               lList, SLOT(cancelProcess())
             );
    connect( lList, SIGNAL(processStarted()),
               this, SLOT(processStarted())
             );
    connect( lList, SIGNAL(processStopped()),
               this, SLOT(processStopped())
             );
    connect( lList, SIGNAL(updateProgress(int,int)),
               this, SLOT(updateProgress(int,int))
             );

    QHBoxLayout* progressBox = new QHBoxLayout();
    grid->addLayout( progressBox, 2, 0 );

    pProgressBar = new KProgress( this, "pProgressBar" );
    progressBox->addWidget( pProgressBar );

    QHBoxLayout* buttonBox = new QHBoxLayout();
    grid->addLayout( buttonBox, 3, 0 );

    pTagVisible = new KPushButton( iconLoader->loadIcon("apply",KIcon::Small), i18n("Tag untagged"), this, "pTagVisible" );
    QToolTip::add( pTagVisible, i18n("Calculate Replay Gain tag for all files in the file list without Replay Gain tag.") );
    buttonBox->addWidget( pTagVisible );
    connect( pTagVisible, SIGNAL(clicked()),
               this, SLOT(calcReplayGainClicked())
             );

    pRemoveTag = new KPushButton( iconLoader->loadIcon("cancel",KIcon::Small), i18n("Untag tagged"), this, "pRemoveTag" );
    QToolTip::add( pRemoveTag, i18n("Remove the Replay Gain tag from all files in the file list.") );
    buttonBox->addWidget( pRemoveTag );
    connect( pRemoveTag, SIGNAL(clicked()),
               this, SLOT(removeReplayGainClicked())
             );

    pCancel = new KPushButton( iconLoader->loadIcon("cancel",KIcon::Small),i18n("Cancel"), this, "pCancel" );
    pCancel->hide();
    buttonBox->addWidget( pCancel );
    connect( pCancel, SIGNAL(clicked()),
               this, SLOT(cancelClicked())
             );

    buttonBox->addStretch();

    pOk = new KPushButton( iconLoader->loadIcon("exit",KIcon::Small), i18n("Close"), this, "pOk" );
    pOk->setFocus();
    buttonBox->addWidget( pOk );
    connect( pOk, SIGNAL(clicked()),
               this, SLOT(accept())
             );

    // delete the icon loader object
    delete iconLoader;
}

ReplayGainScanner::~ReplayGainScanner()
{}

void ReplayGainScanner::addClicked( int index )
{
    if( index == 1 ) {
        showFileDialog();
    }
    else {
        showDirDialog();
    }
}

void ReplayGainScanner::showFileDialog()
{
    KFileDialog* dialog = new KFileDialog( ":file_open", config->replayGainFilter(), this, i18n("Choose files!"), true );
    dialog->setMode ( KFile::Files | KFile::ExistingOnly );
    if( dialog->exec() == KDialog::Accepted ) {
        QStringList urls = dialog->selectedURLs().toStringList();
        for( QStringList::Iterator it = urls.begin(); it != urls.end(); ++it ) {
            emit addFile( KURL::decode_string(*it) );
        }
    }
}

void ReplayGainScanner::showDirDialog()
{
//     QString directory = KFileDialog::getExistingDirectory( ":file_open", this, i18n("Choose a directory!") );
//     if( directory != NULL )
//     {
//         emit addDir( directory );
//     }

    DirDialog *dialog = new DirDialog( config, DirDialog::ReplayGain, this, "DirDialog" );

    Q_CHECK_PTR( dialog );

    if( dialog->exec() ) {
        emit addDir( dialog->directory, dialog->selectedFileTypes );
    }

    delete dialog;
}

void ReplayGainScanner::addFiles( QStringList files )
{
    for( QStringList::Iterator it = files.begin(); it != files.end(); ++it ) {
        emit addFile( *it );
    }
}

void ReplayGainScanner::calcReplayGainClicked()
{
    emit calcAllReplayGain( cForce->isChecked() );
}

void ReplayGainScanner::removeReplayGainClicked()
{
    emit removeAllReplayGain();
}

void ReplayGainScanner::cancelClicked()
{
    emit cancelProcess();
}

void ReplayGainScanner::processStarted()
{
    pTagVisible->hide();
    pRemoveTag->hide();
    pCancel->show();
}

void ReplayGainScanner::processStopped()
{
    pTagVisible->show();
    pRemoveTag->show();
    pCancel->hide();
    pProgressBar->setProgress( 100 );
    pProgressBar->setTotalSteps( 100 );
    setCaption( i18n("Finished") + " - " + i18n("Replay Gain Tool") );
}

void ReplayGainScanner::updateProgress( int progress, int totalSteps )
{
/*    pProgressBar->setProgress( int(processedTime) + percent * int(timeCount) / 100 );
    pProgressBar->setTotalSteps( int(time) );*/
    pProgressBar->setProgress( progress );
    pProgressBar->setTotalSteps( totalSteps );
    float fPercent;
    if( pProgressBar->totalSteps() > 0 ) fPercent = pProgressBar->progress() * 100 / pProgressBar->totalSteps();
    else fPercent = 0;

    QString percent;
    percent.sprintf( "%i%%", (int)fPercent );
    setCaption( percent + " - " + i18n("Replay Gain Tool") );
}

