

#ifndef DCOPINTERFACE_H
#define DCOPINTERFACE_H

#include <dcopobject.h>

#include <qstringlist.h>

/**
 * @short The soundKonverter DCOP interface
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class DCOPInterface : virtual public DCOPObject
{
    K_DCOP
k_dcop:
    /**
     * When a new instance of soundKonverter should be created,
     * this function is called and all @p files are passed, that should be opened (for conversion).
     */
    virtual void openArgFiles( const QStringList &files ) = 0;

    /**
     * When a new instance of soundKonverter should be created,
     * this function is called and all @p files are passed, that should be opened for editing the replaygain tag.
     */
    virtual void openArgReplayGainFiles( const QStringList &files ) = 0;

    /*
     * When a new instance of soundKonverter should be created,
     * this function is called and all @p files are passed, that should be opened for repair.
     */
//     virtual void openArgRepairFiles( const QStringList &files ) = 0;


// TODO code cleanups
/*
        virtual void openFiles(const QStringList &files) = 0;
        virtual void openReplayGainFiles(const QStringList &files) = 0;
        virtual void showFileDialog() = 0;
        virtual void showDirDialog() = 0;
        virtual void showCDDialog() = 0;
        virtual void showURLDialog() = 0;
        virtual void showReplayGainScanner() = 0;
        virtual void showCuesheetEditor() = 0;
        virtual void showConfigDialog() = 0;
        virtual void showLogViewer() = 0;
        virtual void startConversion() = 0;
        virtual void stopConversion() = 0;
        virtual void killConversion() = 0;
        virtual void removeFiles(const QStringList &files) = 0;
*/
};


#endif // DCOPINTERFACE_H
