/*
 * P3
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**************************************************************************
 * dimension.c : functions to get the width, height and depth of any object
 * Copyright (C) 2001-2002 Bertrand 'blam' LAMY
 **************************************************************************/


#include "p3_base.h"
#include "math3d.h"
#include "coordsys.h"

#ifdef COMPILE_FOR_C
#include "c/face_c.h"
#endif /* COMPILE_FOR_C */

#ifdef COMPILE_FOR_PYTHON
#include "python/face_python.h"
#endif /* COMPILE_FOR_PYTHON */


void P3_set_box (GLfloat* r, GLfloat* data) {
  if (data[0] < r[0]) { r[0] = data[0]; }
  if (data[1] < r[1]) { r[1] = data[1]; }
  if (data[2] < r[2]) { r[2] = data[2]; }
  if (data[3] > r[3]) { r[3] = data[3]; }
  if (data[4] > r[4]) { r[4] = data[4]; }
  if (data[5] > r[5]) { r[5] = data[5]; }
}

void P3_object_get_box (P3_any_object* o, P3_coordsys* parent, GLfloat* box, int* edited) {
  GLfloat b[6];
  GLfloat* matrix;
  P3_world* w;
  int i;
  /* box is always given in the NULL coordsys */
  if (o == NULL) { return; }
  switch (o->class->id) {
  case P3_ID_VOLUME:
    P3_object_get_box (((P3_volume*) o)->shape, (P3_coordsys*) o, box, edited);
    break;
  case P3_ID_FACE:
    P3_face_get_box ((P3_face*) o, box, edited);
    break;
  case P3_ID_WORLD:
    w = (P3_world*) o;
    P3_object_get_box (w->shape, (P3_coordsys*) w, box, edited);
    for (i = 0; i < P3_children_size (w->children); i++) {
      P3_object_get_box (P3_children_get (w->children, i), (P3_coordsys*) w, box, edited);
    }
    break;
  case P3_ID_PORTAL:
// TO DO
    break;
  }
}

/*
void P3_object_get_coords (P3_any_object* o, P3_coordsys* parent, P3_coordsys* root, GLfloat** coordinates, int* nb) {
  GLfloat* coords;
  GLfloat* buf;
//  P3_model* mdata;
  GLfloat* m1;
  GLfloat* m2;
  P3_face* face;
  P3_vertex* v;
  int i;
  int n;
  if (o == NULL) { return; }
  coords = *coordinates;
  switch (o->class->id) {
  case P3_ID_VOLUME:
    P3_object_get_coords (((P3_volume*) o)->shape, (P3_coordsys*) o, root, coordinates, nb);
    break;
  case P3_ID_WORLD:
    P3_object_get_coords (((P3_world*) o)->shape, (P3_coordsys*) o, root, coordinates, nb);
    for (i = 0; i < P3_children_size (((P3_world*) o)->children); i++) {
      P3_object_get_coords (P3_children_get (((P3_world*) o)->children, i), (P3_coordsys*) o, root, coordinates, nb);
    }
    break;
  case P3_ID_MODEL:
    mdata = (P3_model*) o;
    coords = (GLfloat*) realloc (coords, (*nb + mdata->nb_coords) * 3 * sizeof (GLfloat));
    buf = coords + *nb * 3;
    *nb += mdata->nb_coords;
    *coordinates = coords;
    memcpy (buf, mdata->coords, mdata->nb_coords * 3 * sizeof (GLfloat));
    if (parent != root) {
      m1 = P3_coordsys_get_root_matrix (parent);
      m2 = P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) root);
      for (i = 0; i < mdata->nb_coords; i++) {
        P3_point_by_matrix (buf + i * 3, m1);
        P3_point_by_matrix (buf + i * 3, m2);
      }
    }
    break;
  case P3_ID_PORTAL:
    coords = (GLfloat*) realloc (coords, (*nb + 4) * 3 * sizeof (GLfloat));
    buf = coords + *nb * 3;
    *nb += 4;
    *coordinates = coords;
    buf[ 0] = -0.5;
    buf[ 1] = -0.5;
    buf[ 2] =  0.0;
    buf[ 3] =  0.5;
    buf[ 4] = -0.5;
    buf[ 5] =  0.0;
    buf[ 6] = -0.5;
    buf[ 7] =  0.5;
    buf[ 8] =  0.0;
    buf[ 9] =  0.5;
    buf[10] =  0.5;
    buf[11] =  0.0;
    m1 = P3_coordsys_get_root_matrix ((P3_coordsys*) o);
    m2 = P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) root);
    for (i = 0; i < 4; i++) {
      P3_point_by_matrix (buf + i * 3, m1);
      P3_point_by_matrix (buf + i * 3, m2);
    }
    break;
  case P3_ID_FACE:
    face = (P3_face*) o;
    n = P3_face_get_vertices_number (face);
    coords = (GLfloat*) realloc (coords, (*nb + n) * 3 * sizeof (GLfloat));
    buf = coords + *nb * 3;
    *nb += n;
    *coordinates = coords;
    for (i = 0; i < n; i++) {
      v = P3_face_get_vertex (face, i);
      buf[i * 3]     = P3_vertex_get_x (v);
      buf[i * 3 + 1] = P3_vertex_get_y (v);
      buf[i * 3 + 2] = P3_vertex_get_z (v);
    }
    if (parent != root) {
      m1 = P3_coordsys_get_root_matrix (parent);
      m2 = P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) root);
      for (i = 0; i < n; i++) {
        P3_point_by_matrix (buf + i * 3, m1);
        P3_point_by_matrix (buf + i * 3, m2);
      }
    }
    break;
  default:
    break;
  }
}

void P3_world_get_box (P3_world* w, GLfloat box[6]) {
  GLfloat* coords;
  GLfloat* coord;
  GLfloat min_x = 0.0;
  GLfloat min_y = 0.0;
  GLfloat min_z = 0.0;
  GLfloat max_x = 0.0;
  GLfloat max_y = 0.0;
  GLfloat max_z = 0.0;
  int nb;
  int i;
  coords = NULL;
  nb = 0;
  P3_object_get_coords ((P3_any_object*) w, NULL, (P3_coordsys*) w, &coords, &nb);
  for (i = 0; i < nb; i++) {
    coord = coords + i * 3;
    if (i == 0) {
      min_x = coord[0];
      min_y = coord[1];
      min_z = coord[2];
      max_x = min_x;
      max_y = min_y;
      max_z = min_z;
    } else {
      if (coord[0] < min_x) { min_x = coord[0]; }
      if (coord[0] > max_x) { max_x = coord[0]; }
      if (coord[1] < min_y) { min_y = coord[1]; }
      if (coord[1] > max_y) { max_y = coord[1]; }
      if (coord[2] < min_z) { min_z = coord[2]; }
      if (coord[2] > max_z) { max_z = coord[2]; }
    }
  }
  free (coords);
  box[0] = min_x;
  box[1] = min_y;
  box[2] = min_z;
  box[3] = max_x;
  box[4] = max_y;
  box[5] = max_z;
}
*/

void P3_world_set_dimensions (P3_world* w, GLfloat new_dim[3]) {
  int edited = P3_FALSE;
  GLfloat box[6] = { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 };
  GLfloat x_scale;
  GLfloat y_scale;
  GLfloat z_scale;
  P3_object_get_box ((P3_any_object*) w, NULL, box, &edited);
  x_scale = new_dim[0] / (box[3] - box[0]);
  y_scale = new_dim[1] / (box[4] - box[1]);
  z_scale = new_dim[2] / (box[5] - box[2]);
  P3_matrix_scale (w->m, x_scale, y_scale, z_scale);
  P3_coordsys_invalid ((P3_coordsys*) w);
}



