/*
 * P3
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**********************************************
 * glext.h
 * Copyright (C) 2001-2002 Bertrand 'blam' LAMY
 **********************************************/

extern void (*GLLockArrays)       (GLint, GLsizei);
extern void (*GLUnlockArrays)     (void);
extern void (*GLMultiTexCoord2fv) (GLenum, GLfloat*);
extern void (*GLActiveTexture)    (GLenum);

void glPerspective     (GLdouble, GLdouble, GLdouble, GLdouble);
void glPrintError      (void);
void P3_build2Dmipmaps (P3_material* t);

void P3_screenshot     (char* filename);

#define glStart(nbv) \
  if (nbv == 3) { \
    glBegin (GL_TRIANGLES); \
  } else if (nbv == 4) { \
    glBegin (GL_QUADS); \
  } else if (nbv == 2) { \
      glBegin (GL_LINES); \
  } else if (nbv == 1) { \
    glBegin (GL_POINTS); \
  } else if (nbv > 4) { \
    glBegin (GL_POLYGON); \
  }
