/*
 * P3
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**********************************************
 * land.h
 * Copyright (C) 2001-2002 Bertrand 'blam' LAMY
 **********************************************/

#define P3_land_get_vertex(land, x, z) \
  (land->vertices + x + (z) * land->nb_vertex_width)

/* creation */
P3_land*     P3_land_new                          (P3_land*, int width, int depth);
void         P3_land_from_image                   (P3_land*, P3_image*);
void         P3_land_init                         (P3_land*);
void         P3_land_set_material_layer           (P3_land*, P3_material*, GLfloat start, GLfloat end);
void         P3_land_set_material_layer_angle     (P3_land*, P3_material*, GLfloat start, GLfloat end, GLfloat angle_min, GLfloat angle_max);
void         P3_land_dealloc                      (P3_land*);
void         P3_land_add_material                 (P3_land*, P3_material*);
void         P3_land_set_height                   (P3_land*, int x, int y, GLfloat value);
GLfloat      P3_land_get_height                   (P3_land*, int x, int y);
P3_material* P3_land_get_material                 (P3_land*, int x, int y);
void         P3_land_compute_normals              (P3_land*);
void         P3_land_compute_coords               (P3_land*);
void         P3_land_create_patchs                (P3_land*);
void         P3_land_compute_shadow_color         (P3_land*, P3_light*, GLfloat*);

/* rendering */
void         P3_land_batch                        (P3_land*, P3_instance*);
void         P3_land_render                       (P3_land*, P3_instance*);
void         P3_land_raypick                      (P3_land*, P3_raypick_data*, P3_raypickable*);
int          P3_land_raypick_b                    (P3_land*, P3_raypick_data*, P3_raypickable*);
GLfloat      P3_land_get_height_at                (P3_land*, GLfloat x, GLfloat z, GLfloat** norm);

/* fx (warfog) */
void         P3_land_check_vertex_options  (P3_land*);
GLfloat*     P3_land_check_color           (P3_land*, GLfloat*);
void         P3_land_check_warfog          (P3_land*);
GLfloat*     P3_land_register_color        (P3_land*, GLfloat[4]);
void         P3_land_add_vertex_option_all (P3_land*, int flag);
void         P3_land_rem_vertex_option_all (P3_land*, int flag);
void         P3_land_fx_all                (P3_land*, P3_fx*);
void         P3_land_fx_in_sphere          (P3_land*, P3_fx*, GLfloat sphere[4]);
void         P3_land_fx_in_cylinderY       (P3_land*, P3_fx*, GLfloat cylinder[3]);

/* loading/saving */
void         P3_land_get_data                     (P3_land*, P3_chunk*);
void         P3_land_set_data                     (P3_land*, P3_chunk*);

