/*
 * P3
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**********************************************
 * mesh.h 
 * Copyright (C) 2001-2003 Bertrand 'blam' LAMY
 **********************************************/

P3_mesh* P3_mesh_new       (P3_mesh*);
void     P3_mesh_batch     (P3_mesh*, P3_instance*);
void     P3_mesh_render    (P3_mesh*, P3_instance*);
void     P3_mesh_dealloc   (P3_mesh*);
void     P3_mesh_raypick   (P3_mesh*, P3_raypick_data*, P3_raypickable*);
int      P3_mesh_raypick_b (P3_mesh*, P3_raypick_data*, P3_raypickable*);
void     P3_mesh_get_data  (P3_mesh*, P3_chunk*);
void     P3_mesh_set_data  (P3_mesh*, P3_chunk*);
void     P3_mesh_batch_outline        (P3_mesh*, P3_instance*, P3_frustum*);
void     P3_mesh_render_outline       (P3_mesh*);
void     P3_mesh_prepare_cell_shading (P3_mesh*, P3_instance*, GLfloat*);

/* XTRA */
void P3_mesh_build_tree              (P3_mesh*);
void P3_mesh_optimize_tree           (P3_mesh*, GLfloat collapse, int mode, GLfloat param);
void P3_mesh_set_xtra1_display_lists (P3_mesh*);
void P3_mesh_set_xtra1_cell_shading  (P3_mesh*, P3_material*, GLfloat* color, GLfloat line_width_factor);
void P3_mesh_set_xtra2_sphere        (P3_mesh*);
void P3_mesh_set_xtra2_face_list     (P3_mesh*);

/* MESH BUILD */
void      P3_xmesh_initialize            (P3_xmesh*);
void      P3_xmesh_free_data             (P3_xmesh*);
P3_xmesh* P3_xmesh_from_faces            (P3_xmesh*, P3_list*,  GLfloat angle, int mesh_option);
P3_xmesh* P3_xmesh_from_world            (P3_xmesh*, P3_world*, GLfloat angle, int mesh_option);
void      P3_xmesh_to_faces              (P3_xmesh*, P3_world*);
int       P3_xmesh_face_size             (P3_xmesh*, P3_xface*);
void      P3_xmesh_register_material     (P3_xmesh*, P3_material*);
int       P3_xmesh_register_value        (P3_xmesh*, GLfloat*, int);
GLfloat*  P3_xmesh_register_color        (P3_xmesh*, GLfloat[4]);

/* MESH RENDER */
void      P3_xmesh_option_activate        (int option);
void      P3_xmesh_option_inactivate      (int option);
void      P3_xface_option_activate        (int option);
void      P3_xface_option_inactivate      (int option);
void      P3_xpack_batch_face             (void*, P3_xpack*, void*);
void      P3_xmesh_face_batch             (P3_xmesh*, P3_xface*);
void      P3_xmesh_triangle_render        (P3_xmesh*, P3_xface*);
void      P3_xmesh_quad_render            (P3_xmesh*, P3_xface*);
void      P3_xmesh_pack_render            (P3_xmesh*);
void      P3_xmesh_pack_render_cellshaded (P3_xmesh*, GLfloat*);
void      P3_xmesh_node_batch             (P3_xmesh*, P3_xnode*, P3_frustum*);
void      P3_xmesh_batch_start            (P3_instance* inst);
void      P3_xmesh_batch_end              (void);

/* MESH RAYPICK */
void      P3_xmesh_face_raypick          (P3_xmesh*, P3_xface*, GLfloat*, P3_raypick_data*, P3_raypickable*);
int       P3_xmesh_face_raypick_b        (P3_xmesh*, P3_xface*, GLfloat*, P3_raypick_data*);
void      P3_xmesh_node_raypick          (P3_xmesh*, P3_xnode*, GLfloat*, P3_raypick_data*, P3_raypickable*);
int       P3_xmesh_node_raypick_b        (P3_xmesh*, P3_xnode*, GLfloat*, P3_raypick_data*);
void      P3_xmesh_raypick               (P3_xmesh*, GLfloat*, P3_raypick_data*, P3_raypickable*);
int       P3_xmesh_raypick_b             (P3_xmesh*, GLfloat*, P3_raypick_data*);

/* MESH TREE */
P3_xnode* P3_xmesh_build_tree            (P3_xmesh*);
void      P3_xmesh_optimize_tree         (P3_xnode*, GLfloat collapse, int mode, GLfloat param);
int       P3_xnode_get_nb_level          (P3_xnode*);
void      P3_xnode_dealloc               (P3_xnode*);
void      P3_xnode_get_faces             (P3_xnode*, GLfloat* sphere, P3_chunk*);

/* MESH FILE I/O */
int       P3_xmesh_get_material_index (P3_xmesh*, P3_material*);
void      P3_xnode_get_data           (P3_xnode*, P3_xmesh*, P3_chunk*);
P3_xnode* P3_xnode_set_data           (P3_xmesh*, P3_chunk*);
void      P3_xmesh_get_data           (P3_xmesh*, P3_chunk*);
void      P3_xmesh_set_data           (P3_xmesh*, P3_chunk*);

/* MESH VERTEX FX */
void P3_mesh_check_fx        (P3_mesh*);
void P3_mesh_fx_all          (P3_mesh*, P3_fx*);
void P3_mesh_fx_in_sphere    (P3_mesh*, P3_fx*, GLfloat sphere[4]);
void P3_mesh_fx_in_cylinderY (P3_mesh*, P3_fx*, GLfloat cylinder[3]);
void P3_mesh_fx_in_layerY    (P3_mesh*, P3_fx*, GLfloat layer[2]);

P3_mesh_fxinstance* P3_mesh_fxinstance_new            (P3_mesh_fxinstance*);
void                P3_mesh_fxinstance_dealloc        (P3_mesh_fxinstance*);
void                P3_mesh_fxinstance_set_mesh       (P3_mesh_fxinstance*, P3_mesh*);
GLfloat*            P3_mesh_fxinstance_register_color (P3_mesh_fxinstance*, GLfloat[4]);
void                P3_mesh_fxinstance_raypick        (P3_mesh_fxinstance*, P3_raypick_data*, P3_raypickable*);
int                 P3_mesh_fxinstance_raypick_b      (P3_mesh_fxinstance*, P3_raypick_data*, P3_raypickable*);
void                P3_mesh_fxinstance_batch          (P3_mesh_fxinstance*, P3_instance*);
void                P3_mesh_fxinstance_render         (P3_mesh_fxinstance*, P3_instance*);

/* MESH SHADOW */
int P3_mesh_shadow (P3_mesh*, P3_instance*, P3_light*);

/* MESH LOD */
P3_mesh_LOD* P3_mesh_LOD_new       (P3_mesh_LOD*);
void         P3_mesh_LOD_dealloc   (P3_mesh_LOD*);
void         P3_mesh_LOD_raypick   (P3_mesh_LOD*, P3_raypick_data*, P3_raypickable*);
int          P3_mesh_LOD_raypick_b (P3_mesh_LOD*, P3_raypick_data*, P3_raypickable*);
void         P3_mesh_LOD_batch     (P3_mesh_LOD*, P3_instance*);
void         P3_mesh_LOD_get_data  (P3_mesh_LOD*, P3_chunk*);
void         P3_mesh_LOD_set_data  (P3_mesh_LOD*, P3_chunk*);

