/*
 * P3
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**********************************************
 * morph.c
 * Copyright (C) 2001-2002 Bertrand 'blam' LAMY
 **********************************************/

// !!! DEPRECATED !!!

#if 0

//#include <math.h>

#include "p3_base.h"
#include "util.h"
#include "math3d.h"
#include "material.h"
#include "renderer.h"
#include "coordsys.h"
#include "world.h"
#include "frustum.h"
#include "raypick.h"
#include "morph.h"


extern P3_renderer* renderer;
extern GLfloat user_matrix[19];


/*============*
 * ANIMATIONS *
 *============*/

void P3_coordsys_set_state (P3_coordsys* csys, P3_anim_coordsys* anim, float prev_time, float new_time) {
  P3_state_coordsys* s1;
  GLfloat f1; GLfloat f2;
  GLfloat q[4];

  if (new_time < anim->time_min) {

    GLfloat width; GLfloat height; GLfloat depth;
    /* interpolate between current state and anim 1rst state */
    f1 = (anim->time_min - new_time) / (anim->time_min - prev_time);
    f2 = 1.0 - f1;
    s1 = anim->states;
    P3_quaternion_from_matrix (q, csys->m);
    width  = f1 * csys->m[16] + f2 * s1->m[16];
    height = f1 * csys->m[17] + f2 * s1->m[17];
    depth  = f1 * csys->m[18] + f2 * s1->m[18];
    P3_quaternion_slerp (q, q, s1->quaternion, f2, f1);
    P3_matrix_from_quaternion (csys->m, q);
    csys->m[12] = f1 * csys->m[12] + f2 * s1->m[12];
    csys->m[13] = f1 * csys->m[13] + f2 * s1->m[13];
    csys->m[14] = f1 * csys->m[14] + f2 * s1->m[14];
    P3_matrix_scale (csys->m, width, height, depth);

  } else if (new_time > anim->time_max) {

    if (anim->cyclic_lap < 0.0) {

      /* set anim last state */
      s1 = anim->states + anim->nb_states - 1;
      P3_matrix_copy (csys->m, s1->m);

    } else {

      P3_state_coordsys* s2;

      /* assume new_time < anim->time_max + anim->cyclic_lap 
       * => interpolate between anim last state and 1rst state
       */
      f1 = (new_time - anim->time_max) / anim->cyclic_lap;
      f2 = 1.0 - f1;
      s1 = anim->states;
      s2 = anim->states + anim->nb_states - 1;
      P3_quaternion_slerp (q, s1->quaternion, s2->quaternion, f2, f1);
      P3_matrix_from_quaternion (csys->m, q);
      csys->m[12] = f1 * s1->m[12] + f2 * s2->m[12];
      csys->m[13] = f1 * s1->m[13] + f2 * s2->m[13];
      csys->m[14] = f1 * s1->m[14] + f2 * s2->m[14];
      P3_matrix_scale (csys->m, f1 * s1->m[16] + f2 * s2->m[16], 
                                f1 * s1->m[17] + f2 * s2->m[17], 
                                f1 * s1->m[18] + f2 * s2->m[18]);

    }

  } else {
    P3_state_coordsys* s2;
    int i_max;
    int i_min;
    int i;

    /* find previous and next state for new_time => dichotomic algorythm */
    i_min = 0;
    i_max = anim->nb_states;

    i = i_max >> 1;

    while (1) {
      s1 = anim->states + i;
      if (s1->time < new_time) {
        /* we must look after */
        i_min = i;
      } else if (s1->time > new_time) {
        /* we must look before */
        i_max = i;
      } else {
        /* found a state with time = new_time => no interpolation */
        P3_matrix_copy (csys->m, s1->m);
        P3_coordsys_lefthanded (csys);
        P3_object_invalid ((P3_any_object*) csys);
        return;
      }
      if (i_max - i_min <= 1) {
        break;
      }
      i = (i_max + i_min) >> 1;
    }
    s1 = anim->states + i_min;
    s2 = s1 + 1;

    if (s1->time == new_time) {
      P3_matrix_copy (csys->m, s1->m);
    } else if (s2->time == new_time) {
      P3_matrix_copy (csys->m, s2->m);
    } else {
      /* interpolate */
      f2 = (new_time - s1->time) / (s2->time - s1->time);
      f1 = 1.0 - f2;
      P3_quaternion_slerp (q, s1->quaternion, s2->quaternion, f2, f1);
      P3_matrix_from_quaternion (csys->m, q);
      csys->m[12] = f1 * s1->m[12] + f2 * s2->m[12];
      csys->m[13] = f1 * s1->m[13] + f2 * s2->m[13];
      csys->m[14] = f1 * s1->m[14] + f2 * s2->m[14];
      P3_matrix_scale (csys->m, f1 * s1->m[16] + f2 * s2->m[16], 
                                f1 * s1->m[17] + f2 * s2->m[17], 
                                f1 * s1->m[18] + f2 * s2->m[18]);
    }
  }

  P3_coordsys_lefthanded (csys);
  P3_object_invalid ((P3_any_object*) csys);
}

/*
float P3_anim_advance (P3_anim* anim, float cur_time, float gain_time) {
  float f;
  f = cur_time + gain_time;
  if (anim->cyclic_lap > 0.0) {
    float g;
    g = anim->cyclic_lap + anim->time_max;
    if (f > g) {
      f += anim->time_min - g;
    }
  }
  return f;
}
*/

/*
int P3_anim_get_states_for_time (P3_anim* anim, float time, P3_anim_state* before, P3_anim_state* after) {
  int i;
  int i_min;
  int i_max;
  float* state;
  // return P3_FALSE if we need an interpolation, else P3_TRUE
  if (time < anim->time_min) {
    before->state = NULL;
//    before->time  = 0.0;
    after->state  = anim->states;
    after->time   = anim->time_min;
    return P3_FALSE;
  }
  if (time > anim->time_max) {
    if (anim->cyclic_lap > 0.0) {
// TO DO WARNING assume: time < time_max + cyclic_lap
      before->state = anim->states + anim->nb_states * anim->size_state;
      before->time  = anim->time_max;
      after->state  = anim->states;
      after->time   = anim->time_max + anim->cyclic_lap;
      return P3_FALSE;
    } else {
      before->state = anim->states + anim->nb_states * anim->size_state;
      before->time = time;
//      after->state = before->state;
//      after->time = time;
      return P3_TRUE;
    }
  } else {
    i_min = 0;
    i_max = anim->nb_states;
    i = i_max >> 1;
    while (1) {
      if (i_max - i_min <= 1) {
        before->state = anim->states + i_min * anim->size_state;
        before->time  = *((float*) before->state);
        after->state  = anim->states + i_max * anim->size_state;
        after->time   = *((float*) after->state);
        if (fabs (before->time - time) < P3_EPSILON) {
          return P3_TRUE;
        } else {
          return P3_FALSE;
        }
      }
      state = (float*) anim->states + i * anim->size_state;
      if (fabs (time - *state) < P3_EPSILON) {
        before->state = state;
        before->time = time;
        return P3_TRUE;
      } else if (*state < time) {
        // we must look after state
        i_min = i;
      } else if (*state > time) {
        // we must look before state
        i_max = i;
      }
      i = (i_min + i_max) >> 1;
    };
  }
}
*/

/* Coordsys Animations */

P3_anim_coordsys* P3_anim_coordsys_new (P3_anim_coordsys* anim) {
  if (anim == NULL) {
    anim = (P3_anim_coordsys*) malloc (sizeof (P3_anim_coordsys));
  }
  anim->cyclic_lap = -1.0;
  anim->time_min = -1.0;
  anim->time_max = -1.0;
  anim->nb_states = 0;
  anim->states = NULL;
  return anim;
}

void P3_anim_coordsys_delete_state (P3_anim_coordsys* anim, int index) {
  P3_state_coordsys* s;
  s = anim->states + index;
  memmove (s, s + 1, (anim->nb_states - index) * sizeof (P3_state_coordsys));
  (anim->nb_states)--;
  anim->states = realloc (anim->states, anim->nb_states * sizeof (P3_state_coordsys));
}

void P3_anim_coordsys_remove_state (P3_anim_coordsys* anim, float time) {
  P3_state_coordsys* s;
  int i;
  for (i = 0; i < anim->nb_states; i++) {
    s = anim->states + i;
    if (s->time == time) {
      P3_anim_coordsys_delete_state (anim, i);
      return;
    }
  }
}

void P3_anim_coordsys_add_state (P3_anim_coordsys* anim, P3_coordsys* csys, float time) {
  P3_state_coordsys* s;
  GLfloat matrix[19];
  int broken;
  int n;
  int i;

  /* look for exactly the same time */
  broken = P3_FALSE;
  for (i = 0; i < anim->nb_states; i++) {
    s = anim->states + i;
    if (s->time == time) {
      broken = P3_TRUE;
      break;
    }
  }

  if (broken == P3_FALSE) {
    n = anim->nb_states;
    (anim->nb_states)++;
    anim->states = (P3_state_coordsys*) realloc (anim->states, anim->nb_states * sizeof (P3_state_coordsys));

    if (n == 0) {
      s = anim->states;
      anim->time_min = time;
      anim->time_max = time;
    } else {
      broken = P3_FALSE;
      for (i = 0; i < n; i++) {
        s = anim->states + i;
        if (s->time > time) {
          /* move following states */
          memmove (s + 1, s, (n - i) * sizeof (P3_state_coordsys));
          broken = P3_TRUE;
          break;
        }
      }
      if (broken == P3_FALSE) {
        s = anim->states + n;
      }
      if (time < anim->time_min) { anim->time_min = time; }
      if (time > anim->time_max) { anim->time_max = time; }
    }
  }

  s->time = time;
  P3_matrix_copy (s->m, csys->m);
  P3_matrix_copy (matrix, csys->m);
  P3_matrix_scale (matrix, 1.0 / csys->m[16], 1.0 / csys->m[17], 1.0 / csys->m[18]);
  P3_quaternion_from_matrix (s->quaternion, matrix);
}

/* *** WAS GOOD ***
void P3_coordsys_get_state (P3_state_coordsys* s, P3_coordsys* c) {
  P3_matrix_copy (s->m, c->m);
  P3_matrix_copy (user_matrix, c->m);
  P3_matrix_scale (user_matrix, 1.0 / c->m[16], 1.0 / c->m[17], 1.0 / c->m[18]);
  P3_quaternion_from_matrix (s->quaternion, user_matrix);
}
*/
/*
//void P3_anim_coordsys_state_base_set (P3_anim_coordsys_state_base* s, float time, P3_coordsys* c) {
  GLfloat m[19];
//  s->time = time;
  s->width  = c->m[16];
  s->height = c->m[17];
  s->depth  = c->m[18];
  P3_matrix_copy (s->m, c->m);
  P3_matrix_copy (m, c->m);
  P3_matrix_scale (m, 1.0 / c->m[16], 1.0 / c->m[17], 1.0 / c->m[18]);
  P3_quaternion_from_matrix (s->quaternion, m);
}
*/

/* *** WAS GOOD ***
void P3_state_coordsys_interpolate (P3_state_coordsys* s, P3_state_coordsys* s1, P3_state_coordsys* s2, float f2) {
  float f1;
  GLfloat width; GLfloat height; GLfloat depth;
  f1 = 1.0 - f2;
//  s->time = time;
//  s->width  = f1 * s1->width  + f2 * s2->width;
//  s->height = f1 * s1->height + f2 * s2->height;
//  s->depth  = f1 * s1->depth  + f2 * s2->depth;
  width  = f1 * s1->m[16] + f2 * s2->m[16];
  height = f1 * s1->m[17] + f2 * s2->m[17];
  depth  = f1 * s1->m[18] + f2 * s2->m[18];
  P3_quaternion_slerp (s->quaternion, s1->quaternion, s2->quaternion, f2);
  P3_matrix_from_quaternion (s->m, s->quaternion);
  s->m[12] = f1 * s1->m[12] + f2 * s2->m[12];
  s->m[13] = f1 * s1->m[13] + f2 * s2->m[13];
  s->m[14] = f1 * s1->m[14] + f2 * s2->m[14];
//  P3_matrix_translate (s->m, f1 * s1->m[12] + f2 * s2->m[12], f1 * s1->m[13] + f2 * s2->m[13], f1 * s1->m[14] + f2 * s2->m[14]);
  P3_matrix_scale (s->m, width, height, depth);
//  P3_matrix_scale (s->m, s->width, s->height, s->depth);
}

void P3_coordsys_set_state (P3_coordsys* c, P3_state_coordsys* s) {
  P3_matrix_copy (c->m, s->m);
// TO DO scale factors change while the matrix is not scaled ?!?
//  c->m[16] = s->width;
//  c->m[17] = s->height;
//  c->m[18] = s->depth;
  P3_coordsys_lefthanded (c);
  P3_object_invalid ((P3_any_object*) c);
}
*/

/*
void P3_coordsys_set_anim_state (P3_coordsys** coordsys, P3_anim_coordsys* anim, float time) {
  P3_anim_state before;
  P3_anim_state after;
  P3_anim_coordsys_state* s;
  int i;
  if (P3_anim_get_states_for_time ((P3_anim*) anim, time, &before, &after) == P3_TRUE) {
    s = (P3_anim_coordsys_state*) before.state;
    for (i = 0; i < anim->nb_elements; i++) {
      P3_coordsys_set_state_base (coordsys[anim->elements[i]], s->base_states + i);
    }
  } else {
    P3_anim_coordsys_state* s2;
    P3_anim_coordsys_state_base bs;
    float f2;
    // must interpolate
    s  = (P3_anim_coordsys_state*) before.state;
    s2 = (P3_anim_coordsys_state*)  after.state;
    if (s == NULL) {
      // s must be current time or last integer (not interpolated) time
// TO DO
//      s = ;
//      before->time = time;
    }
    f2 = (after.time - time) / (after.time - before.time);
    for (i = 0; i < anim->nb_elements; i++) {
      P3_anim_coordsys_state_base_interpolate (&bs, s->base_states + i, s2->base_states + i, f2);
      P3_coordsys_set_state_base (coordsys[anim->elements[i]], &bs);
    }
  }
}
*/

/*============*
 * MORPH DATA *
 *============*/

void P3_morph_data_free_data (P3_morph_data* d) {
  P3_morph_mesh* m;
  int i;
  free (d->v);
  free (d->v_coords);
  free (d->v_normals);
  free (d->v_texcoords);
  free (d->v_colors);
//  free (d->v_c_coords);
//  free (d->v_c_normals);
  for (i = 0; i < d->nb_f; i++) {
    free ((d->f + i)->v);
  }
  free (d->f);
  free (d->f_normals);
//  free (d->f_c_normals);
  for (i = 0; i < d->nb_m; i++) {
    m = d->meshes + i;
//    if (m->material != NULL) {
//      P3_material_decref (m->material);
//    }
    free (m->f);
  }
  free (d->meshes);
  for (i = 0; i < d->nb_materials; i++) {
    P3_material_decref (d->materials[i]);
  }
  free (d->materials);
// TO DO world struct ?
// TO DO anim ?
}

/*
void P3_morph_data_init (P3_morph_data* d) {
  if (!(d->option & P3_MORPH_DATA_MIXED_ALPHA)) {
    d->v_c_coords  = (GLfloat*) malloc (d->nb_v_coords  * 3 * sizeof (GLfloat));
    d->v_c_normals = (GLfloat*) malloc (d->nb_v_normals * 3 * sizeof (GLfloat));
    d->f_c_normals = (GLfloat*) malloc (d->nb_f         * 3 * sizeof (GLfloat));
  }
}
*/


/*=======*
 * MORPH *
 *=======*/

P3_class P3_class_morph = { 
  P3_ID_MORPH,
  (batch_func)     P3_morph_batch,
  (render_func)    0,
  (raypick_func)   P3_morph_raypick,
  (raypick_b_func) P3_morph_raypick_b,
};

P3_class P3_class_morph_mesh = {
  P3_ID_MORPH_MESH,
  (batch_func)     P3_morph_mesh_batch,
  (render_func)    P3_morph_mesh_render,
  (raypick_func)   0,
  (raypick_b_func) 0,
};

P3_morph* P3_morph_instantiate (P3_morph* m, P3_morph_data* data) {
  if (m == NULL) {
    m = (P3_morph*) malloc (sizeof (P3_morph));
  }
  m->class = &P3_class_morph;
  P3_coordsys_initialize ((P3_coordsys*) m);
//  m->option = 0;
//  m->parent = NULL;
  m->data = data;
//  m->frustum = (P3_frustum*) malloc (sizeof (P3_frustum));
  m->materials = NULL;
// TO DO worlds -> ok
  m->v_c_coords  = (GLfloat*) malloc (data->nb_v_coords  * 3 * sizeof (GLfloat));
  m->v_c_normals = (GLfloat*) malloc (data->nb_v_normals * 3 * sizeof (GLfloat));
  m->f_c_normals = (GLfloat*) malloc (data->nb_f         * 3 * sizeof (GLfloat));
/*
  if (data->option & P3_MORPH_DATA_MIXED_ALPHA) {
    m->v_c_coords  = (GLfloat*) malloc (data->nb_v_coords  * 3 * sizeof (GLfloat));
    m->v_c_normals = (GLfloat*) malloc (data->nb_v_normals * 3 * sizeof (GLfloat));
    m->f_c_normals = (GLfloat*) malloc (data->nb_f         * 3 * sizeof (GLfloat));
  } else {
    m->v_c_coords  = NULL;
    m->v_c_normals = NULL;
    m->f_c_normals = NULL;
  }
*/
// TO DO optionnal ?
  m->f_visibility = (char*) malloc (data->nb_f * sizeof (char));
// TO DO ok ?
  memset (m->f_visibility, P3_MORPH_VISIBLE, data->nb_f * sizeof (char));
  return m;
}

void P3_morph_invalid (P3_morph* m) {
  int i;
  P3_coordsys_invalid ((P3_coordsys*) m);
  /* invalid children */
  if (m->worlds != NULL) {
    for (i = 0; i < P3_children_size (m->worlds); i++) {
      P3_object_invalid (P3_children_get (m->worlds, i));
    }
  }
}

void P3_morph_make_context (P3_morph* m, P3_instance* csys) {
  int i;
  P3_any_object* o;
//  GLfloat sphere[4];
//  GLfloat* oldmatrix;
//  P3_frustum* oldfrustum;

//printf("morph : make context\n");

  if (m->option & P3_MORPH_COMPUTED) { m->option -= P3_MORPH_COMPUTED; }
  if (m->option & P3_MORPH_RAYPICK_COMPUTED) { m->option -= P3_MORPH_RAYPICK_COMPUTED; }
  if (m->option & P3_OBJECT_HIDDEN) { return; }
//  oldmatrix  = renderer->c_matrix;
//  oldfrustum = renderer->c_frustum;
  P3_multiply_matrix (m->render_matrix, renderer->c_camera->render_matrix, P3_coordsys_get_root_matrix ((P3_coordsys*) m));
//  P3_multiply_matrix (m->render_matrix, csys->render_matrix, m->m);
//  P3_multiply_matrix (m->render_matrix, renderer->c_matrix, m->m);
//  renderer->c_matrix = m->render_matrix;
//  P3_frustum_by_matrix (m->frustum, oldfrustum, P3_coordsys_get_inverted_matrix ((P3_coordsys*) m));
//  renderer->c_frustum = m->frustum;
//  /* frustum test ? */
// TO DO do I must compute a new frustum ?
//  memcpy (sphere, m->data->bsphere, 4 * sizeof (GLfloat));
//  P3_sphere_instance_into (sphere, NULL, renderer->c_frustum->coordsys);

  if (m->data->bsphere[3] > 0.0) {
    if (renderer->c_frustum_coordsys != (P3_coordsys*) m) {
      P3_frustum_by_matrix (renderer->c_frustum, renderer->r_frustum, P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) m));
      renderer->c_frustum_coordsys = (P3_coordsys*) m;
    }
    if (P3_sphere_in_frustum (renderer->c_frustum, m->data->bsphere) == P3_FALSE) {
//      m->option |= P3_OBJECT_OUT_OF_VIEW;
      return;
    }
  }
//  if (m->option & P3_OBJECT_OUT_OF_VIEW) {
//    m->option -= P3_OBJECT_OUT_OF_VIEW;
//  }
  /* make worlds */
// TO DO ok
//  for (i = 0; i < P3_children_size (m->data->w); i++) {
//    o = (P3_any_object*) P3_children_get (m->worlds, i);
//    if (o->class->make != 0) {
// TO DO ok ???
//      o->class->make (o, csys);
//        if (o->class->make (o) == P3_FALSE) { 
// TO DO necessary ?
//          renderer->c_frustum = oldfrustum;
//          return P3_FALSE; 
//        }
//    }
//  }

//printf("... done\n");

//  renderer->c_frustum = oldfrustum;
//  renderer->c_matrix = oldmatrix;
//  return P3_TRUE;
}

void P3_morph_batch (P3_morph* m, P3_instance* csys) {
  int i;
  P3_any_object* o;

//printf("morph : batch\n");

  P3_morph_make_context (m, csys);

//  if (m->option & (P3_OBJECT_HIDDEN | P3_OBJECT_OUT_OF_VIEW)) { return; }
  /* batch worlds */
  for (i = 0; i < m->data->nb_w; i++) {
    o = (P3_any_object*) P3_children_get (m->worlds, i);
    if (o->class->batch != 0) {
      o->class->batch (o, (P3_instance*) m);
    }
  }
  /* batch morph itself */
//  P3_morph_compute (m);
  for (i = 0; i < m->data->nb_m; i++) {
    P3_morph_mesh_batch (m->data->meshes + i, m);
  }

//printf("... done\n");

}

void P3_morph_compute (P3_morph* morph) {
  static GLfloat** ptrp = NULL;
  static int max_nb_v = 0;
  P3_morph_data* d;
  P3_morph_face* f;
  P3_morph_vertex* v;
  int i; int j; int k;
  GLfloat* ptr;
  GLfloat v1[3];
  GLfloat v2[3];
  GLfloat w;
  GLfloat* buf_coord;
  GLfloat* buf_vnorm;
  GLfloat* buf_fnorm;

  d = morph->data;
  buf_coord = morph->v_c_coords;
  buf_vnorm = morph->v_c_normals;
  buf_fnorm = morph->f_c_normals;

  /* set all vertices to non computed */
  for (i = 0; i < d->nb_v; i++) {
    (d->v + i)->option |= P3_MORPH_NOT_COMPUTED;
  }
    
  /* compute vertices of visible faces */
  for (i = 0; i < d->nb_f; i++) {
    if (morph->f_visibility == NULL || morph->f_visibility[i] == P3_MORPH_VISIBLE) {
      f = d->f + i;
      for (j = 0; j < f->nb_v; j++) {
        v = d->v + f->v[j];
        if (v->option & P3_MORPH_NOT_COMPUTED) {
          v->option -= P3_MORPH_NOT_COMPUTED;
          if (v->world == -1) {
            ptr = morph->render_matrix;
          } else {
            ptr = ((P3_instance*) P3_children_get (morph->worlds, v->world))->render_matrix;
          }
          P3_point_by_matrix_copy (buf_coord + v->coord, d->v_coords + v->coord, ptr);
/*
          if (v->world == -1) {
            memcpy (d->v_c_coords + v->coord, d->v_coords + v->coord, 3 * sizeof (GLfloat));
          } else {
            ptr = P3_coordsys_get_root_matrix ((P3_coordsys*) P3_children_get (morph->worlds, v->world));
// TO DO problem : why 2 copy ?!?
            P3_point_by_matrix_copy (d->v_c_coords + v->coord, d->v_coords + v->coord, ptr);
// TO DO necessary or can we render with identity modelview matrix ?
            P3_point_by_matrix_copy (d->v_c_coords + v->coord, d->v_coords + v->coord, root_matrix);
          } 
*/
          /* vertex normal */
          if (v->option & P3_MORPH_HAS_NORMAL) {
            if (v->option & P3_MORPH_MORPHING_NORMAL) {
              buf_vnorm[v->coord]     = 0.0;
              buf_vnorm[v->coord + 1] = 0.0;
              buf_vnorm[v->coord + 2] = 0.0;
            } else {
              P3_vector_by_matrix_copy (buf_vnorm + v->coord, d->v_normals + v->coord, ptr);
/*
              P3_vector_by_matrix_copy (d->v_c_normals + v->coord, d->v_normals + v->coord, ptr);
// TO DO necessary or can we render with identity modelview matrix ?
              P3_vector_by_matrix_copy (d->v_c_normals + v->coord, d->v_normals + v->coord, root_matrix);
*/
            }
          }
        }
      }
      /* compute face normal */
      if (f->option & P3_MORPH_HAS_NORMAL) {
        ptr = buf_fnorm + f->normal;
        if (f->option & P3_MORPH_MORPHING_NORMAL) {
          P3_face_normal (ptr, 
                          buf_coord + (d->v + f->v[0])->coord, 
                          buf_coord + (d->v + f->v[1])->coord, 
                          buf_coord + (d->v + f->v[2])->coord);
          P3_vector_normalize (ptr);
        } else {
          if (f->world == -1) {
            P3_vector_by_matrix_copy (ptr, d->f_normals + f->normal, morph->render_matrix);
          } else {
            P3_vector_by_matrix_copy (ptr, d->f_normals + f->normal, ((P3_instance*) P3_children_get (morph->worlds, f->world))->render_matrix);
          }
/*
          P3_vector_by_matrix_copy (ptr, d->f_normals + f->normal, P3_coordsys_get_root_matrix ((P3_coordsys*) P3_children_get (morph->worlds, f->world)));
// TO DO necessary or can we render with identity modelview matrix ?
          P3_vector_by_matrix_copy (ptr, d->f_normals + f->normal, root_matrix);
*/
        }
        /* compute vertex normal */
        if (f->option & P3_MORPH_SMOOTHLIT & f->option & P3_MORPH_HAS_VERTEX_WITH_MORPHING_NORMAL) {
          if (f->nb_v > max_nb_v) {
            ptrp = (GLfloat**) realloc (ptrp, f->nb_v * sizeof (GLfloat*));
          }
          for (j = 0; j < f->nb_v; j++) {
            ptrp[j] = d->v_coords + (d->v + f->v[j])->coord;
          }
          for (j = 0; j < f->nb_v; j++) {
            v = d->v + f->v[j];
            if (v->option & P3_MORPH_MORPHING_NORMAL) {
              k = j - 1;
              if (k < 0) { k = f->nb_v - 1; }
              v1[0] = ptrp[k][0] - ptrp[j][0];
              v1[1] = ptrp[k][1] - ptrp[j][1];
              v1[2] = ptrp[k][2] - ptrp[j][2];
              k = j + 1;
              if (k >= f->nb_v) { k = 0; }
              v2[0] = ptrp[k][0] - ptrp[j][0];
              v2[1] = ptrp[k][1] - ptrp[j][1];
              v2[2] = ptrp[k][2] - ptrp[j][2];
              w = P3_vector_angle(v1, v2);
              buf_vnorm[v->coord]     += w * ptr[0];
              buf_vnorm[v->coord + 1] += w * ptr[1];
              buf_vnorm[v->coord + 2] += w * ptr[2];
            }
          }
        }
      }
    }
  }

  /* normalize morphing vertices normals */
  for (i = 0; i < d->nb_v; i++) {
    v = d->v + i;
    if (v->option & P3_MORPH_MORPHING_NORMAL) {
      P3_vector_normalize (buf_vnorm + v->coord);
    }
  }

  morph->option |= P3_MORPH_COMPUTED;
}

void P3_morph_mesh_batch (P3_morph_mesh* m, P3_morph* morph) {
  P3_material* material;
  if (m->material == -1) {
    material = NULL;
  } else {
    if (morph->materials != NULL) {
      material = morph->materials[m->material];
    } else {
      material = morph->data->materials[m->material];
    }
  }
  if (m->option & P3_R_ALPHA) {
    P3_renderer_add_alpha (m, (P3_instance*) morph);
  } else {
    P3_renderer_add (m, (P3_instance*) morph);
  }
}

void P3_morph_mesh_render (P3_morph_mesh* m, P3_morph* morph) {
  P3_morph_data* d;
  P3_morph_face* f;
  P3_morph_vertex* v;
  int j; int k;
  int nb;
  GLfloat* buf_coord;
  GLfloat* buf_vnorm;
  GLfloat* buf_fnorm;

  if (!(morph->option & P3_MORPH_COMPUTED)) { P3_morph_compute (morph); }

  d = morph->data;
  buf_coord = morph->v_c_coords;
  buf_vnorm = morph->v_c_normals;
  buf_fnorm = morph->f_c_normals;

  /* draw */
  glLoadIdentity ();

  f = d->f + m->f[0];
  nb = f->nb_v;

  if (m->option & P3_R_FRONT_AND_BACK) { 
    glLightModelf (GL_LIGHT_MODEL_TWO_SIDE, GL_TRUE);
    glDisable (GL_CULL_FACE);
  }
  if (m->option & P3_R_NEVER_LIT) { glDisable (GL_LIGHTING); }
  if      (nb == 3) { glBegin (GL_TRIANGLES); }
  else if (nb == 4) { glBegin (GL_QUADS); }
  else if (nb == 2) { glBegin (GL_LINES); }
  else if (nb == 1) { glBegin (GL_POINTS); }
  for (j = 0; j < m->nb_f; j++) {
    if (morph->f_visibility == NULL || morph->f_visibility[m->f[j]] == P3_MORPH_VISIBLE) {

// TO DO use arrays ?

      f = d->f + m->f[j];
      if (!(f->option & P3_MORPH_SMOOTHLIT) && f->normal != -1) {
        glNormal3fv (buf_fnorm + f->normal);
      }
      for (k = 0; k < nb; k++) {
        v = d->v + f->v[k];
        /* diffuse color */
        if (v->color != -1) { glColor4fv (d->v_colors + v->color); }
        /* point normal */
        if (v->option & P3_MORPH_HAS_NORMAL) { glNormal3fv (buf_vnorm + v->coord); }
        /* texcoord */
        if (v->texcoord != -1) { glTexCoord2fv (d->v_texcoords + v->texcoord); }
        /* coordinates */
        glVertex3fv (buf_coord + v->coord);
      }
    }
  }
  glEnd ();
  if (m->option & P3_R_FRONT_AND_BACK) { 
    glLightModelf (GL_LIGHT_MODEL_TWO_SIDE, GL_FALSE);
    glEnable (GL_CULL_FACE);
  }
  if (m->option & P3_R_NEVER_LIT) { glEnable (GL_LIGHTING); }
}



void P3_morph_compute_raypick (P3_morph* morph) {
  P3_morph_data* d;
  P3_morph_face* f;
  P3_morph_vertex* v;
  int i; int j;
  GLfloat* ptr;
  GLfloat* buf_coord;
  GLfloat* buf_fnorm;

  d = morph->data;
  buf_coord = morph->v_c_coords;
  buf_fnorm = morph->f_c_normals;

  /* set all vertices to non computed */
  for (i = 0; i < d->nb_v; i++) {
    (d->v + i)->option |= P3_MORPH_NOT_COMPUTED;
  }
    
  /* compute vertices of visible faces */
  for (i = 0; i < d->nb_f; i++) {
    if (morph->f_visibility == NULL || morph->f_visibility[i] == P3_MORPH_VISIBLE) {
      f = d->f + i;
      for (j = 0; j < f->nb_v; j++) {
        v = d->v + f->v[j];
        if (v->option & P3_MORPH_NOT_COMPUTED) {
          v->option -= P3_MORPH_NOT_COMPUTED;
          if (v->world == -1) {
            ptr = P3_coordsys_get_root_matrix ((P3_coordsys*) morph);
          } else {
            ptr = P3_coordsys_get_root_matrix ((P3_coordsys*) P3_children_get (morph->worlds, v->world));
          }
          P3_point_by_matrix_copy (buf_coord + v->coord, d->v_coords + v->coord, ptr);
        }
      }
      /* compute face normal */
      if (f->option & P3_MORPH_HAS_NORMAL) {
        ptr = buf_fnorm + f->normal;
        if (f->option & P3_MORPH_MORPHING_NORMAL) {
          P3_face_normal (ptr, 
                          buf_coord + (d->v + f->v[0])->coord, 
                          buf_coord + (d->v + f->v[1])->coord, 
                          buf_coord + (d->v + f->v[2])->coord);
          P3_vector_normalize (ptr);
        } else {
          if (f->world == -1) {
            P3_vector_by_matrix_copy (ptr, d->f_normals + f->normal, P3_coordsys_get_root_matrix ((P3_coordsys*) morph));
          } else {
            P3_vector_by_matrix_copy (ptr, d->f_normals + f->normal, P3_coordsys_get_root_matrix ((P3_coordsys*) P3_children_get (morph->worlds, v->world)));
          }
        }
      }
    }
  }
  morph->option |= P3_MORPH_RAYPICK_COMPUTED;
}

void P3_morph_raypick (P3_morph* morph, GLfloat* rdata, int option, 
                       GLfloat* result, GLfloat* norm, void** rcsys, P3_raypickable* parent) {
  P3_any_object* o;
  P3_morph_data* data;
  P3_morph_mesh* mesh;
  P3_morph_face* f;
  GLfloat* n;
  GLfloat z;
  int i; int j; int k;
  int intersect;
  GLfloat* raydata;

  data = morph->data;
  if (morph->option & (P3_OBJECT_NON_SOLID | P3_OBJECT_HIDDEN) || data->option & P3_OBJECT_NON_SOLID) { return; }

//  P3_raypickable_compute_raypick ((P3_raypickable*) morph, rdata);
  raydata = P3_raypickable_get_raypick_data ((P3_raypickable*) morph, rdata);

  /* raypick on bounding sphere */
  if (data->bsphere[3] > 0.0 && P3_sphere_raypick (raydata, morph->data->bsphere) == P3_FALSE) { return; }

  if (mesh->option & P3_R_FRONT_AND_BACK && option & P3_RAYPICK_CULL_FACE) {
    option -= P3_RAYPICK_CULL_FACE;
  }
  if (!(morph->option & P3_MORPH_RAYPICK_COMPUTED)) { P3_morph_compute_raypick (morph); }
  /* raypick on morph */
  for (i = 0; i < data->nb_m; i++) {
    mesh = data->meshes + i;
    f = data->f + mesh->f[0];
    if (f->nb_v == 3) {
      for (j = 0; j < mesh->nb_f; j++) {
        f = data->f + mesh->f[j];
        k = P3_triangle_raypick (rdata,
                                 morph->v_c_coords + (data->v + f->v[0])->coord,
                                 morph->v_c_coords + (data->v + f->v[1])->coord,
                                 morph->v_c_coords + (data->v + f->v[2])->coord,
                                 morph->f_c_normals + f->normal,
                                 option, &z);
        if (k != P3_FALSE && (*rcsys == NULL || fabs (z) < fabs (*result))) {
          *result = z;
          n = morph->f_c_normals + f->normal;
          intersect = k;
          *rcsys = (P3_raypickable*) morph;
        }
      }
    } else if (f->nb_v == 4) {
      for (j = 0; j < mesh->nb_f; j++) {
        f = data->f + mesh->f[j];
        k = P3_quad_raypick (rdata,
                             morph->v_c_coords + (data->v + f->v[0])->coord,
                             morph->v_c_coords + (data->v + f->v[1])->coord,
                             morph->v_c_coords + (data->v + f->v[2])->coord,
                             morph->v_c_coords + (data->v + f->v[3])->coord,
                             morph->f_c_normals + f->normal,
                             option, &z);
        if (k != P3_FALSE && (*rcsys == NULL || fabs (z) < fabs (*result))) {
          *result = z;
          n = morph->f_c_normals + f->normal;
          intersect = k;
          *rcsys = (P3_raypickable*) morph;
        }
      }
    }
  }

  /* raypick on sub worlds (chlidren) */
  for (i = 0; i < P3_children_size (morph->worlds); i++) {
    o = P3_children_get (morph->worlds, i);
    o->class->raypick (o, rdata, option, result, norm, rcsys, (P3_raypickable*) morph);
  }

  /* arrange raypick result */
  if (*rcsys == (P3_raypickable*) morph) {
    if (intersect == P3_RAYPICK_DIRECT) {
      norm[0] = n[0];
      norm[1] = n[1];
      norm[2] = n[2];
    } else if (intersect == P3_RAYPICK_INDIRECT) {
      norm[0] = - n[0];
      norm[1] = - n[1];
      norm[2] = - n[2];
    }
    /* normal is set in the null coordsys */
    n = P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) morph);
    P3_vector_by_matrix (norm, n);
  }
}

int P3_morph_raypick_b (P3_morph* morph, GLfloat* rdata, int option, P3_raypickable* parent) {
  P3_any_object* o;
  P3_morph_data* data;
  P3_morph_mesh* mesh;
  P3_morph_face* f;
  GLfloat z;
  int i; int j;
  GLfloat* raydata;

  data = morph->data;
  if (morph->option & (P3_OBJECT_NON_SOLID | P3_OBJECT_HIDDEN) || data->option & P3_OBJECT_NON_SOLID) { return P3_FALSE; }

//  P3_raypickable_compute_raypick ((P3_raypickable*) morph, rdata);
  raydata = P3_raypickable_get_raypick_data ((P3_raypickable*) morph, rdata);

  /* raypick on bounding sphere */
  if (data->bsphere[3] > 0.0 && P3_sphere_raypick (raydata, morph->data->bsphere) == P3_FALSE) { return P3_FALSE; }

  if (mesh->option & P3_R_FRONT_AND_BACK && option & P3_RAYPICK_CULL_FACE) {
    option -= P3_RAYPICK_CULL_FACE;
  }
  if (!(morph->option & P3_MORPH_RAYPICK_COMPUTED)) { P3_morph_compute_raypick (morph); }
  /* raypick on morph */
  for (i = 0; i < data->nb_m; i++) {
    mesh = data->meshes + i;
    f = data->f + mesh->f[0];
    if (f->nb_v == 3) {
      for (j = 0; j < mesh->nb_f; j++) {
        f = data->f + mesh->f[j];
        if (P3_triangle_raypick (rdata,
                                 morph->v_c_coords + (data->v + f->v[0])->coord,
                                 morph->v_c_coords + (data->v + f->v[1])->coord,
                                 morph->v_c_coords + (data->v + f->v[2])->coord,
                                 morph->f_c_normals + f->normal,
                                 option, &z) != P3_FALSE) {
          return P3_TRUE;
        }
      }
    } else if (f->nb_v == 4) {
      for (j = 0; j < mesh->nb_f; j++) {
        f = data->f + mesh->f[j];
        if (P3_quad_raypick (rdata,
                             morph->v_c_coords + (data->v + f->v[0])->coord,
                             morph->v_c_coords + (data->v + f->v[1])->coord,
                             morph->v_c_coords + (data->v + f->v[2])->coord,
                             morph->v_c_coords + (data->v + f->v[3])->coord,
                             morph->f_c_normals + f->normal,
                             option, &z) != P3_FALSE) {
          return P3_TRUE;
        }
      }
    }
  }

  /* raypick on sub worlds (chlidren) */
  for (i = 0; i < P3_children_size (morph->worlds); i++) {
    o = P3_children_get (morph->worlds, i);
    if (o->class->raypick_b (o, rdata, option, (P3_raypickable*) morph) == P3_TRUE) {
      return P3_TRUE;
    }
  }

  return P3_FALSE;
}




/* OLD STUFF */

void P3_morph_render (P3_morph* morph, P3_instance* csys) {
  P3_morph_data* d;
  P3_morph_face* f;
  P3_morph_vertex* v;
  P3_morph_mesh* m;
  P3_material* material;
  int i; int j; int k;
  int nb;
  GLfloat* buf_coord;
  GLfloat* buf_vnorm;
  GLfloat* buf_fnorm;

//printf("morph : render\n");

  d = morph->data;
  if (morph->v_c_coords != NULL) {
    buf_coord = morph->v_c_coords;
    buf_vnorm = morph->v_c_normals;
    buf_fnorm = morph->f_c_normals;
  } else {
    buf_coord = d->v_c_coords;
    buf_vnorm = d->v_c_normals;
    buf_fnorm = d->f_c_normals;
  }

  if (!(d->option & P3_MORPH_DATA_MIXED_ALPHA)) {
    P3_morph_compute (morph);
  }

  /* draw */
  glLoadIdentity ();

//printf("rendering %i morphing mesh\n", d->nb_m);

  for (i = 0; i < d->nb_m; i++) {
    m = d->meshes + i;

    if (d->option & P3_MORPH_DATA_MIXED_ALPHA) {
      if ((  morph->option & P3_MORPH_STATE_ALPHA  && !(m->option & P3_R_ALPHA)) ||
          (!(morph->option & P3_MORPH_STATE_ALPHA) &&   m->option & P3_R_ALPHA)) { continue; }
    }

    if (m->material == -1) {
      material = NULL;
    } else {
      if (morph->materials != NULL) {
        material = morph->materials[m->material];
      } else {
        material = d->materials[m->material];
      }
    }
    P3_material_activate (material); 
    f = d->f + m->f[0];
    nb = f->nb_v;

    if (m->option & P3_R_FRONT_AND_BACK) { 
      glLightModelf (GL_LIGHT_MODEL_TWO_SIDE, GL_TRUE);
      glDisable (GL_CULL_FACE);
    }
    if (m->option & P3_R_NEVER_LIT) { glDisable (GL_LIGHTING); }

//printf("morphing mesh has %i faces\n", m->nb_f);

    if      (nb == 3) { glBegin (GL_TRIANGLES); }
    else if (nb == 4) { glBegin (GL_QUADS); }
    else if (nb == 2) { glBegin (GL_LINES); }
    else if (nb == 1) { glBegin (GL_POINTS); }
    for (j = 0; j < m->nb_f; j++) {
      if (morph->f_visibility == NULL || morph->f_visibility[m->f[j]] == P3_MORPH_VISIBLE) {

//printf("draw face %i\n", m->f[j]);

// TO DO use arrays ?

        f = d->f + m->f[j];
        if (!(f->option & P3_MORPH_SMOOTHLIT) && f->normal != -1) {
          glNormal3fv (buf_fnorm + f->normal);
        }
        for (k = 0; k < nb; k++) {
          v = d->v + f->v[k];
          /* diffuse color */
          if (v->color != -1) { glColor4fv (d->v_colors + v->color); }
          /* point normal */
          if (v->option & P3_MORPH_HAS_NORMAL) { glNormal3fv (buf_vnorm + v->coord); }
          /* texcoord */
          if (v->texcoord != -1) { glTexCoord2fv (d->v_texcoords + v->texcoord); }
          /* coordinates */
          glVertex3fv (buf_coord + v->coord);

//printf("draw vertex %i (%f, %f, %f)\n", v->coord, d->v_c_coords[v->coord], d->v_c_coords[v->coord+1], d->v_c_coords[v->coord+2]);

        }
      }
    }
    glEnd ();
    if (m->option & P3_R_FRONT_AND_BACK) { 
      glLightModelf (GL_LIGHT_MODEL_TWO_SIDE, GL_FALSE);
      glEnable (GL_CULL_FACE);
    }
    if (m->option & P3_R_NEVER_LIT) { glEnable (GL_LIGHTING); }
//    P3_material_inactivate (material);
//    if (m->material != -1) { P3_material_inactivate (material); }
  }

  if (d->option & P3_MORPH_DATA_MIXED_ALPHA) {
    if (m->option & P3_MORPH_STATE_ALPHA) {
      m->option -= P3_MORPH_STATE_ALPHA;
    } else {
      m->option |= P3_MORPH_STATE_ALPHA;
    }
  }

//printf("... done\n");

}

#endif
