/*
 * P3 python wrapper
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*****************************************
 * face_python.h : wrapper for python
 * Copyright (C) 2002 Bertrand 'blam' LAMY
 *****************************************/


#define P3_face   PyObject
#define P3_vertex PyObject

P3_face*     P3_face_new                 (P3_world*, P3_material*, int nb_v, ...);
P3_material* P3_face_get_material        (PyObject* face);
//int          P3_face_get_option          (PyObject* face);
P3_coordsys* P3_face_get_coordsys        (PyObject* face);
void         P3_face_get_box             (PyObject* face, GLfloat* box, int* edited);
int          P3_face_is_smoothlit        (P3_face*);
int          P3_face_is_double_sided     (P3_face*);
int          P3_face_is_solid            (P3_face*);
int          P3_face_is_alpha            (P3_face*);
int          P3_face_is_colored          (P3_face*);
//int          P3_face_is_static_lit       (P3_face*);
int          P3_face_can_be_lit          (P3_face*);
//int          P3_face_cell_shading        (P3_face*);
int          P3_face_get_vertices_number (P3_face*);
P3_vertex*   P3_face_get_vertex          (P3_face*, int index);
void         P3_face_set_smoothlit       (P3_face*, int);
void         P3_face_set_double_sided    (P3_face*, int);
void         P3_face_set_solid           (P3_face*, int);
void         P3_face_set_can_be_lit      (P3_face*, int);
//void         P3_face_set_static_lit      (P3_face*, int);
//void         P3_face_set_cell_shading    (P3_face*, int);

void P3_face_add_vertex (P3_face* face, P3_vertex* vertex);

/*
#define P3_face_set_smoothlit(face, value) \
  PyObject_SetAttrString (face, "smooth_lit", PyInt_FromLong (value))
#define P3_face_set_double_sided(face, value) \
  PyObject_SetAttrString (face, "double_sided", PyInt_FromLong (value))
#define P3_face_set_solid(face, value) \
  PyObject_SetAttrString (face, "solid", PyInt_FromLong (value))
#define P3_face_set_static_lit(face, value) \
  PyObject_SetAttrString (face, "static_lit", PyInt_FromLong (value))
#define P3_face_set_can_be_lit(face, value) \
  PyObject_SetAttrString (face, "lit", PyInt_FromLong (value))
*/

P3_vertex*   P3_vertex_new          (P3_world*, GLfloat, GLfloat, GLfloat);
P3_coordsys* P3_vertex_get_coordsys (P3_vertex*);
void         P3_vertex_get_coord    (P3_vertex*, GLfloat*);
void         P3_vertex_get_texcoord (P3_vertex*, GLfloat*);
void         P3_vertex_get_diffuse  (P3_vertex*, GLfloat*);
void         P3_vertex_get_emissive (P3_vertex*, GLfloat*);
void         P3_vertex_set_texcoord (P3_vertex*, GLfloat*);
void         P3_vertex_set_diffuse  (P3_vertex*, GLfloat*);
void         P3_vertex_set_emissive (P3_vertex*, GLfloat*);

int          P3_vertex_is_morphing  (P3_vertex* v);
P3_material* P3_vertex_get_material (P3_vertex* v);

/*
#define P3_vertex_set_texcoord(vertex, uv) \
  PyObject_SetAttrString (vertex, "tex_x", PyFloat_FromDouble ((double) (uv)[0])); \
  PyObject_SetAttrString (vertex, "tex_y", PyFloat_FromDouble ((double) (uv)[1]))
*/

#define P3_vertex_set_material(vertex, value) \
  PyObject_SetAttrString (vertex, "material", (PyObject*) value)

/*
#define P3_vertex_get_r(vertex) \
  (GLfloat) PyFloat_AS_DOUBLE (PyObject_GetAttrString (vertex, "r"))
#define P3_vertex_get_g(vertex) \
  (GLfloat) PyFloat_AS_DOUBLE (PyObject_GetAttrString (vertex, "g"))
#define P3_vertex_get_b(vertex) \
  (GLfloat) PyFloat_AS_DOUBLE (PyObject_GetAttrString (vertex, "b"))
#define P3_vertex_get_a(vertex) \
  (GLfloat) PyFloat_AS_DOUBLE (PyObject_GetAttrString (vertex, "a"))
*/


/*
#define P3_vertex_get_x(vertex) \
  (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (PyObject_GetAttrString (face, "coord"), 0))
#define P3_vertex_get_y(vertex) \
  (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (PyObject_GetAttrString (face, "coord"), 1))
#define P3_vertex_get_z(vertex) \
  (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (PyObject_GetAttrString (face, "coord"), 2))
#define P3_vertex_get_r(vertex) \
  (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (PyObject_GetAttrString (face, "color"), 0))
#define P3_vertex_get_g(vertex) \
  (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (PyObject_GetAttrString (face, "color"), 1))
#define P3_vertex_get_b(vertex) \
  (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (PyObject_GetAttrString (face, "color"), 2))
#define P3_vertex_get_a(vertex) \
  (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (PyObject_GetAttrString (face, "color"), 3))
#define P3_vertex_get_u(vertex) \
  (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (PyObject_GetAttrString (face, "texcoord"), 0))
#define P3_vertex_get_v(vertex) \
  (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (PyObject_GetAttrString (face, "texcoord"), 1))
*/  
