/*
 * P3 python wrapper
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**********************************************
 * Copyright (C) 2002-2003 Bertrand 'blam' LAMY
 **********************************************/

/*====================*
 * COORDSYS ANIMATION *
 *====================*/

static int PyP3AnimCoordsys_Init (P3_anim_coordsys* self, PyObject* args, PyObject* kwds) {
  P3_anim_coordsys_new (self);
	return 0;
}

static void PyP3AnimCoordsys_Dealloc (P3_anim_coordsys* d) {
  free (d->states);
  d->ob_type->tp_free ((PyObject*) d);
}

static PyObject* PyP3AnimCoordsys_AddState (P3_anim_coordsys* a, PyObject* args) {
  P3_anim_coordsys_add_state (a, (P3_coordsys*) PySequence_Fast_GET_ITEM (args, 0), PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 1)));
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3AnimCoordsys_RemoveState (P3_anim_coordsys* a, PyObject* arg) {
  if (PyFloat_Check (arg)) {
    P3_anim_coordsys_remove_state (a, (float) PyFloat_AS_DOUBLE (arg));
  } else if (PyInt_Check (arg)) {
    P3_anim_coordsys_delete_state (a, (int) PyInt_AS_LONG (arg));
  }
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3AnimCoordsys_GetTimeFor (P3_anim_coordsys* d, PyObject* arg) {
  return PyFloat_FromDouble ((double) (d->states + PyInt_AS_LONG (arg))->time);
}

static PyObject* PyP3AnimCoordsys_SetTimeFor (P3_anim_coordsys* d, PyObject* args) {
  (d->states + PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 0)))->time = (float) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 1));
  Py_INCREF (Py_None);
  return Py_None;
}

/*
static PyObject* PyP3AnimCoordsys_GetState (P3_anim_coordsys* a) {
  void* buffer;
  void* buf;
  int all_size;
//  int i;
  PyObject* o;
//  P3_state_coordsys* state;
  all_size = (3 + a->nb_states) * sizeof (float) + (19 + 4) * a->nb_states * sizeof (GLfloat) + sizeof (int);
  buffer = (void*) malloc (all_size);
  all_size /= (double) sizeof (char);
  buf = buffer;
  PUT_IN_BUFFER (buf, a->nb_states,  int);
  PUT_IN_BUFFER (buf, a->cyclic_lap, float);
  PUT_IN_BUFFER (buf, a->time_min,   float);
  PUT_IN_BUFFER (buf, a->time_max,   float);
  PUT_ARRAY_IN_BUFFER (buf, a->states, a->nb_states, P3_state_coordsys);
//  for (i = 0; i < a->nb_states; i++) {
//    state = a->states + i;
//    PUT_IN_BUFFER (buf, state->time, float);
//    PUT_ARRAY_IN_BUFFER (buf, state->quaternion,  4, GLfloat);
//    PUT_ARRAY_IN_BUFFER (buf, state->m,          19, GLfloat);
//  }
  o = PyString_FromStringAndSize ((char*) buffer, all_size);
  free (buffer);
  return o;
}

static PyObject* PyP3AnimCoordsys_SetState (P3_anim_coordsys* a, PyObject* arg) {
  void* buf;
//  int i;
  buf = (void*) PyString_AS_STRING (arg);
  GET_FROM_BUFFER (buf, a->nb_states,  int);
  GET_FROM_BUFFER (buf, a->cyclic_lap, float);
  GET_FROM_BUFFER (buf, a->time_min,   float);
  GET_FROM_BUFFER (buf, a->time_max,   float);
  GET_MALLOC_ARRAY_FROM_BUFFER (buf, a->states, a->nb_states, P3_state_coordsys);
//  a->states = (P3_state_coordsys*) malloc (a->nb_states * sizeof (P3_coordsys_state));
//  for (i = 0; i < a->nb_states; i++) {
//    state = a->states + i;
//    GET_FROM_BUFFER (buf, state->time, float);
//    GET_ARRAY_FROM_BUFFER (buf, state->quaternion,  4, GLfloat);
//    GET_ARRAY_FROM_BUFFER (buf, state->m,          19, GLfloat);
//  }
  Py_INCREF (Py_None);
  return Py_None;
}
*/

static PyMethodDef PyP3AnimCoordsys_Methods[] = {
  { "add",          (PyCFunction) PyP3AnimCoordsys_AddState,    METH_VARARGS },
  { "remove",       (PyCFunction) PyP3AnimCoordsys_RemoveState, METH_O },
  { "get_time_for", (PyCFunction) PyP3AnimCoordsys_GetTimeFor,  METH_O },
  { "set_time_for", (PyCFunction) PyP3AnimCoordsys_SetTimeFor,  METH_VARARGS },
//  { "_getstate",    (PyCFunction) PyP3AnimCoordsys_GetState,    METH_NOARGS },
//  { "_setstate",    (PyCFunction) PyP3AnimCoordsys_SetState,    METH_O },
  { NULL, NULL }
};

static PyObject* PyP3AnimCoordsys_GetNbStates (P3_anim_coordsys* d, void* context) {
  return PyInt_FromLong ((long) d->nb_states);
}

PY_GET_SET_ON_FLOAT (AnimCoordsys, P3_anim_coordsys*, CyclicLap, cyclic_lap)

static PyGetSetDef PyP3AnimCoordsys_GetSets[] = {
	{ "cyclic_lap",    (getter) PyP3AnimCoordsys_GetCyclicLap, (setter) PyP3AnimCoordsys_SetCyclicLap, NULL },
	{ "states_number", (getter) PyP3AnimCoordsys_GetNbStates,  (setter) 0,                             NULL },
  { NULL }
};

PyTypeObject PyP3AnimCoordsys_Type = {
  PyObject_HEAD_INIT(NULL)
  0,
  "_soya._AnimCoordsys",
  sizeof(P3_anim_coordsys),
  0,
  (destructor) PyP3AnimCoordsys_Dealloc,/* tp_dealloc */
  0,/* tp_print */
  0,/* tp_getattr */
  0,/* tp_setattr */
  0,/* tp_compare */
  0,/* tp_repr */
  0,/* tp_as_number */
  0,/* tp_as_sequence */
  0,/* tp_as_mapping */
  0,/* tp_hash */
  0,/* tp_call */
  0,/* tp_str */
  PYP3_GENERIC_GETATTR,/* tp_getattro */
  0,/* tp_setattro */
  0,/* tp_as_buffer */
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,/* tp_flags */
  0,/* tp_doc */
  (traverseproc) 0,/* tp_traverse */
  (inquiry) 0,/* tp_clear */
  0,/* tp_richcompare */
  0,/* tp_weaklistoffset */
  0,/* tp_iter */
  0,/* tp_iternext */
  (PyMethodDef*) PyP3AnimCoordsys_Methods,/* tp_methods */
  0,/* tp_members */
  (PyGetSetDef*) PyP3AnimCoordsys_GetSets,/* tp_getset */
  0,/* tp_base */
  0,/* tp_dict */
  0,/* tp_descr_get */
  0,/* tp_descr_set */
  0,/* tp_dictoffset */
  (initproc) PyP3AnimCoordsys_Init,/* tp_init */
  PYP3_GENERIC_ALLOC,/* tp_alloc */
  (newfunc) PyP3Object_New,/* tp_new */
  PYP3_GENERIC_FREE,/* tp_free */
};


