/*
 * P3 python wrapper
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*****************************************
 * Copyright (C) 2002 Bertrand 'blam' LAMY
 *****************************************/

/*---------+
 | Methods |
 +---------*/

static PyObject* PyP3Coordsys_TurnAxe (P3_coordsys* o, PyObject* args) {
  P3_matrix_turn_axe (o->m,
                      (GLfloat) P3_to_radians (PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 0))),
                      (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 1)),
                      (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 2)),
                      (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 3)));
  P3_object_invalid ((P3_any_object*) o);
  Py_INCREF (Py_None);
  return Py_None;
}

/*
static int PyP3Child_Traverse (P3_child* a, visitproc visit, void* arg) {
	int err;
  if (a->parent != NULL) {
    err = visit ((PyObject*) a->parent, arg);
    if (err) { return err; }
  }
	return 0;
}

static int PyP3Child_Clear (P3_child* a) {
  Py_XDECREF (a->parent);
  a->parent = NULL;
  return 0;
}

static PyObject* PyP3Coordsys_TransformPoint (P3_any_object* o, PyObject* args) {
  P3_any_object* obj;
  PyObject* ret;
  GLfloat p[3];
  p[0] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 0));
  p[1] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 1));
  p[2] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 2));
  obj = (P3_any_object*) PySequence_Fast_GET_ITEM (args, 3);
  if (obj != NULL && (PyObject*) obj != Py_None) {
    P3_point_by_matrix (p, P3_coordsys_get_root_matrix ((P3_coordsys*) obj));
  }
  P3_point_by_matrix (p, P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) o));
  ret = PyTuple_New (3);
  PyTuple_SET_ITEM (ret, 0, PyFloat_FromDouble ((double) p[0]));
  PyTuple_SET_ITEM (ret, 1, PyFloat_FromDouble ((double) p[1]));
  PyTuple_SET_ITEM (ret, 2, PyFloat_FromDouble ((double) p[2]));
  return ret;
}

static PyObject* PyP3Coordsys_TransformVector (P3_any_object* o, PyObject* args) {
  P3_any_object* obj;
  PyObject* ret;
  GLfloat p[3];
  p[0] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 0));
  p[1] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 1));
  p[2] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 2));
  obj = (P3_any_object*) PySequence_Fast_GET_ITEM (args, 3);
  if ((PyObject*) obj != Py_None && obj != NULL) {
    P3_vector_by_matrix (p, P3_coordsys_get_root_matrix ((P3_coordsys*) obj));
  }
  P3_vector_by_matrix (p, P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) o));
  ret = PyTuple_New (3);
  PyTuple_SET_ITEM (ret, 0, PyFloat_FromDouble ((double) p[0]));
  PyTuple_SET_ITEM (ret, 1, PyFloat_FromDouble ((double) p[1]));
  PyTuple_SET_ITEM (ret, 2, PyFloat_FromDouble ((double) p[2]));
  return ret;
}

static PyObject* PyP3Coordsys_Translate (P3_any_object* o, PyObject* arg) {
  P3_matrix_translate (((P3_coordsys*) o)->m, 
                       (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 0)),
                       (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 1)),
                       (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 2)));
  P3_object_invalid (o);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_Shift (P3_any_object* o, PyObject* arg) {
  GLfloat fx = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 0));
  GLfloat fy = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 1));
  GLfloat fz = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 2));
  GLfloat* m = ((P3_coordsys*) o)->m;
  m[12] += fx * m[0] + fy * m[4] + fz * m[ 8];
  m[13] += fx * m[1] + fy * m[5] + fz * m[ 9];
  m[14] += fx * m[2] + fy * m[6] + fz * m[10];
  P3_object_invalid (o);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_SetXYZ (P3_coordsys* o, PyObject* arg) {
  o->m[12] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 0));
  o->m[13] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 1));
  o->m[14] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 2));
  P3_object_invalid ((P3_any_object*) o);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_Scale (P3_coordsys* o, PyObject* arg) {
  P3_matrix_scale (o->m, 
                   (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 0)),
                   (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 1)),
                   (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 2)));
  P3_object_invalid ((P3_any_object*) o);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_SetIdentity (P3_coordsys* o) {
  P3_matrix_set_identity (o->m);
  P3_object_invalid ((P3_any_object*) o);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_LookAtZ (P3_coordsys* csys, PyObject* arg) {
  GLfloat p[3];
  PyObject* o;
  PyObject* v;
  GET_PY_COORD(p, arg, o);
  o = PyObject_GetAttrString (arg, "parent");
// TO DO stock new_vector somewhere ?
  v = PyObject_GetAttrString (P3Module, "new_vector");
  if (PyObject_IsInstance (arg, v) == 1) {
    if (o != (PyObject*) csys->parent && o != Py_None && (PyObject*) csys->parent != Py_None) {
      P3_vector_by_matrix (p, P3_coordsys_get_root_matrix ((P3_coordsys*) o));
      P3_vector_by_matrix (p, P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) csys->parent));
    }
    P3_matrix_look_to_Z (csys->m, p);
  } else {
    if (o != (PyObject*) csys->parent && o != Py_None && (PyObject*) csys->parent != NULL) {
      P3_point_by_matrix (p, P3_coordsys_get_root_matrix ((P3_coordsys*) o));
      P3_point_by_matrix (p, P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) csys->parent));
    }
    P3_matrix_look_at_Z (csys->m, p);
  }
  Py_DECREF (o);
  Py_DECREF (v);
  P3_object_invalid ((P3_any_object*) csys);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_LookAtY (P3_coordsys* csys, PyObject* arg) {
  GLfloat p[3];
  PyObject* o;
  PyObject* v;
  GET_PY_COORD(p, arg, o);
  o = PyObject_GetAttrString (arg, "parent");
// TO DO stock new_vector somewhere ?
  v = PyObject_GetAttrString (P3Module, "new_vector");
  if (PyObject_IsInstance (arg, v) == 1) {
    if (o != (PyObject*) csys->parent && o != Py_None && (PyObject*) csys->parent != Py_None) {
      P3_vector_by_matrix (p, P3_coordsys_get_root_matrix ((P3_coordsys*) o));
      P3_vector_by_matrix (p, P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) csys->parent));
    }
    P3_matrix_look_to_Y (csys->m, p);
  } else {
    if (o != (PyObject*) csys->parent && o != Py_None && (PyObject*) csys->parent != NULL) {
      P3_point_by_matrix (p, P3_coordsys_get_root_matrix ((P3_coordsys*) o));
      P3_point_by_matrix (p, P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) csys->parent));
    }
    P3_matrix_look_at_Y (csys->m, p);
  }
  Py_DECREF (o);
  Py_DECREF (v);
  P3_object_invalid ((P3_any_object*) csys);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_LookAtX (P3_coordsys* csys, PyObject* arg) {
  GLfloat p[3];
  PyObject* o;
  PyObject* v;
  GET_PY_COORD(p, arg, o);
  o = PyObject_GetAttrString (arg, "parent");
// TO DO stock new_vector somewhere ?
  v = PyObject_GetAttrString (P3Module, "new_vector");
  if (PyObject_IsInstance (arg, v) == 1) {
    if (o != (PyObject*) csys->parent && o != Py_None && (PyObject*) csys->parent != Py_None) {
      P3_vector_by_matrix (p, P3_coordsys_get_root_matrix ((P3_coordsys*) o));
      P3_vector_by_matrix (p, P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) csys->parent));
    }
    P3_matrix_look_to_X (csys->m, p);
  } else {
    if (o != (PyObject*) csys->parent && o != Py_None && (PyObject*) csys->parent != NULL) {
      P3_point_by_matrix (p, P3_coordsys_get_root_matrix ((P3_coordsys*) o));
      P3_point_by_matrix (p, P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) csys->parent));
    }
    P3_matrix_look_at_X (csys->m, p);
  }
  Py_DECREF (o);
  Py_DECREF (v);
  P3_object_invalid ((P3_any_object*) csys);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_TurnLateral (P3_coordsys* o, PyObject* arg) {
  P3_matrix_turn_lateral (o->m, (GLfloat) P3_to_radians(PyFloat_AS_DOUBLE (arg)));
  P3_object_invalid ((P3_any_object*) o);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_RotateLateral (P3_coordsys* o, PyObject* arg) {
  P3_matrix_rotate_lateral (o->m, (GLfloat) P3_to_radians(PyFloat_AS_DOUBLE (arg)));
  P3_object_invalid ((P3_any_object*) o);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_TurnVertical (P3_coordsys* o, PyObject* arg) {
  P3_matrix_turn_vertical (o->m, (GLfloat) P3_to_radians(PyFloat_AS_DOUBLE (arg)));
  P3_object_invalid ((P3_any_object*) o);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_RotateVertical (P3_coordsys* o, PyObject* arg) {
  P3_matrix_rotate_vertical (o->m, (GLfloat) P3_to_radians(PyFloat_AS_DOUBLE (arg)));
  P3_object_invalid ((P3_any_object*) o);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_TurnIncline (P3_coordsys* o, PyObject* arg) {
  P3_matrix_turn_incline (o->m, (GLfloat) P3_to_radians(PyFloat_AS_DOUBLE (arg)));
  P3_object_invalid ((P3_any_object*) o);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_RotateIncline (P3_coordsys* o, PyObject* arg) {
  P3_matrix_rotate_incline (o->m, (GLfloat) P3_to_radians(PyFloat_AS_DOUBLE (arg)));
  P3_object_invalid ((P3_any_object*) o);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_RotateAxe (P3_coordsys* o, PyObject* args) {
  GLfloat x; GLfloat y; GLfloat z; 
  GLfloat* m = o->m;
  x = m[12]; y = m[13]; z = m[14];
  m[12] = 0.0; m[13] = 0.0; m[14] = 0.0; 
  P3_matrix_rotate_axe (m, 
                        (GLfloat) P3_to_radians (PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 0))),
                        (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 1)),
                        (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 2)),
                        (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 3)));
  m[12] = x; m[13] = y; m[14] = z; 
  P3_object_invalid ((P3_any_object*) o);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_Rotate (P3_coordsys* o, PyObject* args) {
  GLfloat p1[3];
  GLfloat p2[3];
  GLfloat x; GLfloat y; GLfloat z; 
  GLfloat* m = o->m;
  x = m[12]; y = m[13]; z = m[14];
  m[12] = 0.0; m[13] = 0.0; m[14] = 0.0; 
  p1[0] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 1));
  p1[1] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 2));
  p1[2] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 3));
  p2[0] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 4));
  p2[1] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 5));
  p2[2] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 6));
  P3_matrix_rotate (m, (GLfloat) P3_to_radians(PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 0))), p1, p2);
  m[12] = x; m[13] = y; m[14] = z;
  P3_object_invalid ((P3_any_object*) o);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_GetRoot (P3_coordsys* o) {
  PyObject* r;
  r = (PyObject*) P3_coordsys_get_root (o);
  if (r == NULL) {
    Py_INCREF (Py_None);
    return Py_None;
  } else {
    Py_INCREF (r);
    return r;
  }
}

static PyObject* PyP3Coordsys_DistanceTo (P3_coordsys* c, PyObject* arg) {
  PyObject* csys;
  PyObject* o;
  GLfloat a[3];
  csys = PyObject_GetAttrString (c, "parent");
  GET_PY_POINT_COORD(a, arg, o, csys)
  Py_DECREF (csys);
  a[0] -= c->m[12];
  a[1] -= c->m[13];
  a[2] -= c->m[14];
  return PyFloat_FromDouble (sqrt (a[0] * a[0] + a[1] * a[1] + a[2] * a[2]));
}
*/

/*
static PyObject* PyP3Coordsys_SetAnimState (P3_coordsys* c, PyObject* args) {
  // args : anim, prev_time, new_time
  P3_coordsys_set_state (c, (P3_anim_coordsys*) PySequence_Fast_GET_ITEM (args, 0), (float) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 1)), (float) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 2)));
  Py_INCREF (Py_None);
  return Py_None;
}
*/

#define PYP3_COORDSYS_FUNCS \
  { "raypick",          (PyCFunction) PyP3Coordsys_Raypick,         METH_VARARGS }, \
  { "raypick_b",        (PyCFunction) PyP3Coordsys_RaypickB,        METH_VARARGS }, \
  { "get_root",         (PyCFunction) PyP3Coordsys_GetRoot,         METH_NOARGS }, \
  { "translate",        (PyCFunction) PyP3Coordsys_Translate,       METH_VARARGS }, \
  { "shift",            (PyCFunction) PyP3Coordsys_Shift,           METH_VARARGS }, \
  { "set_xyz",          (PyCFunction) PyP3Coordsys_SetXYZ,          METH_VARARGS }, \
  { "rotate_incline",   (PyCFunction) PyP3Coordsys_RotateIncline,   METH_O }, \
  { "rotate_vertical",  (PyCFunction) PyP3Coordsys_RotateVertical,  METH_O }, \
  { "rotate_lateral",   (PyCFunction) PyP3Coordsys_RotateLateral,   METH_O }, \
  { "rotate_axe",       (PyCFunction) PyP3Coordsys_RotateAxe,       METH_VARARGS }, \
  { "rotate",           (PyCFunction) PyP3Coordsys_Rotate,          METH_VARARGS }, \
  { "turn_incline",     (PyCFunction) PyP3Coordsys_TurnIncline,     METH_O }, \
  { "turn_vertical",    (PyCFunction) PyP3Coordsys_TurnVertical,    METH_O }, \
  { "turn_lateral",     (PyCFunction) PyP3Coordsys_TurnLateral,     METH_O }, \
  { "turn_axe",         (PyCFunction) PyP3Coordsys_TurnAxe,         METH_VARARGS }, \
  { "look_at",          (PyCFunction) PyP3Coordsys_LookAtZ,         METH_O }, \
  { "look_at_y",        (PyCFunction) PyP3Coordsys_LookAtY,         METH_O }, \
  { "look_at_x",        (PyCFunction) PyP3Coordsys_LookAtX,         METH_O }, \
  { "set_identity",     (PyCFunction) PyP3Coordsys_SetIdentity,     METH_NOARGS }, \
  { "scale",            (PyCFunction) PyP3Coordsys_Scale,           METH_VARARGS }, \
  { "transform_point",  (PyCFunction) PyP3Coordsys_TransformPoint,  METH_VARARGS }, \
  { "transform_vector", (PyCFunction) PyP3Coordsys_TransformVector, METH_VARARGS }, \
  { "distance_to",      (PyCFunction) PyP3Coordsys_DistanceTo,      METH_O }
//  { "set_anim_state",   (PyCFunction) PyP3Coordsys_SetAnimState,    METH_VARARGS },


/*---------+
 | Get Set |
 +---------*/
/*
PY_GET_SET_ON_FLOAT_ADD       (Coordsys, P3_coordsys*, X, m[12], P3_object_invalid ((P3_any_object*) a);)
PY_GET_SET_ON_FLOAT_ADD       (Coordsys, P3_coordsys*, Y, m[13], P3_object_invalid ((P3_any_object*) a);)
PY_GET_SET_ON_FLOAT_ADD       (Coordsys, P3_coordsys*, Z, m[14], P3_object_invalid ((P3_any_object*) a);)
PY_GET_SET_ON_FLOAT_ARRAY_ADD (Coordsys, P3_coordsys*, Matrix, m, 19, P3_object_invalid ((P3_any_object*) a);)
PY_GET_SET_ON_OBJECT_ADD      (Child, P3_child*, Parent, parent, P3_coordsys*, P3_object_invalid ((P3_any_object*) a);)

static PyObject* PyP3Coordsys_GetXScale (P3_coordsys* m, void* context) {
  return PyFloat_FromDouble((double) m->m[16]);
}
static PyObject* PyP3Coordsys_GetYScale (P3_coordsys* m, void* context) {
  return PyFloat_FromDouble((double) m->m[17]);
}
static PyObject* PyP3Coordsys_GetZScale (P3_coordsys* m, void* context) {
  return PyFloat_FromDouble((double) m->m[18]);
}

static int PyP3Coordsys_SetXScale (P3_coordsys* m, PyObject* value, void* context) {
  P3_matrix_scale (m->m, (GLfloat) PyFloat_AS_DOUBLE (value) / m->m[16], 1.0, 1.0);
  P3_object_invalid ((P3_any_object*) m);
  return 0;
}
static int PyP3Coordsys_SetYScale (P3_coordsys* m, PyObject* value, void* context) {
  P3_matrix_scale (m->m, 1.0, (GLfloat) PyFloat_AS_DOUBLE (value) / m->m[17], 1.0);
  P3_object_invalid ((P3_any_object*) m);
  return 0;
}
static int PyP3Coordsys_SetZScale (P3_coordsys* m, PyObject* value, void* context) {
  P3_matrix_scale (m->m, 1.0, 1.0, (GLfloat) PyFloat_AS_DOUBLE (value) / m->m[18]);
  P3_object_invalid ((P3_any_object*) m);
  return 0;
}

static int PyP3Child_ChangeParent (P3_child* m, PyObject* value, void* context) {
  PyObject* p;
  if (m->parent != NULL) {
    p = PyObject_CallMethod (((P3_world*) m->parent)->children, "remove", "O", m);
    Py_XDECREF (p);
  }
  if (value == Py_None || value == NULL) {
    m->parent = NULL;
  } else {
    m->parent = (P3_coordsys*) value;
    Py_INCREF (value);
    p = PyObject_CallMethod (((P3_world*) value)->children, "append", "O", m);
  }
  P3_object_invalid ((P3_any_object*) m);
  return 0;
}
*/

#define PYP3_CHILD_GETSETS \
  { "_parent", (getter) PyP3Child_GetParent, (setter) PyP3Child_SetParent,    NULL }, \
  { "parent",  (getter) PyP3Child_GetParent, (setter) PyP3Child_ChangeParent, NULL }

#define PYP3_COORDSYS_GETSETS \
  { "x",       (getter) PyP3Coordsys_GetX,      (setter) PyP3Coordsys_SetX,      NULL }, \
  { "y",       (getter) PyP3Coordsys_GetY,      (setter) PyP3Coordsys_SetY,      NULL }, \
  { "z",       (getter) PyP3Coordsys_GetZ,      (setter) PyP3Coordsys_SetZ,      NULL }, \
  { "scale_x", (getter) PyP3Coordsys_GetXScale, (setter) PyP3Coordsys_SetXScale, NULL }, \
  { "scale_y", (getter) PyP3Coordsys_GetYScale, (setter) PyP3Coordsys_SetYScale, NULL }, \
  { "scale_z", (getter) PyP3Coordsys_GetZScale, (setter) PyP3Coordsys_SetZScale, NULL }, \
  { "_matrix", (getter) PyP3Coordsys_GetMatrix, (setter) PyP3Coordsys_SetMatrix, NULL }


