/*
 * P3 python wrapper
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*****************************************
 * Copyright (C) 2002 Bertrand 'blam' LAMY
 *****************************************/

/*=========*
 * MATH 3D *
 *=========*/

static PyObject* PyP3_PointsNormal (PyObject* module, PyObject* args) {
  P3_coordsys* csys;
  P3_vector* v;
  GLfloat* a;
  GLfloat b[3];
  GLfloat c[3];
  PyP3_GetPosition (PySequence_Fast_GET_ITEM (args, 0), &a, &csys);
  PyP3_GetPositionInto (PySequence_Fast_GET_ITEM (args, 1), csys, b);
  PyP3_GetPositionInto (PySequence_Fast_GET_ITEM (args, 2), csys, c);
  if (PySequence_Size (args) == 4) {
    v = (P3_vector*) PySequence_Fast_GET_ITEM (args, 3);
    Py_XDECREF ((PyObject*) v->parent);
    v->parent = csys;
    if (csys != NULL) Py_INCREF ((PyObject*) csys);
    P3_face_normal (v->coord, a, b, c);
    Py_INCREF (Py_None);
    return Py_None;
  } else {
    v = (P3_vector*) PyP3Vector_Type.tp_alloc (&PyP3Vector_Type, 0);
    v->parent = csys;
    if (csys != NULL) Py_INCREF ((PyObject*) csys);
    P3_face_normal (v->coord, a, b, c);
    return (PyObject*) v;
  }
}


/*==================*
 * ENGINE FUNCTIONS *
 *==================*/

static PyObject* PyP3_ActivateMaterial (PyObject* module, P3_material* a) {
  if ((PyObject*) a == Py_None) { a = NULL; }
  P3_material_activate (a);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3_GetScreenWidth (PyObject* module) {
  return PyInt_FromLong ((long) screen_w);
}

static PyObject* PyP3_GetScreenHeight (PyObject* module) {
  return PyInt_FromLong ((long) screen_h);
}

static PyObject* PyP3_GetCamera (PyObject* module) {
  if (renderer->c_camera == NULL) {
    Py_INCREF (Py_None);
    return Py_None;
  }
  Py_INCREF ((PyObject*) renderer->c_camera);
  return (PyObject*) renderer->c_camera;
}

static PyObject* PyP3_RendererAdd (PyObject* module, PyObject* args) {
  long i;
  P3_instance* parent;
  parent = (P3_instance*) PySequence_Fast_GET_ITEM (args, 1);
  i      = PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 2));
  if (i == 0) {
    P3_renderer_add (PySequence_Fast_GET_ITEM (args, 0), parent);
  } else if (i == 1) {
    P3_renderer_add_alpha (PySequence_Fast_GET_ITEM (args, 0), parent);
  } else if (i == 2) {
    void* o;
    o = PySequence_Fast_GET_ITEM (args, 0);
    P3_renderer_add       (o, parent);
    P3_renderer_add_alpha (o, parent);
  }
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3_SetQuality (PyObject* module, PyObject* arg) {
  P3_set_quality ((int) PyInt_AS_LONG (arg));
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3_SetShadow (PyObject* module, PyObject* arg) {
  if (PyObject_IsTrue (arg)) engine_option |=  P3_SHADOWS;
  else                       engine_option &= ~P3_SHADOWS;
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3_ToggleWireFrame (PyObject* module) {
  P3_toggle_wireframe_mode ();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3_MinimizeWindow (PyObject* module) {
#ifdef USE_SDL
  SDL_WM_IconifyWindow ();
#endif /* USE_SDL */
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3_ToggleFullscreen (PyObject* module) {
#ifdef USE_SDL
  SDL_WM_ToggleFullScreen (screen);
#endif /* USE_SDL */
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3_SetCursorVisibility (PyObject* module, PyObject* arg) {
#ifdef USE_GLX

  static Cursor blank_cursor = 0;

  if (blank_cursor == 0) {
    blank_cursor = XCreateFontCursor (display, 0);
  }

// TO DO
  if (PyObject_IsTrue (arg) == 1) {
    XUndefineCursor (display, window);
  } else {
    XDefineCursor (display, window, blank_cursor);
  }
#endif /* USE_GLX */
#ifdef USE_SDL
  if (PyObject_IsTrue (arg) == 1) {
    SDL_ShowCursor (SDL_ENABLE);
  } else {
    SDL_ShowCursor (SDL_DISABLE);
  }
#endif /* USE_SDL */
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3_SetCursorPosition (PyObject* module, PyObject* args) {
#ifdef USE_GLX
  XWarpPointer (display, window, window, 0, 0, 0, 0, PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 0)), PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 1)));
#endif /* USE_GLX */
#ifdef USE_SDL
  SDL_WarpMouse ((Uint16) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 0)), (Uint16) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 1)));
#endif /* USE_SDL */
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3_Init (PyObject* module, PyObject* args) {
  PyObject* o;
  char* str;
  P3_base_init ();
  if (args != NULL && args != Py_None) {
    if (PySequence_Size (args) == 5) {
      o = PySequence_Fast_GET_ITEM (args, 0);
      if (o == NULL || o == Py_None) {
        str = NULL;
      } else {
        str = PyString_AsString (o);
      }
      P3_init_video (str, 
                     (int) PyInt_AsLong (PySequence_Fast_GET_ITEM (args, 1)), 
                     (int) PyInt_AsLong (PySequence_Fast_GET_ITEM (args, 2)), 
                     PyObject_IsTrue (PySequence_Fast_GET_ITEM (args, 3)), 
                     PyObject_IsTrue (PySequence_Fast_GET_ITEM (args, 4)));
    } else if (PySequence_Size (args) == 2) {
      screen_w = (int) PyInt_AsLong (PySequence_Fast_GET_ITEM (args, 0));
      screen_h = (int) PyInt_AsLong (PySequence_Fast_GET_ITEM (args, 1));
      P3_init_GL ();
    }
  }
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3_SetVideo (PyObject* module, PyObject* args) {
  P3_set_video ((int) PyInt_AsLong (PySequence_Fast_GET_ITEM (args, 0)), 
                (int) PyInt_AsLong (PySequence_Fast_GET_ITEM (args, 1)), 
                PyObject_IsTrue (PySequence_Fast_GET_ITEM (args, 2)), 
                PyObject_IsTrue (PySequence_Fast_GET_ITEM (args, 3)));
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3_Quit (PyObject* module) {
  P3_base_quit ();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3_Display (PyObject* module) {
  if (engine_option & P3_GL_INITED) {
    glPrintError ();
#ifdef USE_GLX
    glXSwapBuffers (display, window);
#endif /* USE_GLX */
#ifdef USE_SDL
    SDL_GL_SwapBuffers ();
#endif /* USE_SDL */
  }
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3_Screenshot (PyObject* module, PyObject* arg) {
  P3_screenshot (PyString_AS_STRING (arg));
  Py_INCREF (Py_None);
  return Py_None;
}


/*========*
 * EVENTS *
 *========*/

static PyObject* PyP3_GetModifier (PyObject* module) {
#ifdef USE_GLX
  Window root_return;
  Window child_return;
  int root_x_return;
  int root_y_return;
  int win_x_return;
  int win_y_return;
  unsigned int mask_return;
  if (XQueryPointer (display, window, &root_return, &child_return, &root_x_return, &root_y_return, &win_x_return, &win_y_return, &mask_return) == True) {
    return PyInt_FromLong (mask_return);
  } else {
    return PyInt_FromLong (0);
  }
#endif /* USE_GLX */
#ifdef USE_SDL
  return PyInt_FromLong (SDL_GetModState ());
#endif /* USE_SDL */
}

static PyObject* PyP3_ProcessEvent (PyObject* module) {
  PyObject* tuple;
  PyObject* list;

#ifdef USE_GLX
  XEvent event;
  static int last_pointer_x;
  static int last_pointer_y;
  list = PyList_New (0);
  while (XCheckWindowEvent (display, window, ResizeRedirectMask | ExposureMask | KeyPressMask | KeyReleaseMask | ButtonPressMask | ButtonReleaseMask | PointerMotionMask, &event) == True) {
    switch (event.type) {
    case KeyPress:
    case KeyRelease:
      tuple = PyTuple_New (3);
      PyTuple_SET_ITEM (tuple, 0, PyInt_FromLong (event.type));
      PyTuple_SET_ITEM (tuple, 1, PyInt_FromLong (event.xkey.keycode));
      PyTuple_SET_ITEM (tuple, 2, PyInt_FromLong (event.xkey.state));
      PyList_Append (list, tuple);
      Py_DECREF (tuple);
      break;
    case ButtonPress:
    case ButtonRelease:
      tuple = PyTuple_New (4);
      PyTuple_SET_ITEM (tuple, 0, PyInt_FromLong (event.type));
      PyTuple_SET_ITEM (tuple, 1, PyInt_FromLong (event.xbutton.button));
      PyTuple_SET_ITEM (tuple, 2, PyInt_FromLong (event.xbutton.x));
      PyTuple_SET_ITEM (tuple, 3, PyInt_FromLong (event.xbutton.y));
      PyList_Append (list, tuple);
      Py_DECREF (tuple);
      break;
    case MotionNotify:
      tuple = PyTuple_New (6);
      PyTuple_SET_ITEM (tuple, 0, PyInt_FromLong (MotionNotify));
      PyTuple_SET_ITEM (tuple, 1, PyInt_FromLong (event.xmotion.x));
      PyTuple_SET_ITEM (tuple, 2, PyInt_FromLong (event.xmotion.y));
      PyTuple_SET_ITEM (tuple, 3, PyInt_FromLong (last_pointer_x - event.xmotion.x));
      PyTuple_SET_ITEM (tuple, 4, PyInt_FromLong (last_pointer_y - event.xmotion.y));
      PyTuple_SET_ITEM (tuple, 5, PyInt_FromLong (event.xmotion.state));
      PyList_Append (list, tuple);
      Py_DECREF (tuple);
      last_pointer_x = event.xmotion.x;
      last_pointer_y = event.xmotion.y;
      break;
    case Expose:
    case GraphicsExpose:
      tuple = PyTuple_New (1);
      PyTuple_SET_ITEM (tuple, 0, PyInt_FromLong (GraphicsExpose));
      PyList_Append (list, tuple);
      Py_DECREF (tuple);
      break;
    case ResizeRequest:
      if (engine_option & P3_FULLSCREEN) {
        P3_set_video (event.xresizerequest.width, event.xresizerequest.height, P3_TRUE, P3_TRUE);
      } else {
        P3_set_video (event.xresizerequest.width, event.xresizerequest.height, P3_FALSE, P3_TRUE);
      }
      tuple = PyTuple_New (3);
      PyTuple_SET_ITEM (tuple, 0, PyInt_FromLong (ResizeRequest));
      PyTuple_SET_ITEM (tuple, 1, PyInt_FromLong (event.xresizerequest.width));
      PyTuple_SET_ITEM (tuple, 2, PyInt_FromLong (event.xresizerequest.height));
      PyList_Append (list, tuple);
      Py_DECREF (tuple);
      break;
    }
  }
#endif /* USE_GLX */

#ifdef USE_SDL
  SDL_Event event;
  list = PyList_New (0);
  while (SDL_PollEvent (&event)) {
    switch (event.type) {
    case SDL_KEYDOWN:
    case SDL_KEYUP:
      tuple = PyTuple_New (3);
      PyTuple_SET_ITEM (tuple, 0, PyInt_FromLong (event.type));
      PyTuple_SET_ITEM (tuple, 1, PyInt_FromLong (event.key.keysym.sym));
      PyTuple_SET_ITEM (tuple, 2, PyInt_FromLong (event.key.keysym.mod));
      PyList_Append (list, tuple);
      Py_DECREF (tuple);
      break;
    case SDL_MOUSEMOTION:
      tuple = PyTuple_New (6);
      PyTuple_SET_ITEM (tuple, 0, PyInt_FromLong (SDL_MOUSEMOTION));
      PyTuple_SET_ITEM (tuple, 1, PyInt_FromLong (event.motion.x));
      PyTuple_SET_ITEM (tuple, 2, PyInt_FromLong (event.motion.y));
      PyTuple_SET_ITEM (tuple, 3, PyInt_FromLong (event.motion.xrel));
      PyTuple_SET_ITEM (tuple, 4, PyInt_FromLong (event.motion.yrel));
      PyTuple_SET_ITEM (tuple, 5, PyInt_FromLong (event.motion.state));
      PyList_Append (list, tuple);
      Py_DECREF (tuple);
      break;
    case SDL_MOUSEBUTTONDOWN:
    case SDL_MOUSEBUTTONUP:
      tuple = PyTuple_New (4);
      PyTuple_SET_ITEM (tuple, 0, PyInt_FromLong (event.type));
      PyTuple_SET_ITEM (tuple, 1, PyInt_FromLong (event.button.button));
      PyTuple_SET_ITEM (tuple, 2, PyInt_FromLong (event.button.x));
      PyTuple_SET_ITEM (tuple, 3, PyInt_FromLong (event.button.y));
      PyList_Append (list, tuple);
      Py_DECREF (tuple);
      break;
    case SDL_QUIT:
    case SDL_VIDEOEXPOSE:
      tuple = PyTuple_New (1);
      PyTuple_SET_ITEM (tuple, 0, PyInt_FromLong (event.type));
      PyList_Append (list, tuple);
      Py_DECREF (tuple);
      break;
    case SDL_VIDEORESIZE:
      if (engine_option & P3_FULLSCREEN)
        P3_set_video (event.resize.w, event.resize.h, P3_TRUE, P3_TRUE);
      else
        P3_set_video (event.resize.w, event.resize.h, P3_FALSE, P3_TRUE);
      tuple = PyTuple_New (3);
      PyTuple_SET_ITEM (tuple, 0, PyInt_FromLong (SDL_VIDEORESIZE));
      PyTuple_SET_ITEM (tuple, 1, PyInt_FromLong (event.resize.w));
      PyTuple_SET_ITEM (tuple, 2, PyInt_FromLong (event.resize.h));
      PyList_Append (list, tuple);
      Py_DECREF (tuple);
      break;
    case SDL_JOYAXISMOTION:
      tuple = PyTuple_New (3);
      PyTuple_SET_ITEM (tuple, 0, PyInt_FromLong (event.type));
      PyTuple_SET_ITEM (tuple, 1, PyInt_FromLong (event.jaxis.axis));
      PyTuple_SET_ITEM (tuple, 2, PyInt_FromLong (event.jaxis.value));
      PyList_Append (list, tuple);
      Py_DECREF (tuple);
      break;
    case SDL_JOYBUTTONDOWN:
      tuple = PyTuple_New (2);
      PyTuple_SET_ITEM (tuple, 0, PyInt_FromLong (event.type));
      PyTuple_SET_ITEM (tuple, 1, PyInt_FromLong (event.jbutton.button));
      PyList_Append (list, tuple);
      Py_DECREF (tuple);
      break;
    case SDL_JOYBUTTONUP:
      tuple = PyTuple_New (2);
      PyTuple_SET_ITEM (tuple, 0, PyInt_FromLong (event.type));
      PyTuple_SET_ITEM (tuple, 1, PyInt_FromLong (event.jbutton.button));
      PyList_Append (list, tuple);
      Py_DECREF (tuple);
      break;
    case SDL_JOYBALLMOTION:
printf ("joy ball %i motion x %i y %i\n", event.jball.ball, event.jball.xrel, event.jball.yrel);
      break;
    case SDL_JOYHATMOTION:
printf ("joy hat %i motion %i\n", event.jhat.hat, event.jhat.value);
      break;
    }
  }
#endif /* USE_SDL */

  return list;
}

static PyObject* PyP3_AdvanceTime (PyObject* module, PyObject* arg) {
  delta_time += (float) PyFloat_AS_DOUBLE (arg);
  Py_INCREF (Py_None);
  return Py_None;
}

