/*
 * P3 python wrapper
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*****************************************
 * Copyright (C) 2002 Bertrand 'blam' LAMY
 *****************************************/

/*---------+
 | Methods |
 +---------*/

P3_class P3_class_coordsys = {
  P3_ID_INSTANCE,
  (batch_func)     0,
  (render_func)    0,
  (shadow_func)    0,
  (raypick_func)   0,
  (raypick_b_func) 0,
};

static void PyP3Coordsys_Dealloc (P3_coordsys* a) {
  PyObject_GC_UnTrack ((PyObject*) a);
  Py_XDECREF (a->parent);
  a->ob_type->tp_free ((PyObject*) a);
}

static int PyP3Coordsys_Init (PyObject* self, PyObject* args, PyObject* kwds) {
  P3_coordsys_initialize ((P3_coordsys*) self);
  ((P3_any_object*) self)->class = &P3_class_coordsys;
	return 0;
}

static int PyP3Child_Traverse (P3_child* a, visitproc visit, void* arg) {
	int err;
  if (a->parent != NULL) {
    err = visit ((PyObject*) a->parent, arg);
    if (err) { return err; }
  }
	return 0;
}

static int PyP3Child_Clear (P3_child* a) {
  Py_XDECREF (a->parent);
  a->parent = NULL;
  return 0;
}

static PyObject* PyP3Coordsys_SetAnimState (P3_coordsys* a, PyObject* args) {
  /* args : anim, prev_time, new_time */
  P3_coordsys_set_state (a, (P3_anim_coordsys*) PySequence_Fast_GET_ITEM (args, 0), (float) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 1)), (float) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 2)));
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_Add (P3_coordsys* a, P3_vector* arg) {
  P3_point* new;
  new = (P3_point*) PyP3Point_Type.tp_alloc (&PyP3Point_Type, 0);
  new->parent = a->parent;
  if (new->parent != NULL) Py_INCREF ((PyObject*) new->parent);
  if (arg->parent == NULL || a->parent == NULL || a->parent == arg->parent) {
    new->coord[0] = a->m[12] + arg->coord[0];
    new->coord[1] = a->m[13] + arg->coord[1];
    new->coord[2] = a->m[14] + arg->coord[2];
  } else {
    P3_vector_by_matrix_copy (new->coord, arg->coord, P3_coordsys_get_root_matrix (arg->parent));
    P3_vector_by_matrix (new->coord, P3_coordsys_get_inverted_root_matrix (a->parent));
    new->coord[0] += a->m[12];
    new->coord[1] += a->m[13];
    new->coord[2] += a->m[14];
  }
  return (PyObject*) new;
}

static PyObject* PyP3Coordsys_Sub (P3_coordsys* a, P3_vector* arg) {
  P3_point* new;
  new = (P3_point*) PyP3Point_Type.tp_alloc (&PyP3Point_Type, 0);
  new->parent = a->parent;
  if (new->parent != NULL) Py_INCREF ((PyObject*) new->parent);
  if (arg->parent == NULL || a->parent == NULL || a->parent == arg->parent) {
    new->coord[0] = a->m[12] - arg->coord[0];
    new->coord[1] = a->m[13] - arg->coord[1];
    new->coord[2] = a->m[14] - arg->coord[2];
  } else {
    P3_vector_by_matrix_copy (new->coord, arg->coord, P3_coordsys_get_root_matrix (arg->parent));
    P3_vector_by_matrix (new->coord, P3_coordsys_get_inverted_root_matrix (a->parent));
    new->coord[0] = a->m[12] - new->coord[0];
    new->coord[1] = a->m[13] - new->coord[1];
    new->coord[2] = a->m[14] - new->coord[2];
  }
  return (PyObject*) new;
}

static PyObject* PyP3Coordsys_Mod (P3_coordsys* a, PyObject* arg) {
  if (arg == Py_None) arg = NULL;
  if ((PyObject*) a->parent == arg) {
    Py_INCREF ((PyObject*) a);
    return (PyObject*) a;
  } else {
    P3_point* new = (P3_point*) PyP3Point_Type.tp_alloc (&PyP3Point_Type, 0);
    new->parent = (P3_coordsys*) arg;
    if (arg != NULL) Py_INCREF (arg);
    if (a->parent == NULL || arg == NULL) {
      memcpy (new->coord, a->m + 12, 3 * sizeof (GLfloat));
    } else {
      P3_point_by_matrix_copy (new->coord, a->m + 12, P3_coordsys_get_root_matrix (a->parent));
      P3_point_by_matrix (new->coord, P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) arg));
    }
    return (PyObject*) new;
  }
}

static PyObject* PyP3Coordsys_Position (P3_coordsys* a) {
  P3_point* new = (P3_point*) PyP3Point_Type.tp_alloc (&PyP3Point_Type, 0);
  memcpy (new->coord, a->m + 12, 3 * sizeof (GLfloat));
  new->parent = a->parent;
  if (new->parent != NULL) Py_INCREF ((PyObject*) new->parent);
  return (PyObject*) new;
}

static PyObject* PyP3Coordsys_Move (P3_coordsys* a, PyObject* arg) {
  PyP3_GetPositionInto (arg, a->parent, a->m + 12);
/*
  if (PyObject_IsInstance (arg, (PyObject*) &PyP3Point_Type) == 1) {
    P3_point* p = (P3_point*) arg;
    if (a->parent == NULL || p->parent == NULL) {
      memcpy (a->m + 12, p->coord, 3 * sizeof (GLfloat));
    } else {
      P3_point_by_matrix_copy (a->m + 12, p->coord, P3_coordsys_get_root_matrix (p->parent));
      P3_point_by_matrix (a->m + 12, P3_coordsys_get_inverted_root_matrix (a->parent));
    }
  } else {
    // assume it's a coordsys
    P3_coordsys* c = (P3_coordsys*) arg;
    if (a->parent == NULL || c->parent == NULL) {
      memcpy (a->m + 12, c->m + 12, 3 * sizeof (GLfloat));
    } else {
      P3_point_by_matrix_copy (a->m + 12, c->m + 12, P3_coordsys_get_root_matrix (c->parent));
      P3_point_by_matrix (a->m + 12, P3_coordsys_get_inverted_root_matrix (a->parent));
    }
  }
*/
  P3_object_invalid ((P3_any_object*) a);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_AddVector (P3_coordsys* a, P3_vector* arg) {
  if (arg->parent == NULL || a->parent == NULL || a->parent == arg->parent) {
    a->m[12] += arg->coord[0];
    a->m[13] += arg->coord[1];
    a->m[14] += arg->coord[2];
  } else {
    GLfloat tmp[3];
    P3_vector_by_matrix_copy (tmp, arg->coord, P3_coordsys_get_root_matrix (arg->parent));
    P3_vector_by_matrix (tmp, P3_coordsys_get_inverted_root_matrix (a->parent));
    a->m[12] += tmp[0];
    a->m[13] += tmp[1];
    a->m[14] += tmp[2];
  }
  P3_object_invalid ((P3_any_object*) a);
  Py_INCREF ((PyObject*) a);
  return (PyObject*) a;
}

static PyObject* PyP3Coordsys_AddMulVector (P3_coordsys* a, PyObject* args) {
  P3_vector* v = (P3_vector*) PySequence_Fast_GET_ITEM (args, 1);
  GLfloat k = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 0));
  if (v->parent == NULL || a->parent == NULL || a->parent == v->parent) {
    a->m[12] += k * v->coord[0];
    a->m[13] += k * v->coord[1];
    a->m[14] += k * v->coord[2];
  } else {
    GLfloat tmp[3];
    P3_vector_by_matrix_copy (tmp, v->coord, P3_coordsys_get_root_matrix (v->parent));
    P3_vector_by_matrix (tmp, P3_coordsys_get_inverted_root_matrix (a->parent));
    a->m[12] += k * tmp[0];
    a->m[13] += k * tmp[1];
    a->m[14] += k * tmp[2];
  }
  P3_object_invalid ((P3_any_object*) a);
  Py_INCREF ((PyObject*) a);
  return (PyObject*) a;
}

static PyObject* PyP3Coordsys_DistanceTo (P3_coordsys* a, PyObject* arg) {
  GLfloat t[3];
  PyP3_GetPositionInto (arg, a->parent, t);
  t[0] -= a->m[12];
  t[1] -= a->m[13];
  t[2] -= a->m[14];
/*
  if (PyObject_IsInstance (arg, (PyObject*) &PyP3Point_Type) == 1) {
    P3_point* p = (P3_point*) arg;
    if (a->parent == NULL || p->parent == NULL) {
      t[0] = a->m[12] - p->coord[0];
      t[1] = a->m[13] - p->coord[1];
      t[2] = a->m[14] - p->coord[2];
    } else {
      P3_point_by_matrix_copy (t, p->coord, P3_coordsys_get_root_matrix (p->parent));
      P3_point_by_matrix (t, P3_coordsys_get_inverted_root_matrix (a->parent));
      t[0] -= a->m[12];
      t[1] -= a->m[13];
      t[2] -= a->m[14];
    }
  } else {
    // assume it's a coordsys
    P3_coordsys* c = (P3_coordsys*) arg;
    if (a->parent == NULL || c->parent == NULL) {
      t[0] = a->m[12] - c->m[12];
      t[1] = a->m[13] - c->m[13];
      t[2] = a->m[14] - c->m[14];
    } else {
      P3_point_by_matrix_copy (t, c->m + 12, P3_coordsys_get_root_matrix (c->parent));
      P3_point_by_matrix (t, P3_coordsys_get_inverted_root_matrix (a->parent));
      t[0] -= a->m[12];
      t[1] -= a->m[13];
      t[2] -= a->m[14];
    }
  }
*/
  return PyFloat_FromDouble (sqrt (t[0] * t[0] + t[1] * t[1] + t[2] * t[2]));
}

static PyObject* PyP3Coordsys_VectorTo (P3_coordsys* a, PyObject* arg) {
  P3_vector* new = (P3_vector*) PyP3Vector_Type.tp_alloc (&PyP3Vector_Type, 0);
  new->parent = a->parent;
  if (new->parent != NULL) Py_INCREF (new->parent);
  PyP3_GetPositionInto (arg, a->parent, new->coord);
  new->coord[0] -= a->m[12];
  new->coord[1] -= a->m[13];
  new->coord[2] -= a->m[14];
/*
  if (PyObject_IsInstance (arg, (PyObject*) &PyP3Point_Type) == 1) {
    P3_point* p = (P3_point*) arg;
    if (a->parent == NULL || p->parent == NULL) {
      new->coord[0] = p->coord[0] - a->m[12];
      new->coord[1] = p->coord[1] - a->m[13];
      new->coord[2] = p->coord[2] - a->m[14];
    } else {
      P3_point_by_matrix_copy (new->coord, p->coord, P3_coordsys_get_root_matrix (p->parent));
      P3_point_by_matrix (new->coord, P3_coordsys_get_inverted_root_matrix (a->parent));
      new->coord[0] -= a->m[12];
      new->coord[1] -= a->m[13];
      new->coord[2] -= a->m[14];
    }
  } else {
    // assume it's a coordsys
    P3_coordsys* c = (P3_coordsys*) arg;
    if (a->parent == NULL || c->parent == NULL) {
      new->coord[0] = c->m[12] - a->m[12];
      new->coord[1] = c->m[13] - a->m[13];
      new->coord[2] = c->m[14] - a->m[14];
    } else {
      P3_point_by_matrix_copy (new->coord, c->m + 12, P3_coordsys_get_root_matrix (c->parent));
      P3_point_by_matrix (new->coord, P3_coordsys_get_inverted_root_matrix (a->parent));
      new->coord[0] -= a->m[12];
      new->coord[1] -= a->m[13];
      new->coord[2] -= a->m[14];
    }
  }
*/
  return (PyObject*) new;
}

static PyObject* PyP3Coordsys_TransformPoint (P3_any_object* o, PyObject* args) {
  P3_any_object* obj;
  PyObject* ret;
  GLfloat p[3];
  p[0] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 0));
  p[1] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 1));
  p[2] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 2));
  obj = (P3_any_object*) PySequence_Fast_GET_ITEM (args, 3);
  if (obj != NULL && (PyObject*) obj != Py_None) {
    P3_point_by_matrix (p, P3_coordsys_get_root_matrix ((P3_coordsys*) obj));
  }
  P3_point_by_matrix (p, P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) o));
  ret = PyTuple_New (3);
  PyTuple_SET_ITEM (ret, 0, PyFloat_FromDouble ((double) p[0]));
  PyTuple_SET_ITEM (ret, 1, PyFloat_FromDouble ((double) p[1]));
  PyTuple_SET_ITEM (ret, 2, PyFloat_FromDouble ((double) p[2]));
  return ret;
}

static PyObject* PyP3Coordsys_TransformVector (P3_any_object* o, PyObject* args) {
  P3_any_object* obj;
  PyObject* ret;
  GLfloat p[3];
  p[0] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 0));
  p[1] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 1));
  p[2] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 2));
  obj = (P3_any_object*) PySequence_Fast_GET_ITEM (args, 3);
  if ((PyObject*) obj != Py_None && obj != NULL) {
    P3_vector_by_matrix (p, P3_coordsys_get_root_matrix ((P3_coordsys*) obj));
  }
  P3_vector_by_matrix (p, P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) o));
  ret = PyTuple_New (3);
  PyTuple_SET_ITEM (ret, 0, PyFloat_FromDouble ((double) p[0]));
  PyTuple_SET_ITEM (ret, 1, PyFloat_FromDouble ((double) p[1]));
  PyTuple_SET_ITEM (ret, 2, PyFloat_FromDouble ((double) p[2]));
  return ret;
}

static PyObject* PyP3Coordsys_Translate (P3_coordsys* a, PyObject* arg) {
  a->m[12] += (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 0));
  a->m[13] += (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 1));
  a->m[14] += (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 2));
  P3_object_invalid ((P3_any_object*) a);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_Shift (P3_coordsys* a, PyObject* arg) {
  GLfloat fx = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 0));
  GLfloat fy = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 1));
  GLfloat fz = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 2));
  GLfloat* m = a->m;
  m[12] += fx * m[0] + fy * m[4] + fz * m[ 8];
  m[13] += fx * m[1] + fy * m[5] + fz * m[ 9];
  m[14] += fx * m[2] + fy * m[6] + fz * m[10];
  P3_object_invalid ((P3_any_object*) a);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_SetXYZ (P3_coordsys* a, PyObject* arg) {
  a->m[12] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 0));
  a->m[13] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 1));
  a->m[14] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 2));
  P3_object_invalid ((P3_any_object*) a);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_Scale (P3_coordsys* a, PyObject* arg) {
  P3_matrix_scale (a->m, 
                   (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 0)),
                   (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 1)),
                   (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 2)));
  P3_object_invalid ((P3_any_object*) a);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_SetIdentity (P3_coordsys* a) {
  P3_matrix_set_identity (a->m);
  P3_object_invalid ((P3_any_object*) a);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_LookAtZ (P3_coordsys* a, PyObject* arg) {
  GLfloat f[3];
  if (PyObject_IsInstance (arg, (PyObject*) &PyP3Vector_Type) == 1) {
    P3_vector* v = (P3_vector*) arg;
    if (v->parent == NULL || a->parent == NULL || v->parent == a->parent) {
      P3_matrix_look_to_Z (a->m, v->coord);
    } else {
      P3_vector_by_matrix_copy (f, v->coord, P3_coordsys_get_root_matrix (v->parent));
      P3_vector_by_matrix (f, P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) a->parent));
      P3_matrix_look_to_Z (a->m, f);
    }
  } else {
    PyP3_GetPositionInto (arg, a->parent, f);
    f[0] -= a->m[12];
    f[1] -= a->m[13];
    f[2] -= a->m[14];
    P3_matrix_look_to_Z (a->m, f);
  }
/*
  } else if (PyObject_IsInstance (arg, (PyObject*) &PyP3Point_Type) == 1) {
    P3_point* p = (P3_point*) arg;
    if (p->parent == NULL || a->parent == NULL || p->parent == a->parent) {
      P3_matrix_look_at_Z (a->m, p->coord);
    } else {
      P3_point_by_matrix_copy (f, p->coord, P3_coordsys_get_root_matrix (p->parent));
      P3_point_by_matrix (f, P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) a->parent));
      P3_matrix_look_at_Z (a->m, f);
    }
  } else {
    // assume it's a coordsys
    P3_coordsys* c = (P3_coordsys*) arg;
    if (c->parent == NULL || a->parent == NULL || c->parent == a->parent) {
      P3_matrix_look_at_Z (a->m, c->m + 12);
    } else {
      P3_point_by_matrix_copy (f, c->m + 12, P3_coordsys_get_root_matrix (c->parent));
      P3_point_by_matrix (f, P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) a->parent));
      P3_matrix_look_at_Z (a->m, f);
    }
  }
*/
  P3_object_invalid ((P3_any_object*) a);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_LookAtY (P3_coordsys* a, PyObject* arg) {
  GLfloat f[3];
  if (PyObject_IsInstance (arg, (PyObject*) &PyP3Vector_Type) == 1) {
    P3_vector* v = (P3_vector*) arg;
    if (v->parent == NULL || a->parent == NULL || v->parent == a->parent) {
      P3_matrix_look_to_Y (a->m, v->coord);
    } else {
      P3_vector_by_matrix_copy (f, v->coord, P3_coordsys_get_root_matrix (v->parent));
      P3_vector_by_matrix (f, P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) a->parent));
      P3_matrix_look_to_Y (a->m, f);
    }
  } else {
    PyP3_GetPositionInto (arg, a->parent, f);
    f[0] -= a->m[12];
    f[1] -= a->m[13];
    f[2] -= a->m[14];
    P3_matrix_look_to_Y (a->m, f);
  }
  P3_object_invalid ((P3_any_object*) a);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_LookAtX (P3_coordsys* a, PyObject* arg) {
  GLfloat f[3];
  if (PyObject_IsInstance (arg, (PyObject*) &PyP3Vector_Type) == 1) {
    P3_vector* v = (P3_vector*) arg;
    if (v->parent == NULL || a->parent == NULL || v->parent == a->parent) {
      P3_matrix_look_to_X (a->m, v->coord);
    } else {
      P3_vector_by_matrix_copy (f, v->coord, P3_coordsys_get_root_matrix (v->parent));
      P3_vector_by_matrix (f, P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) a->parent));
      P3_matrix_look_to_X (a->m, f);
    }
  } else {
    PyP3_GetPositionInto (arg, a->parent, f);
    f[0] -= a->m[12];
    f[1] -= a->m[13];
    f[2] -= a->m[14];
    P3_matrix_look_to_X (a->m, f);
  }
  P3_object_invalid ((P3_any_object*) a);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_TurnLateral (P3_coordsys* a, PyObject* arg) {
  P3_matrix_turn_lateral (a->m, (GLfloat) P3_to_radians(PyFloat_AS_DOUBLE (arg)));
  P3_object_invalid ((P3_any_object*) a);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_RotateLateral (P3_coordsys* a, PyObject* arg) {
  P3_matrix_rotate_lateral (a->m, (GLfloat) P3_to_radians(PyFloat_AS_DOUBLE (arg)));
  P3_object_invalid ((P3_any_object*) a);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_TurnVertical (P3_coordsys* a, PyObject* arg) {
  P3_matrix_turn_vertical (a->m, (GLfloat) P3_to_radians(PyFloat_AS_DOUBLE (arg)));
  P3_object_invalid ((P3_any_object*) a);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_RotateVertical (P3_coordsys* a, PyObject* arg) {
  P3_matrix_rotate_vertical (a->m, (GLfloat) P3_to_radians(PyFloat_AS_DOUBLE (arg)));
  P3_object_invalid ((P3_any_object*) a);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_TurnIncline (P3_coordsys* a, PyObject* arg) {
  P3_matrix_turn_incline (a->m, (GLfloat) P3_to_radians(PyFloat_AS_DOUBLE (arg)));
  P3_object_invalid ((P3_any_object*) a);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_RotateIncline (P3_coordsys* a, PyObject* arg) {
  P3_matrix_rotate_incline (a->m, (GLfloat) P3_to_radians(PyFloat_AS_DOUBLE (arg)));
  P3_object_invalid ((P3_any_object*) a);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_RotateAxe (P3_coordsys* a, PyObject* args) {
  GLfloat x; GLfloat y; GLfloat z; 
  GLfloat* m = a->m;
  x = m[12]; y = m[13]; z = m[14];
  m[12] = 0.0; m[13] = 0.0; m[14] = 0.0;
  if (PySequence_Size (args) == 2) {
    PyObject* o = PySequence_Fast_GET_ITEM (args, 1);
    GLfloat tmp[3];
    if (PyObject_IsInstance (o, (PyObject*) &PyP3Vector_Type) == 1) {
      P3_vector* v = (P3_vector*) o;
      if (v->parent == NULL || a->parent == NULL) {
        P3_matrix_rotate_axe (m, (GLfloat) P3_to_radians (PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 0))), v->coord[0], v->coord[1], v->coord[2]);
      } else {
        P3_vector_by_matrix_copy (tmp, v->coord, P3_coordsys_get_root_matrix (v->parent));
        P3_vector_by_matrix (tmp, P3_coordsys_get_inverted_root_matrix (a->parent));
        P3_matrix_rotate_axe (m, (GLfloat) P3_to_radians (PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 0))), tmp[0], tmp[1], tmp[2]);
      }
    } else {
      PyP3_GetPositionInto (o, a->parent, tmp);
      P3_matrix_rotate_axe (m, (GLfloat) P3_to_radians (PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 0))), tmp[0], tmp[1], tmp[2]);
    }
  } else {
    P3_matrix_rotate_axe (m,
                          (GLfloat) P3_to_radians (PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 0))),
                          (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 1)),
                          (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 2)),
                          (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 3)));
  }
  m[12] = x; m[13] = y; m[14] = z; 
  P3_object_invalid ((P3_any_object*) a);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_Rotate (P3_coordsys* a, PyObject* args) {
  GLfloat p1[3];
  GLfloat p2[3];
  GLfloat x; GLfloat y; GLfloat z; 
  GLfloat* m = a->m;
  x = m[12]; y = m[13]; z = m[14];
  m[12] = 0.0; m[13] = 0.0; m[14] = 0.0; 
  if (PySequence_Size (args) == 3) {
    PyObject* o = PySequence_Fast_GET_ITEM (args, 2);
    PyP3_GetPositionInto (PySequence_Fast_GET_ITEM (args, 1), a->parent, p1);
    if (PyObject_IsInstance (o, (PyObject*) &PyP3Vector_Type)) {
      P3_vector* v = (P3_vector*) o;
      if (v->parent == NULL || a->parent == NULL) {
        memcpy (p2, v->coord, 3 * sizeof (GLfloat));
      } else {
        P3_vector_by_matrix_copy (p2, v->coord, P3_coordsys_get_root_matrix (v->parent));
        P3_vector_by_matrix (p2, P3_coordsys_get_inverted_root_matrix (a->parent));
      }
    } else {
      PyP3_GetPositionInto (o, a->parent, p2);
      p2[0] -= p1[0];
      p2[1] -= p1[1];
      p2[2] -= p1[2];
    }
  } else {
    p1[0] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 1));
    p1[1] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 2));
    p1[2] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 3));
    p2[0] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 4));
    p2[1] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 5));
    p2[2] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 6));
    p2[0] -= p1[0];
    p2[1] -= p1[1];
    p2[2] -= p1[2];
  }
  P3_matrix_rotate (m, (GLfloat) P3_to_radians(PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 0))), p1, p2);
  m[12] = x; m[13] = y; m[14] = z;
  P3_object_invalid ((P3_any_object*) a);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Coordsys_GetRoot (P3_coordsys* a) {
  PyObject* r;
  r = (PyObject*) P3_coordsys_get_root (a);
  if (r == NULL) {
    Py_INCREF (Py_None);
    return Py_None;
  } else {
    Py_INCREF (r);
    return r;
  }
}

static PyObject* PyP3Coordsys_Inside (P3_coordsys* a, PyObject* parent) {
  return PyInt_FromLong (P3_coordsys_is_inside (a, parent));
}

static PyObject* PyP3_EmptyFunc (PyObject* a, PyObject* args) {
  Py_INCREF (Py_None);
  return Py_None;
}
  
static PyObject* PyP3Coordsys_GetState (P3_coordsys* a) {
  P3_chunk* chunk = P3_chunk_new ();
  PyObject* o;
  P3_chunk_add (chunk, a->m, 19 * sizeof (GLfloat));
  P3_chunk_add_int (chunk, a->option);
  o = PyString_FromStringAndSize ((char*) chunk->content, chunk->nb);
  P3_chunk_dealloc (chunk);
  return o;
}

static PyObject* PyP3Coordsys_SetState (P3_coordsys* a, PyObject* arg) {
  P3_chunk* chunk = P3_chunk_new ();
  a->class = &P3_class_coordsys;
  a->validity = P3_COORDSYS_INVALID;
  a->parent = NULL;
  chunk->content = PyString_AS_STRING (arg);
  P3_chunk_get (chunk, a->m, 19 * sizeof (GLfloat));
  a->option = P3_chunk_get_int (chunk);
  free (chunk);
  Py_INCREF (Py_None);
  return Py_None;
}

