/*
 * P3 python wrapper
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*****************************************
 * p3_python.h : wrapper for python
 * Copyright (C) 2002 Bertrand 'blam' LAMY
 *****************************************/


extern PyObject* P3Module_Dict;
extern PyObject* P3Module;


#define P3_children_new(nb)            PyList_New (0)
#define P3_children_size(child)        PyList_GET_SIZE (child)
#define P3_children_dealloc(child)     
//#define P3_children_add(child, obj)    PyList_Append (child, (PyObject*) obj)
#define P3_children_add(child, obj)    PyObject_CallMethod (child, "append", "O", (PyObject*) obj)
/* I don't know why there is no cool function to do this in python C api... 
 * WARNING the 'int i' is quite hackish (works only cause remove is called at only
 * one location and is the first function...)
 */
#define P3_children_remove(child, obj) \
  int i; \
  for (i = 0; i < PyList_Size (child); i++) { \
    if (obj == (P3_any_object*) PyList_GET_ITEM(child, i)) { \
      PySequence_DelItem (child, i); \
      break; \
    } \
  }
#define P3_children_get(child, index)  ((P3_any_object*) PyList_GET_ITEM(child, index))

/* do nothing ! Python as a so cool garbage collector... */
#define P3_object_dealloc(obj) 

#define P3_get_material(name) \
  ((P3_material*) PyObject_CallMethod (P3Module, "get_material", "s", name))
#define P3_material_incref(m) \
  Py_INCREF ((PyObject*) m)
#define P3_material_decref(m) \
  Py_DECREF ((PyObject*) m)
#define P3_image_decref(m) \
  Py_DECREF ((PyObject*) m)

#define P3_get_atmosphere(name) \
  ((P3_atmosphere*) PyObject_CallMethod (P3Module, "get_atmosphere", "s", name))
#define P3_atmosphere_decref(atm) \
  Py_DECREF ((PyObject*) atm)

#define P3_object_set_parent(obj, world) \
  PyObject_SetAttrString ((PyObject*) obj, "parent", (PyObject*) world)
#define P3_object_get_parent(obj) \
  ((P3_parent*) PyObject_GetAttrString ((PyObject*) obj, "parent"))

#define P3_portal_load_beyond(portal) \
  (P3_world*) PyObject_CallMethod ((PyObject*) portal, "load_beyond", "o", portal->beyond_name)


