/*
 * P3
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**********************************************
 * raypick.c
 * Copyright (C) 2001-2003 Bertrand 'blam' LAMY
 **********************************************/

#define __USE_ISOC99
#include <math.h>

#include "p3_base.h"
#include "math3d.h"
#include "util.h"
#include "coordsys.h"
#include "mesh.h"


GLfloat* P3_raypickable_get_raypick_data (P3_raypickable* r, P3_raypick_data* data) {
  if (r->raypick_data == -1) {
    GLfloat* matrix;
    GLfloat* rdata;
    GLfloat f;
    r->raypick_data = P3_chunk_register (data->raypick_data, 7 * sizeof (GLfloat));
    rdata = (GLfloat*) (data->raypick_data->content + r->raypick_data);
    /* transform origin and direction into the parent coordsys */
    matrix = P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) r);
    P3_point_by_matrix_copy  (rdata,     data->root_data,     matrix);
    P3_vector_by_matrix_copy (rdata + 3, data->root_data + 3, matrix);
    if (data->root_data[6] > 0.0) {
      if (matrix[16] > matrix[17]) f = matrix[16]; else f = matrix[17];
      if (matrix[18] > f) f = matrix[18];
      /* we need to divide by f, not to multiply */
      if (f == 1.0) rdata[6] = data->root_data[6]; else rdata[6] = data->root_data[6] / f; 

// TO DO arg now

//      rdata[6] = P3_length_by_matrix (data[6], matrix);
      
//      rdata[6] = data[6];
      
    } else {
      rdata[6] = -1.0;
    }
    P3_list_add (data->raypicked, r);
    return rdata;
  } else {
    return (GLfloat*) (data->raypick_data->content + r->raypick_data);
  }
}

GLfloat* P3_raypick (P3_any_object* r, P3_raypick_data* data) {
  GLfloat* d;
  int i;
  data->raypicked = P3_get_list ();
  data->raypick_data = P3_get_chunk ();
  data->ret_csys = NULL;
  r->class->raypick (r, data, NULL);
  if (data->ret_csys == NULL)
    d = NULL;
  else
    d = P3_raypickable_get_raypick_data ((P3_raypickable*) data->ret_csys, data);
  for (i = 0; i < data->raypicked->nb; i++) {
    ((P3_raypickable*) P3_list_get (data->raypicked, i))->raypick_data = -1;
  }
  P3_drop_list  (data->raypicked);
  P3_drop_chunk (data->raypick_data);
  return d;
}

int P3_raypick_b (P3_any_object* r, P3_raypick_data* data) {
  int result;
  int i;
  data->raypicked = P3_get_list ();
  data->raypick_data = P3_get_chunk ();
  result = r->class->raypick_b (r, data, NULL);
  for (i = 0; i < data->raypicked->nb; i++) {
    ((P3_raypickable*) P3_list_get (data->raypicked, i))->raypick_data = -1;
  }
  P3_drop_list  (data->raypicked);
  P3_drop_chunk (data->raypick_data);
  return result;
}

void P3_get_raypick_context (P3_any_object* obj, void* parent, GLfloat* rsphere, GLfloat* sphere, P3_chunk* chunk) {
  GLfloat* matrix;
  GLfloat s[4];
  int i;
  if (obj == NULL || obj->option & P3_OBJECT_NON_SOLID || obj->class->raypick == 0) { return; }
  switch (obj->class->id) {
  case P3_ID_WORLD:
    /* transform sphere to my coordsys */
    matrix = P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) obj);
    P3_point_by_matrix_copy (s, rsphere, matrix);
    s[3] = P3_length_by_matrix (rsphere[3], matrix);
    P3_get_raypick_context (((P3_world*) obj)->shape, obj, rsphere, s, chunk);
    for (i = 0; i < P3_children_size (((P3_world*) obj)->children); i++) {
      P3_get_raypick_context (P3_children_get (((P3_world*) obj)->children, i), obj, rsphere, s, chunk);
    }
    break;
  case P3_ID_VOLUME:
    /* transform sphere to my coordsys */
    matrix = P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) obj);
    P3_point_by_matrix_copy (s, rsphere, matrix);
    s[3] = P3_length_by_matrix (rsphere[3], matrix);
    P3_get_raypick_context (((P3_volume*) obj)->shape, obj, rsphere, s, chunk);
    break;
  case P3_ID_PORTAL:
    if (((P3_portal*) obj)->beyond != NULL) {
      P3_get_raypick_context ((P3_any_object*) ((P3_portal*) obj)->beyond, NULL, rsphere, sphere, chunk);
    }
    break;
  case P3_ID_MESH:
    if (obj->option & P3_MESH_TREE) {
      P3_chunk_add_ptr (chunk, parent);
      P3_chunk_add_ptr (chunk, obj);
      P3_xnode_get_faces ((P3_xnode*) ((P3_mesh*) obj)->xtra1, sphere, chunk);
      P3_chunk_add_ptr (chunk, NULL);
    } else {
      if (!(obj->option & P3_MESH_HAS_SPHERE) || P3_sphere_distance_sphere (sphere, (GLfloat*) ((P3_mesh*) obj)->xtra2) < 0.0) {
        P3_chunk_add_ptr (chunk, parent);
        P3_chunk_add_ptr (chunk, obj);
      }
    }
    break;
  default:
    /* P3_ID_FACE */
    /* P3_ID_LAND */
    P3_chunk_add_ptr (chunk, parent);
    P3_chunk_add_ptr (chunk, obj);
    break;
  }
}

GLfloat* P3_raypick_context_raypick (P3_chunk* context, P3_raypick_data* data) {
  P3_raypickable* parent;
  P3_any_object* obj;
  void* ptr;
  GLfloat* raydata;
  int max;
  int i;
  data->raypicked = P3_get_list ();
  data->raypick_data = P3_get_chunk ();
  data->ret_csys = NULL;
  /* read context */
  max = context->nb;
  context->nb = 0;
  while (context->nb < max) {
    parent = (P3_raypickable*) P3_chunk_get_ptr (context);
    obj    = (P3_any_object*)  P3_chunk_get_ptr (context);
    switch (obj->class->id) {
    case P3_ID_MESH:
      if (obj->option & P3_MESH_TREE) {
        raydata = P3_raypickable_get_raypick_data (parent, data);
        ptr = P3_chunk_get_ptr (context);
        while (ptr != NULL) {
          P3_xmesh_face_raypick ((P3_xmesh*) obj, (P3_xface*) ptr, raydata, data, parent);
          ptr = P3_chunk_get_ptr (context);
        }
      } else {
        obj->class->raypick (obj, data, parent);
      }
      break;
    default:
      obj->class->raypick (obj, data, parent);
      break;
    }
  }
  if (data->ret_csys == NULL) 
    raydata = NULL;
  else
    raydata = P3_raypickable_get_raypick_data ((P3_raypickable*) data->ret_csys, data);
  for (i = 0; i < data->raypicked->nb; i++) {
    ((P3_raypickable*) P3_list_get (data->raypicked, i))->raypick_data = -1;
  }
  P3_drop_list  (data->raypicked);
  P3_drop_chunk (data->raypick_data);
  return raydata;
}

int P3_raypick_context_raypick_b (P3_chunk* context, P3_raypick_data* data) {
  P3_raypickable* parent;
  P3_any_object* obj;
  void* ptr;
  GLfloat* raydata;
  int intersect = P3_FALSE;
  int max;
  int i;
  data->raypicked = P3_get_list ();
  data->raypick_data = P3_get_chunk ();
  /* read context */
  max = context->nb;
  context->nb = 0;
  while (context->nb < max && intersect == P3_FALSE) {
    parent = (P3_raypickable*) P3_chunk_get_ptr (context);
    obj    = (P3_any_object*)  P3_chunk_get_ptr (context);
    switch (obj->class->id) {
    case P3_ID_MESH:
      if (obj->option & P3_MESH_TREE) {
        raydata = P3_raypickable_get_raypick_data (parent, data);
        ptr = P3_chunk_get_ptr (context);
        while (ptr != NULL && intersect == P3_FALSE) {
          intersect = P3_xmesh_face_raypick_b ((P3_xmesh*) obj, (P3_xface*) ptr, raydata, data);
          ptr = P3_chunk_get_ptr (context);
        }
      } else {
        intersect = obj->class->raypick_b (obj, data, parent);
      }
      break;
    default:
      intersect = obj->class->raypick_b (obj, data, parent);
      break;
    }
  }
  for (i = 0; i < data->raypicked->nb; i++) {
    ((P3_raypickable*) P3_list_get (data->raypicked, i))->raypick_data = -1;
  }
  P3_drop_list  (data->raypicked);
  P3_drop_chunk (data->raypick_data);
  return intersect;
}



