/*
 * P3
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*****************************************
 * shadow.c
 * Copyright (C) 2003 Bertrand 'blam' LAMY
 *****************************************/

//obj.get_root().children[1].visible=0

#include "p3_base.h"
#include "math3d.h"
#include "util.h"
#include "coordsys.h"
#include "light.h"
#include "shadow.h"

extern P3_renderer* renderer;
extern int shadow_display_list;

#if 0

void P3_start_shadow (P3_light* light, P3_instance* inst) {
  /* draw shadow volume 1rst step */
  glStencilFunc (GL_ALWAYS, 1, 0xFFFFFFFF);
  glFrontFace (GL_CW);
  glStencilOp (GL_KEEP, GL_KEEP, GL_INCR);
  glLoadMatrixf (inst->render_matrix);
  P3_light_cast_into (light, (P3_coordsys*) inst);
  glNewList (shadow_display_list, GL_COMPILE_AND_EXECUTE);
  glBegin (GL_QUADS);
}

void P3_end_shadow (void) {
  glEnd ();
  glEndList ();
  /* draw shadow volume 2nd step */
  glFrontFace (GL_CCW);
  glStencilFunc (GL_ALWAYS, 0, 0xFFFFFFFF);
  glStencilOp (GL_KEEP, GL_KEEP, GL_DECR);
  glCallList (shadow_display_list);
}

#endif

void P3_render_shadows (void) {
  P3_light* light;
  GLfloat* ptrf = renderer->c_camera->frustum->points;
//  P3_raypick_data rdata;
  GLfloat p[12];
//  GLfloat f;
  int i, j;
  if (renderer->root_object->class->shadow == 0) return;
  /* compute screen surface rectangle 
   * we can't just take the frustum points cause their depth are equal to
   * the front of the camera and some OpenGL implementation won't draw the quad
   */
  p[ 0] = (ptrf[0] + ptrf[12]) * 0.5;
  p[ 1] = (ptrf[1] + ptrf[13]) * 0.5;
  p[ 2] = (ptrf[2] + ptrf[14]) * 0.5;
  p[ 3] = - p[0];
  p[ 4] =   p[1];
  p[ 5] =   p[2];
  p[ 6] = - p[0];
  p[ 7] = - p[1];
  p[ 8] =   p[2];
  p[ 9] =   p[0];
  p[10] = - p[1];
  p[11] =   p[2];
  glEnableClientState (GL_VERTEX_ARRAY);
  glVertexPointer (3, GL_FLOAT, 0, p);
  glDisable (GL_LIGHTING);
  glDisable (GL_TEXTURE_2D);
  glDepthFunc (GL_LEQUAL);
  for (i = 0; i < renderer->all_lights->nb; i++) {
    light = (P3_light*) P3_list_get (renderer->all_lights, i);
    if (light->option & P3_LIGHT_NO_SHADOW) continue;
/*
    rdata.option = P3_RAYPICK_HALF_LINE;
    rdata.raypicked = P3_get_list ();
    rdata.raypick_data = P3_get_chunk ();
    if (light->option & P3_LIGHT_DIRECTIONAL) {
      rdata.root_data[0] = renderer->r_frustum->position[0];
      rdata.root_data[1] = renderer->r_frustum->position[1];
      rdata.root_data[2] = renderer->r_frustum->position[2];
      ptrf = P3_coordsys_get_root_matrix ((P3_coordsys*) light);
      rdata.root_data[6] = renderer->c_camera->back;
      rdata.root_data[3] = rdata.root_data[0] + rdata.root_data[6] * ptrf[ 8];
      rdata.root_data[4] = rdata.root_data[1] + rdata.root_data[6] * ptrf[ 9];
      rdata.root_data[5] = rdata.root_data[2] + rdata.root_data[6] * ptrf[10];
    } else {
      P3_point_by_matrix_copy (rdata.root_data, light->m + 12, P3_coordsys_get_root_matrix ((P3_coordsys*) light));
      rdata.root_data[3] = renderer->r_frustum->position[0] - rdata.root_data[0];
      rdata.root_data[4] = renderer->r_frustum->position[1] - rdata.root_data[1];
      rdata.root_data[5] = renderer->r_frustum->position[2] - rdata.root_data[2];
      rdata.root_data[6] = P3_vector_length (rdata.root_data + 3);
      f = 1.0 / rdata.root_data[6];
      rdata.root_data[3] *= f;
      rdata.root_data[4] *= f;
      rdata.root_data[5] *= f;
    }
*/
    glStencilMask (0xFFFFFFFF);
    glClearStencil (0);
    glClear (GL_STENCIL_BUFFER_BIT);
    glEnable (GL_STENCIL_TEST);
    glColorMask (GL_FALSE, GL_FALSE, GL_FALSE, GL_FALSE);
    /* draw shadow volume */
    if (renderer->root_object->class->shadow (renderer->root_object, NULL, light) == P3_TRUE) {
      /* draw stencil buffer on screen */
      glStencilMask (0);
      glColorMask (GL_TRUE, GL_TRUE, GL_TRUE, GL_TRUE);
      if (light->shadow_color == NULL) {
        glColor4f (0.0, 0.0, 0.0, 0.4);
      } else {
        glColor4fv (light->shadow_color);
      }
      glStencilFunc (GL_NOTEQUAL, 0, 0xFFFFFFFF);
      glStencilOp (GL_KEEP, GL_KEEP, GL_KEEP);
      glDisable (GL_CULL_FACE);
      glDisable (GL_DEPTH_TEST);
      glLoadIdentity ();
      glDrawArrays (GL_QUADS, 0, 4);
      glEnable (GL_DEPTH_TEST);
      glEnable (GL_CULL_FACE);
    } else {
      glStencilMask (0);
      glColorMask (GL_TRUE, GL_TRUE, GL_TRUE, GL_TRUE);
    }
/*
    for (j = 0; j < rdata.raypicked->nb; j++) {
      ((P3_raypickable*) P3_list_get (rdata.raypicked, j))->raypick_data = -1;
    }
    P3_drop_list  (rdata.raypicked);
    P3_drop_chunk (rdata.raypick_data);
*/
  }
  glEnable (GL_LIGHTING);
  glEnable (GL_TEXTURE_2D);
  glDepthFunc (GL_LESS);
  glDisable (GL_STENCIL_TEST);
  glDisableClientState (GL_VERTEX_ARRAY);
}

