# Soya 3D tutorial
# Copyright (C) 2001-2002 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Lesson 014: Character animation with Cal3D : here comes Balazar the Sorcerer !
#
# Or how to write a Cal3D viewer in less that 20 lines...

# For information, this character has been created in Blender and exported to Cal3D
# with my Blender2Cal3D script
# (http://oomadness.tuxfamily.org/en/blender2cal3d/index.html).


import os, os.path, sys
import soya, soya.soya3d as soya3d, soya.model as model, soya.cal3d as cal3d, soya.idler as idler, soya.widget as widget

soya.init()

scene = soya3d.World()

data_dir = os.path.join(os.path.dirname(os.path.abspath(sys.argv[0])), "data")

model.Image   .PATH = os.path.join(data_dir, "images")
model.Material.PATH = os.path.join(data_dir, "materials")
soya3d.World  .PATH = os.path.join(data_dir, "worlds")
model.Shape   .PATH = os.path.join(data_dir, "shapes")

# Load a Cal3D shape.
# Cal3D shapes are saved in subdirectory of model.Shape.PATH. The subdirectory contains
# skeleton, animation, mesh and material files, and a ".cfg" file with the same name
# that the subdirectory (and and ".cfg" extension).
# See Cal3D documentation for more info, and the soya.cal3d module's docstring for
# advanced info on materials loading (e.g, how to substitute Cal3D materials by Soya
# ones).
# 
# You can also use cal3d.parse_cfg_file(filename).

sorcerer_shape = cal3d.Shape.get("balazar")

# You can get the list of available mesh and animation names
# as following:

print "Available meshes    :", sorcerer_shape.meshes
print "Available animations:", sorcerer_shape.animations

# Creates a Cal3D volume, using the sorcerer_shape.
# See the docstrings of the soya.cal3d module to learn about mesh attachment
# and detachment possibilities (see Volume.__init__, Volume.attach and
# Volume.detach). It can be used e.g. for dismembering, or changing the weapon
# of a character.

sorcerer = cal3d.Volume(scene, sorcerer_shape)

# Rotates Balazar the sorcerer

sorcerer.rotate_lateral(-120.0)

# Starts playing the animation called "marche" in cycle ("marche" is the French for walk).

sorcerer.animate_blend_cycle("marche")

# To stop playing the animation:
#
#sorcerer.animate_clear_cycle("marche")
#
# For non-cyclic movment, do:
#
#sorcerer.animate_execute_action("marche")
#
# See the cal3d.Volume.animate* docstrings for more info about optional arguments

camera = soya3d.Camera(scene)
camera.set_xyz(0.0, 1.5, 3.0)

soya.set_root_widget(widget.Group())
soya.root_widget.add(camera)
soya.root_widget.add(widget.FPSLabel())

soya3d.Light(scene).set_xyz(5.0, 5.0, 2.0)

idler.Idler(scene).idle()
