# Soya 3D tutorial
# Copyright (C) 2001-2002 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Lesson 114: Face cutter : improve you shapes' quality by automatically adding more faces

import soya, soya.soya3d as soya3d, soya.model as model, soya.cube as cube, soya.facecutter as facecutter

import os, os.path, sys

soya.init()

scene = soya3d.World()

data_dir = os.path.join(os.path.dirname(os.path.abspath(sys.argv[0])), "data")

model.Image   .PATH = os.path.join(data_dir, "images")
model.Material.PATH = os.path.join(data_dir, "materials")
soya3d.World  .PATH = os.path.join(data_dir, "worlds")
model.Shape   .PATH = os.path.join(data_dir, "shapes")

# Loads 2 Tux.

orig  = soya3d.World.load("tux")
final = soya3d.World.load("tux")

orig.save()

# Improve the Tux on the right.
# You can either give the number of faces to add, or the maximum edge length (as here).
# The exact number of new faces is returned.

print facecutter.cut(final, max_length = 1.5), " new faces!"

# See it wireframed !
soya.toggle_wireframe()

v1 = soya3d.Volume(scene, orig .shapify())
v1.rotate_lateral(-90.0)
v1.x = -0.2

v2 = soya3d.Volume(scene, final.shapify())
v2.rotate_lateral(90.0)
v2.x = 0.2

light = soya3d.Light(scene)
light.set_xyz(0.0, 0.3, 1.0)
light.constant = 0.0000001 # Less attenuation

camera = soya3d.Camera(scene)
camera.y = 0.3
camera.z = 0.8

soya.set_root_widget(camera)

import time

while 1:
  soya.render()
  
  time.sleep(0.5)
  
