# Soya 3D tutorial
# Copyright (C) 2003 Bertrand 'blam!' LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


# -------------------
# Lesson 118: Sprites
# -------------------

# There are 2 kinds of sprites:
#   - sphere sprite (object with no dimension)
#   - cylinder sprite (object with 1 dimension)

import os, os.path, sys, time

import soya.model
import soya.soya3d


soya.init()

soya.model.Image.PATH = os.path.join(os.path.dirname(os.path.abspath(sys.argv[0])), "data")

# Create a world
world = soya.soya3d.World()

# Add a light
light = soya.soya3d.Light(world)
light.ambient = (0.2, 0.2, 0.2, 1.0)
light.set_xyz(0.0, 15.0, 0.0)

# Create a material
m = soya.model.Material()
m.tex_filename = os.path.join(soya.DATADIR, "fx.png")

# Sphere sprite
# -------------

s = soya.soya3d.Sprite(world)
s.material = m
s.color = (1.0, 1.0, 0.0, 1.0)
s.width  = 2.0
s.height = 0.5
s.set_xyz(-4.0, 0.0, -10.0)


# Cylinder sprite
# ---------------

s = soya.soya3d.CylinderSprite(world)
s.material = m
s.color = (1.0, 0.0, 0.0, 1.0)
s.width  = 6.0
s.height = 1.0
#   One difference between Sphere and Cylinder sprite is that Cylinder
#   has a direction and can be rotated.
s.direction = (0.0, 1.0, 0.0)
s.rotate_vertical(40.0)
s.set_xyz(4.0, 0.0, -10.0)


# Add a camera and a loop to render
camera = soya.soya3d.Camera(world)
soya.set_root_widget(camera)


while(1):
  camera.turn_incline(-4.0)
  soya.render()
  time.sleep(0.1)

  for event in soya.process_event():
    if (event[0] == soya.KEYDOWN):
      sys.exit()
  
# Observe how the 2 sprites are altered with the rotation of the camera
# and you will understand the difference between a Sphere and a Cylinder
# sprite.

