# Soya 3D
# Copyright (C) 2001-2002 Jean-Baptiste LAMY   -- jiba@tuxfamily.org
#                         Bertrand 'blam' LAMY -- blam@tuxfamily.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import soya
import soya.soya3d
import _soya



class WaterCube(soya._CObj, _soya._WaterCube, soya.soya3d.GraphicElement):
  """WaterCube
"""
  def __init__(self, parent = None):
    _soya._WaterCube.__init__(self)
    if parent: parent.add(self)
   
  def add_wave(self, point, height = None,
               speed = 0.5, height_decay = 0.85, wavelength = 2.0, decay = 2.0, radius = 0.0):
    p = point % self
    if height == None: height = p.y
    self._add_wave(p.x, p.z, height, radius, decay, wavelength, speed, height_decay)

  def __repr__(self):
    return "<WaterCube>"
  
