/*
 * (C) Copyright 2002, Schlund+Partner AG
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/**
 * @file XMLDump.hpp
 * @version @$Id: XMLDump.hpp,v 1.7 2002/12/19 15:16:45 spabsurd Exp $
 * @author Schlund + Partner AG
 * @brief *ps*
 *
 * (C) Copyright by Schlund+Partner AG
 *
 * Synopsis: @#include <sp-gxmlcpp/XMLDump.hpp>
 *
 * Serializing XML Trees.
 *
 */

#ifndef SP_GXML_XMLDUMP_HPP
#define SP_GXML_XMLDUMP_HPP

// STDC++
#include <string>

// C libraries
#include <libxslt/xsltInternals.h>
#include <libxml/parser.h>
#include <libxml/xpath.h>
#include <libxml/tree.h>
#include <libxslt/transform.h>
#include <libxslt/xsltutils.h>
#include <libxslt/imports.h>

// Local
#include <sp-gxmlcpp/Util.hpp>
#include <sp-gxmlcpp/XMLTree.hpp>

namespace SP
{
namespace GXML
{

// toDo
class XSLTOutputBuf
{
public:
	enum Exceptions
	{
		MEM_ERR,             // Mem Error
		RESULT_INVALID,      // Result Doc invalid (0 or no children)
		STYLE_INVALID        // Style invalid (0)
	};

	XSLTOutputBuf(xmlDocPtr result, xsltStylesheetPtr style);
	~XSLTOutputBuf();
	char * getAddr() const;
	int getSize() const;

private:
	xmlCharEncodingHandlerPtr encoder_;
	xmlOutputBufferPtr buf_;
};

class XMLDump
{
public:
	enum Exceptions
	{
		MEM_ERR,             // XML could not be parsed
		NODE_NOT_FOUND_ERR   // Node could not be found from path
	};

	XMLDump(const xmlDocPtr doc, const xmlXPathContextPtr ctxt, const std::string & path="/");
	XMLDump(const XMLTree * tree, const std::string & path="/");
	XMLDump(const xmlDocPtr doc);
	// toDo
	XMLDump(const XSLTOutputBuf * buf);

	~XMLDump();

	char * getAddr() const;
	std::string get() const;
	int getSize() const;

private:
	xmlBufferPtr nodeDump_;           // This is used to dump XML from some path other than "/"
	std::pair<xmlChar *, int> docDump_;    // This is used to dump the whole XML document (path = "/").
	// toDo
	XSLTOutputBuf * xsltDump_;        // This is used when dumping was actually done outside. Currently only for XSL Transformations.

	// genDump: Master Create Dump Function. Must be used in Constructors only
	void genDump(const xmlDocPtr doc, const xmlXPathContextPtr ctxt, const std::string & path);

	static char * nullString_;
};

}}
#endif
