///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// $Id: MimeLineReader.cc,v 1.8 2003/08/30 21:42:24 bburton Exp $
//
// Copyright (C) 2000 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//

#include "MimeLineReader.h"

MimeLineReader::MimeLineReader(istream &in)
  : m_atEnd(false),
    m_in(in),
    m_count(0)
{
}

MimeLineReader::~MimeLineReader()
{
}

bool MimeLineReader::readLine()
{
  m_line.erase();

  if (m_atEnd) {
    return false;
  }

  if (!m_in.good()) {
    m_atEnd = true;
    return false;
  }

  m_line.erase();

  char ch;
  bool again = true;
  m_in.get(ch);
  while (again && m_in.good()) {
    m_count += 1;
    switch (ch) {
    case '\0':
      m_line += ' ';
      m_in.get(ch);
      break;

    case '\n':
      again = false;
      break;

    case '\r':
      if (m_in.peek() == '\n') {
        m_count += 1;
        m_in.get();
      }
      again = false;
      break;

    default:
      m_line += safe_char(ch);
      m_in.get(ch);
      break;
    }
  }

  if (!m_in.good()) {
    m_atEnd = true;
    return m_line.length() > 0;
  }

  return !m_atEnd;
}
