///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// http://www.cooldevtools.com
// $Id: HeaderPrefixList.h 75 2004-11-06 20:20:20Z brian $
//
// Copyright (C) 2000 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//    http://www.cooldevtools.com/qpl.html
//

#ifndef _HeaderPrefixList_h
#define _HeaderPrefixList_h

#include <map>
#include "util.h"

class HeaderPrefixList
{
public:
  HeaderPrefixList();
  ~HeaderPrefixList();

  /// Resets the counts kept by shouldProcessHeader()
  void resetHeaderCounts();

  /// Determines if the header should be processed and what prefix to use.
  /// Remembers the number of times the header has been seen already.
  bool shouldProcessHeader(const string &name,
                           string &prefix);

  void removePrefixedHeaders();

  void setBlankPrefixesMode();
  void setDefaultHeadersMode();
  void setNonXHeadersMode();
  void setAllHeadersMode();
  void setNoHeadersMode();

  void addSimpleHeaderPrefix(const string &name);

  void addHeaderPrefix(const string &name,
                       const string &first_prefix,
                       const string &other_prefix);

private:
  /// Not implemented.
  HeaderPrefixList(const HeaderPrefixList &);

  /// Not implemented.
  HeaderPrefixList& operator=(const HeaderPrefixList &);

private:
  struct HeaderData
  {
    string first_prefix;
    string other_prefix;
    int visit_count;
  };

  typedef map<string,HeaderData> MapType;
  typedef MapType::iterator IteratorType;

  bool m_visitAllHeaders;
  bool m_ignoreXHeaders;
  bool m_forceBlankPrefixes;
  map<string,HeaderData> m_values;
};

#endif // _HeaderPrefixList_h
