///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// http://www.cooldevtools.com
// $Id: RefCountMixin.h 68 2004-11-04 15:43:03Z brian $
//
// Copyright (C) 2000 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//    http://www.cooldevtools.com/qpl.html
//

#ifndef _RefCountMixin_h
#define _RefCountMixin_h

class RefCountMixin
{
public:
  RefCountMixin();
  RefCountMixin(const RefCountMixin &);
  RefCountMixin& operator=(const RefCountMixin &);

  /// Has to be virtual so base class destructors are called.  Must be overriden.
  virtual ~RefCountMixin();

  /// Add one to refcount
  void rcAddReference();

  /// Remove a reference and delete if refcount is zero
  void rcRemoveReference();

  /// Remove a reference but don't delete if refcount is zero (used for return values)
  void rcDropReference();

  /// Mostly for testing purposes
  int rcGetRefCount()
  {
    return m_refCount;
  }

private:
  int m_refCount;
};

#endif // _RefCountMixin_h
