///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// http://www.cooldevtools.com
// $Id: HdlArgumentConstraint.cc 193 2005-12-14 00:35:25Z brian $
//
// Copyright (C) 2005 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//    http://www.cooldevtools.com/qpl.html
//

#include "HdlError.h"
#include "HdlToken.h"
#include "HdlArgumentConstraint.h"

void HdlArgumentConstraint::acceptID(const CRef<HdlToken> &id)
{
  m_validIDs.insert(id->strValue());
}

void HdlArgumentConstraint::validateArgument(const CRef<HdlToken> &token) const
{
  if (token->isInteger() && m_intOK) {
    return;
  }

  if (token->isDouble() && m_doubleOK) {
    return;
  }

  if (token->isString() && m_stringOK) {
    return;
  }

  if (token->isIdentifier()) {
    if (m_idOK || m_validIDs.find(token->strValue()) != m_validIDs.end()) {
      return;
    }
  }

  throwInvalidArgument(token);
}

void HdlArgumentConstraint::throwInvalidArgument(const CRef<HdlToken> &token) const
{
  string msg("invalid argument, expected");
  if (m_intOK) {
    msg += " integer";
  }
  if (m_doubleOK) {
    msg += " double";
  }
  if (m_stringOK) {
    msg += " string";
  }
  if (m_idOK) {
    msg += " identifier";
  } else if (m_validIDs.size() > 0) {
    if (m_intOK || m_stringOK) {
      msg += " or one of ";
    }
    for (set<string>::const_iterator i = m_validIDs.begin(); i != m_validIDs.end(); ++i) {
      msg += " '";
      msg += *i;
      msg += "'";
    }
  }
  throw HdlError(msg, token);
}
