#ifndef _HdlRecursiveStatementConstraint_h
#define _HdlRecursiveStatementConstraint_h

#include "HdlStatementConstraint.h"

class HdlRecursiveStatementConstraint : public HdlStatementConstraint
{
public:
  HdlRecursiveStatementConstraint(const HdlStatementConstraint *other)
    : HdlStatementConstraint(other->name()),
      m_other(other)
  {
  }

  ~HdlRecursiveStatementConstraint()
  {
  }

  virtual void validateStatement(const CRef<HdlStatement> &stmt) const
  {
    return m_other->validateStatement(stmt);
  }

private:
  /// Not implemented.
  HdlRecursiveStatementConstraint(const HdlRecursiveStatementConstraint &);

  /// Not implemented.
  HdlRecursiveStatementConstraint& operator=(const HdlRecursiveStatementConstraint &);

private:
  const HdlStatementConstraint *m_other;
};

#endif // _HdlRecursiveStatementConstraint_h
