-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Dictionary)
function GetDeclaration (Item : Symbol) return Symbol is
   Declaration : Symbol;

   --------------------------------------------------------------------------------

   function GetTypeDeclaration (TypeMark : Symbol) return Symbol
   --# global in Dict;
   is
      Declaration : Symbol;
   begin

      -- for a protected or task type we want to return the Ada declaration if available
      if (TypeIsProtected (TypeMark) or else TypeIsTask (TypeMark))
        and then RawDict.GetTypeDeclaration (TypeMark) /= NullSymbol then
         Declaration := RawDict.GetTypeDeclaration (TypeMark);
         -- if not one of these types, or if there is not Ada declaration,
         -- return type announcement if available
      elsif TypeIsAnnounced (TypeMark) and then RawDict.GetTypeDeclaration (TypeMark) = NullSymbol then
         -- we have a type announcement but no Ada declaration
         Declaration := RawDict.GetTypeAnnouncement (TypeMark);
         -- or proceed to check for private/visible Ada declarations
      elsif TypeIsPrivate (TypeMark) then
         Declaration := RawDict.GetTypePrivateTypeDeclaration (TypeMark);
      else -- this case now also handles type that is announced _and_ declared
         Declaration := RawDict.GetTypeDeclaration (TypeMark);
      end if;

      return Declaration;

   end GetTypeDeclaration;

   --------------------------------------------------------------------------------

   function GetVariableDeclaration (Variable : Symbol) return Symbol
   --# global in Dict;
   is
   begin
      return RawDict.GetVariableDeclaration (Variable);
   end GetVariableDeclaration;

   --------------------------------------------------------------------------------

   function GetConstantDeclaration (TheConstant : Symbol) return Symbol
   --# global in Dict;
   is
      Declaration : Symbol;
   begin

      if ConstantIsDeferred (TheConstant) then
         Declaration := RawDict.GetConstantDeferredConstantDeclaration (TheConstant);
      else
         Declaration := RawDict.GetConstantDeclaration (TheConstant);
      end if;

      return Declaration;

   end GetConstantDeclaration;

   --------------------------------------------------------------------------------

   function GetSubprogramSpecification (Subprogram : Symbol) return Symbol
   --# global in Dict;
   is
   begin
      return RawDict.GetSubprogramSpecification (Subprogram);
   end GetSubprogramSpecification;

   --------------------------------------------------------------------------------

   function GetPackageSpecification (ThePackage : Symbol) return Symbol
   --# global in Dict;
   is
   begin
      return RawDict.GetPackageSpecification (ThePackage);
   end GetPackageSpecification;

   --------------------------------------------------------------------------------

begin

   case RawDict.GetSymbolDiscriminant (Item) is
      when TypeSymbol =>
         Declaration := GetTypeDeclaration (Item);
      when VariableSymbol =>
         Declaration := GetVariableDeclaration (Item);
      when ConstantSymbol =>
         Declaration := GetConstantDeclaration (Item);
      when PackageSymbol =>
         Declaration := GetPackageSpecification (Item);
      when others =>
         Declaration := GetSubprogramSpecification (Item);
   end case;

   return Declaration;

end GetDeclaration;
