-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
procedure CheckTaskModifierConsistency
  (TheOwnVarType  : in     Dictionary.Symbol;
   TheVarType     : in     Dictionary.Symbol;
   ModifierIsTask : in     Boolean;
   ErrorNode      : in     STree.SyntaxNode;
   Consistent     :    out Boolean) is
   ErrorNumber : Natural;
begin
   ErrorNumber := 0;

   if ModifierIsTask then

      -- Do we know anything about the type announcement?
      --
      if Dictionary.IsDeclared (TheOwnVarType) or Dictionary.IsPredefined (TheOwnVarType) then

         if not Dictionary.TypeIsTask (TheOwnVarType) then

            ErrorNumber := 855;

         elsif Dictionary.IsSubtype (TheOwnVarType) then

            ErrorNumber := 948;

         end if;
      end if;

      if TheVarType /= Dictionary.NullSymbol and then not Dictionary.TypeIsTask (TheVarType) then

         -- The modifier is 'task', we're declaring a task object but the
         -- type is not a task or task subtype.
         --
         ErrorNumber := 855;
      end if;

   else -- the modifier is not 'task'

      -- Do we know anything about the type announcement?
      --
      if Dictionary.IsDeclared (TheOwnVarType) or Dictionary.IsPredefined (TheOwnVarType) then

         if Dictionary.TypeIsTask (TheOwnVarType) then

            -- We know that the announced type is
            -- not a task type (or subtype)
            --
            ErrorNumber := 855;
         end if;
      end if;

      if TheVarType /= Dictionary.NullSymbol and then Dictionary.TypeIsTask (TheVarType) then

         -- The modifier is not task, we're declaring a task object.
         --
         ErrorNumber := 855;

      end if;
   end if;

   if ErrorNumber /= 0 then
      ErrorHandler.Semantic_Error
        (Err_Num   => ErrorNumber,
         Reference => ErrorHandler.No_Reference,
         Position  => Node_Position (Node => ErrorNode),
         Id_Str    => Node_Lex_String (Node => ErrorNode));
   end if;

   Consistent := ErrorNumber = 0;
end CheckTaskModifierConsistency;
