-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
procedure GetLiteralValue (Node : in     STree.SyntaxNode;
                           Val  :    out Maths.Value) is
   ErrorVal : Maths.ErrorCode;
begin
   Maths.LiteralToValue (Node_Lex_String (Node => Node), Val, ErrorVal);
   if ErrorVal = Maths.IllegalValue then
      ErrorHandler.Semantic_Error
        (Err_Num   => 401,
         Reference => ErrorHandler.No_Reference,
         Position  => Node_Position (Node => Node),
         Id_Str    => LexTokenManager.Null_String);
   elsif ErrorVal = Maths.OverFlow then
      ErrorHandler.Semantic_Warning
        (Err_Num  => 200,
         Position => Node_Position (Node => Node),
         Id_Str   => LexTokenManager.Null_String);
   end if;
end GetLiteralValue;
