-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
function UnknownSymbolRecord return Exp_Record is
begin
   return Exp_Record'
     (Type_Symbol             => Dictionary.GetUnknownTypeMark,
      Other_Symbol            => Dictionary.NullSymbol,
      Stream_Symbol           => Dictionary.NullSymbol,
      Tagged_Parameter_Symbol => Dictionary.NullSymbol,
      Variable_Symbol         => Dictionary.NullSymbol,
      Param_Count             => 0,
      Param_List              => Lists.Null_List,
      Sort                    => Is_Unknown,
      Arg_List_Found          => False,
      Is_AVariable            => False,
      Is_An_Entire_Variable   => False,
      Errors_In_Expression    => True,
      Has_Operators           => False,
      Is_Static               => False,
      Is_Constant             => False,
      Is_ARange               => False,
      String_Value            => LexTokenManager.Null_String,
      Value                   => Maths.NoValue,
      Range_RHS               => Maths.NoValue);
end UnknownSymbolRecord;
