-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
procedure Wf_Function_Annotation
  (Node          : in STree.SyntaxNode;
   Current_Scope : in Dictionary.Scopes;
   Subprog_Sym   : in Dictionary.Symbol;
   First_Seen    : in Boolean) is
   Next_Node         : STree.SyntaxNode;
   Global_Has_Errors : Boolean;

   -- look up table: if First_Seen then we are dealing with Abstract spec else Refined
   type Which_Abstractions is array (Boolean) of Dictionary.Abstractions;
   Which_Abstraction : constant Which_Abstractions :=
     Which_Abstractions'(False => Dictionary.IsRefined,
                         True  => Dictionary.IsAbstract);
begin
   -- ASSUME Node = function_annotation
   SystemErrors.RT_Assert
     (C       => Syntax_Node_Type (Node => Node) = SPSymbols.function_annotation,
      Sys_Err => SystemErrors.Invalid_Syntax_Tree,
      Msg     => "Expect Node = function_annotation in Wf_Function_Annotation");
   Next_Node := Child_Node (Current_Node => Node);
   -- ASSUME Next_Node = moded_global_definition OR function_constraint
   if Syntax_Node_Type (Node => Next_Node) = SPSymbols.moded_global_definition then
      -- ASSUME Next_Node = moded_global_definition
      wf_global_definition (Next_Node, Current_Scope, Subprog_Sym, First_Seen, Global_Has_Errors);
      if Global_Has_Errors then
         Dictionary.SetSubprogramSignatureNotWellformed (Which_Abstraction (First_Seen), Subprog_Sym);
      end if;
   elsif Syntax_Node_Type (Node => Next_Node) /= SPSymbols.function_constraint then
      SystemErrors.Fatal_Error
        (Sys_Err => SystemErrors.Invalid_Syntax_Tree,
         Msg     => "Expect Next_Node = moded_global_definition OR function_constraint in Wf_Function_Annotation");
   end if;
end Wf_Function_Annotation;
