-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with SLI;

separate (Sem.CompUnit)
procedure wf_identifier
  (Node         : in     STree.SyntaxNode;
   Scope        : in     Dictionary.Scopes;
   EStack       : in out ExpStack.ExpStackType;
   RefVar       : in     SeqAlgebra.Seq;
   Context      : in     Tilde_Context;
   IsAnnotation : in     Boolean) is
   Sym : Dictionary.Symbol;
begin -- wf_identifier
   if IsAnnotation then
      Sym := Dictionary.LookupItem (Name              => Node_Lex_String (Node => Node),
                                    Scope             => Scope,
                                    Context           => Dictionary.ProofContext,
                                    Full_Package_Name => False);
      if Sym /= Dictionary.NullSymbol and then ErrorHandler.Generate_SLI then
         SLI.Generate_Xref_Symbol
           (Comp_Unit      => ContextManager.Ops.Current_Unit,
            Parse_Tree     => Node,
            Symbol         => Sym,
            Is_Declaration => False);
      end if;
   else
      Sym := Dictionary.LookupItem (Name              => Node_Lex_String (Node => Node),
                                    Scope             => Scope,
                                    Context           => Dictionary.ProgramContext,
                                    Full_Package_Name => False);
   end if;
   if Sym /= Dictionary.NullSymbol then
      STree.Set_Node_Lex_String (Sym  => Sym,
                                 Node => Node);
   end if;
   if Dictionary.IsPackage (Sym) then
      ExpStack.Push
        (Exp_Record'(Type_Symbol             => Dictionary.GetUnknownTypeMark,
                     Other_Symbol            => Sym,
                     Stream_Symbol           => Dictionary.NullSymbol,
                     Tagged_Parameter_Symbol => Dictionary.NullSymbol,
                     Variable_Symbol         => Dictionary.NullSymbol,
                     Param_Count             => 0,
                     Param_List              => Lists.Null_List,
                     Sort                    => Is_Package,
                     Arg_List_Found          => False,
                     Is_AVariable            => False,
                     Is_An_Entire_Variable   => False,
                     Errors_In_Expression    => False,
                     Has_Operators           => False,
                     Is_Static               => False,
                     Is_Constant             => False,
                     Is_ARange               => False,
                     String_Value            => LexTokenManager.Null_String,
                     Value                   => Maths.NoValue,
                     Range_RHS               => Maths.NoValue),
         EStack);
   else
      StackIdentifier
        (Sym          => Sym,
         IdStr        => Node_Lex_String (Node => Node),
         Node         => Node,
         Prefix       => Dictionary.NullSymbol,
         Scope        => Scope,
         EStack       => EStack,
         RefVar       => RefVar,
         Dotted       => False,
         Context      => Context,
         IsAnnotation => IsAnnotation);
   end if;

   if IsAnnotation and then Next_Sibling (Node) /= STree.NullNode then -- identifier may have ~ or % after it
      case Syntax_Node_Type (Node => Next_Sibling (Node)) is
         when SPSymbols.tilde =>
            wf_tilde (Next_Sibling (Node), Scope, EStack, Context);
         when SPSymbols.percent =>
            wf_percent (Next_Sibling (Node), Scope, EStack);
         when others =>
            null; -- unreachable unless grammar of annotation_identifier altered
      end case;
   end if;
end wf_identifier;
