-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

-- Overview:
-- Loops through all basic_declaritive_item_rep below passed in as Node.
-- Calls appropriate wf for NextDerivative node of each.  Cannot directly
-- raise any errors but called procedures can.
----------------------------------------------------------------------------

separate (Sem.CompUnit.Wf_Package_Specification)
procedure Wf_Private (Node  : in STree.SyntaxNode;
                      Scope : in Dictionary.Scopes) is
   Next_Node, Node_To_Check : STree.SyntaxNode;
   Unused                   : Dictionary.Symbol;
begin
   -- ASSUME Node = basic_declarative_item_rep
   SystemErrors.RT_Assert
     (C       => Syntax_Node_Type (Node => Node) = SPSymbols.basic_declarative_item_rep,
      Sys_Err => SystemErrors.Invalid_Syntax_Tree,
      Msg     => "Expect Node = basic_declarative_item_rep in Wf_Private");

   Next_Node := Last_Child_Of (Start_Node => Node);
   while Next_Node /= Node loop
      -- ASSUME Next_Node = basic_declarative_item_rep
      SystemErrors.RT_Assert
        (C       => Syntax_Node_Type (Node => Next_Node) = SPSymbols.basic_declarative_item_rep,
         Sys_Err => SystemErrors.Invalid_Syntax_Tree,
         Msg     => "Expect Next_Node = basic_declarative_item_rep in Wf_Private");
      Node_To_Check := Next_Sibling (Current_Node => Next_Node);
      -- ASSUME Node_To_Check = subprogram_declaration OR generic_subprogram_instantiation OR basic_declarative_item OR apragma
      case Syntax_Node_Type (Node => Node_To_Check) is
         when SPSymbols.basic_declarative_item =>
            -- ASSUME Node_To_Check = basic_declarative_item
            Wf_Basic_Declarative_Item (Node          => Node_To_Check,
                                       Current_Scope => Scope);
         when SPSymbols.apragma =>
            -- ASSUME Node_To_Check = apragma
            wf_pragma (Node_To_Check, Scope);
         when SPSymbols.subprogram_declaration =>
            -- ASSUME Node_To_Check = subprogram_declaration
            --# accept Flow, 41, "Expected stable expression";
            case CommandLineData.Content.Language_Profile is
               when CommandLineData.SPARK83 =>
                  ErrorHandler.Semantic_Error
                    (Err_Num   => 113,
                     Reference => ErrorHandler.No_Reference,
                     Position  => Node_Position (Node => Node_To_Check),
                     Id_Str    => LexTokenManager.Null_String);
               when CommandLineData.SPARK95 | CommandLineData.SPARK2005 =>
                  --# accept Flow, 10 , Unused, "Expected ineffective assignment";
                  Wf_Subprogram_Declaration (Node            => Node_To_Check,
                                             Current_Scope   => Scope,
                                             The_Subprog_Sym => Unused);
                  --# end accept;
            end case;
            --# end accept;
         when SPSymbols.generic_subprogram_instantiation =>
            -- ASSUME Node_To_Check = generic_subprogram_instantiation
            wf_generic_subprogram_instantiation (Node_To_Check, Scope);
         when others =>
            SystemErrors.Fatal_Error
              (Sys_Err => SystemErrors.Invalid_Syntax_Tree,
               Msg     => "Expect Node_To_Check = subprogram_declaration OR generic_subprogram_instantiation OR basic_declarative_item OR apragma in WF_Private");
      end case;
      Next_Node := Parent_Node (Current_Node => Next_Node);
   end loop;
   --# accept Flow, 33, Unused, "Expected to be neither referenced nor exported";
end Wf_Private;
