-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
procedure wf_predicate
  (Node        : in     STree.SyntaxNode;
   Scope       : in     Dictionary.Scopes;
   Context     : in     Anno_Tilde_Context;
   ErrorsFound :    out Boolean) is
   PredResult : Exp_Record;
begin
   -- ASSUME Node = predicate
   WalkAnnotationExpression
     (Exp_Node       => Node,
      Scope          => Scope,
      Type_Context   => Dictionary.GetPredefinedBooleanType,
      Context        => Context,
      Result         => PredResult,
      Component_Data => GlobalComponentData);

   if not Dictionary.IsBooleanTypeMark (PredResult.Type_Symbol) then
      ErrorsFound := True;
      ErrorHandler.Semantic_Error
        (Err_Num   => 326,
         Reference => ErrorHandler.No_Reference,
         Position  => Node_Position (Node => Node),
         Id_Str    => LexTokenManager.Null_String);
   else -- result is Boolean but errors may have been found lower down the expression
      ErrorsFound := PredResult.Errors_In_Expression;
   end if;
end wf_predicate;
