-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
procedure wf_priority_value
  (Node       : in     STree.SyntaxNode;
   PragmaKind : in     Dictionary.RavenscarPragmas;
   Context    : in     Dictionary.Contexts;
   ErrorSym   : in     Dictionary.Symbol;
   Scope      : in     Dictionary.Scopes;
   ValueRep   :    out LexTokenManager.Lex_String;
   Compatible :    out Boolean) is
   TypeSym             : Dictionary.Symbol;
   Result              : Exp_Record;
   UnusedSeq           : SeqAlgebra.Seq;
   UnusedComponentData : ComponentManager.ComponentData;
begin
   -- check validity of argument
   -- must be integer and in appropriate System.[Interrupt_]Priority range
   SeqAlgebra.CreateSeq (TheHeap, UnusedSeq);
   ComponentManager.Initialise (UnusedComponentData);
   --# accept Flow, 10, UnusedComponentData, "Expected ineffective assignment";
   if Context = Dictionary.ProgramContext then
      WalkExpression
        (Exp_Node                => Node,
         Scope                   => Scope,
         Type_Context            => Dictionary.GetPredefinedIntegerType,
         Context_Requires_Static => True,
         Result                  => Result,
         Ref_Var                 => UnusedSeq,
         Component_Data          => UnusedComponentData);
   else
      WalkAnnotationExpression
        (Exp_Node       => Node,
         Scope          => Scope,
         Type_Context   => Dictionary.GetPredefinedIntegerType,
         Context        => Precondition, -- no ~ allowed here, so use Precondition context
         Result         => Result,
         Component_Data => UnusedComponentData);
   end if;
   --# end accept;

   SeqAlgebra.DisposeOfSeq (TheHeap, UnusedSeq);

   -- actual parameter must be fixed
   if not Result.Is_Constant then
      ErrorHandler.Semantic_Error
        (Err_Num   => 37,
         Reference => ErrorHandler.No_Reference,
         Position  => Node_Position (Node => Node),
         Id_Str    => LexTokenManager.Null_String);
   end if;

   -- argument must be integer value
   TypeSym := Dictionary.GetRootType (Result.Type_Symbol);
   if Dictionary.CompatibleTypes (Scope, TypeSym, Dictionary.GetPredefinedIntegerType) then
      Compatible := True;
      -- range checking here if values known in Dictionary
      CheckPriorityRange
        (Error_Sym   => ErrorSym,
         Scope       => Scope,
         Pragma_Kind => PragmaKind,
         Err_Pos     => Node_Position (Node => Node),
         Value       => Result.Value,
         Value_Rep   => ValueRep);
   else
      Compatible := False;
      ValueRep   := LexTokenManager.Null_String;
      ErrorHandler.Semantic_Error
        (Err_Num   => 877,
         Reference => ErrorHandler.No_Reference,
         Position  => Node_Position (Node => Node),
         Id_Str    => LexTokenManager.Null_String);
   end if;
end wf_priority_value;
