-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

----------------------------------------------------------------------------
-- This unit WFFs use type clauses that appear _inside_ a package body only.
-- Currently these are not allowed in SPARK83 at all, and in SPARK95, we
-- WFF their position (they must directly follow the embedded package to
-- which they refer), but report they are otherwise unimplemented.
--
-- This does NOT WFF use type clauses that appear as part of a context
-- clause - these are handled separately by
-- Sem.CompUnit.wf_context_clause.use_clause
----------------------------------------------------------------------------
separate (Sem.CompUnit)
procedure Wf_Use_Type_Clause (Node : in STree.SyntaxNode) is
   It            : STree.Iterator;
   ParentItemRep : STree.SyntaxNode;

   procedure CheckPosition
     (Node       : in     STree.SyntaxNode;
      Parent     : in     STree.SyntaxNode;
      PackString : in     LexTokenManager.Lex_String;
      PosOk      :    out Boolean)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         PackString,
   --#                                         Parent,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table &
   --#         PosOk                      from LexTokenManager.State,
   --#                                         PackString,
   --#                                         Parent,
   --#                                         STree.Table;
   is
      Ident : LexTokenManager.Lex_String;
   begin -- CheckPosition
      if Syntax_Node_Type (Node => Parent) = SPSymbols.initial_declarative_item_rep then
         -- should follow a package declaration
         Ident := FindPreviousPackage (Parent);

         if LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Ident,
                                                                 Lex_Str2 => LexTokenManager.Null_String) =
           LexTokenManager.Str_Eq then
            ErrorHandler.Semantic_Error
              (Err_Num   => 112,
               Reference => ErrorHandler.No_Reference,
               Position  => Node_Position (Node => Node),
               Id_Str    => LexTokenManager.Null_String);
            PosOk := False;
         elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Ident,
                                                                    Lex_Str2 => PackString) /=
           LexTokenManager.Str_Eq then
            ErrorHandler.Semantic_Error
              (Err_Num   => 301,
               Reference => ErrorHandler.No_Reference,
               Position  => Node_Position (Node => Node),
               Id_Str    => Ident);
            PosOk := False;
         else
            PosOk := True;
         end if;
      else
         PosOk := False;
      end if;

   end CheckPosition;

   procedure ProcessDottedSimpleName (Node   : in STree.SyntaxNode;
                                      Parent : in STree.SyntaxNode)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Parent,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table;
   is
      OK : Boolean;
   begin
      CheckPosition (Node, Parent, Node_Lex_String (Node => Last_Child_Of (Start_Node => Node)), OK);
      if OK then
         -- Position is OK, but alas "use type" is currently unimplemented...
         -- If this is ever completed, then remember to revise the comment
         -- at the top of this unit!
         ErrorHandler.Semantic_Error
           (Err_Num   => 110,
            Reference => ErrorHandler.No_Reference,
            Position  => Node_Position (Node => Node),
            Id_Str    => LexTokenManager.Null_String);
      end if;
   end ProcessDottedSimpleName;

begin -- wf_use_type_clause
   case CommandLineData.Content.Language_Profile is
      when CommandLineData.SPARK83 =>

         ErrorHandler.Semantic_Error
           (Err_Num   => 550,
            Reference => ErrorHandler.No_Reference,
            Position  => Node_Position (Node => Node),
            Id_Str    => LexTokenManager.Null_String);
      when CommandLineData.SPARK95 | CommandLineData.SPARK2005 =>

         -- Could be "use type E.T1, E.T2;" so we need to loop and check
         -- the position of each type mark.

         ParentItemRep := Parent_Node (Current_Node => Node);
         It            :=
           Find_First_Node (Node_Kind    => SPSymbols.dotted_simple_name,
                            From_Root    => Node,
                            In_Direction => STree.Down);

         while not STree.IsNull (It) loop
            ProcessDottedSimpleName (Get_Node (It => It), ParentItemRep);
            It := STree.NextNode (It);
         end loop;
   end case;
end Wf_Use_Type_Clause;
