-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
procedure CheckCeilingPriority
  (Sym                : in Dictionary.Symbol;
   Scope              : in Dictionary.Scopes;
   Check_List         : in Dictionary.Iterator;
   Priority_Lex_Value : in LexTokenManager.Lex_String;
   Error_Node_Pos     : in LexTokenManager.Token_Position) is
   It           : Dictionary.Iterator;
   Var_Sym      : Dictionary.Symbol;
   Priority_Val : Maths.Value;
   Result       : Maths.Value;
   Unused       : Maths.ErrorCode;
   Priority_Ok  : Boolean;
begin
   It           := Check_List;
   Priority_Val := Maths.ValueRep (Priority_Lex_Value);
   while not Dictionary.IsNullIterator (It) loop
      Var_Sym := Dictionary.CurrentSymbol (It);
      -- Ignore all own variables that do not have a priority property.
      if Dictionary.IsOwnVariable (Var_Sym) and then Dictionary.HasValidPriorityProperty (Var_Sym) then
         -- Ensure that Var_Sym's priority is >= given priority
         --# accept Flow, 10, Unused, "Expected ineffective assignment";
         Maths.GreaterOrEqual (Maths.ValueRep (Dictionary.GetPriorityProperty (Var_Sym)), Priority_Val, Result, Unused);
         Maths.ValueToBool (Result, Priority_Ok, Unused);
         --# end accept;
         if not Priority_Ok then
            -- "Priority Ceiling check failure: the priority of Var_Sym is less
            -- than that of the Sym"
            ErrorHandler.Semantic_Error_Sym2
              (Err_Num   => 934,
               Reference => ErrorHandler.No_Reference,
               Position  => Error_Node_Pos,
               Sym       => Sym,
               Sym2      => Var_Sym,
               Scope     => Scope);
         end if;
      end if;
      It := Dictionary.NextSymbol (It);
   end loop;
   --# accept Flow, 33, Unused, "Expected to be neither referenced nor exported";
end CheckCeilingPriority;
