-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.Walk_Expression_P)
procedure Add_Name
  (Name       : in     LexTokenManager.Lex_String;
   List       : in     Lists.List;
   Heap_Param : in out Lists.List_Heap;
   Present    :    out Boolean) is
   Ok : Boolean;
begin
   Lists.Add_Name (Heap            => Heap_Param,
                   The_List        => List,
                   Name            => Name,
                   Already_Present => Present,
                   Ok              => Ok);
   if not Ok then
      SystemErrors.Fatal_Error (Sys_Err => SystemErrors.List_Overflow_In_Expression,
                                Msg     => "in Add_Name");
   end if;
end Add_Name;
