-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

-------------------------------------------------------------------------
-- ScreenEcho
--
-- Simple operations for printing Strings, Integers, ExaminerStrings
-- and so on to SPARK_IO.Standard_Output
-------------------------------------------------------------------------

with SPARK_IO, E_Strings;

--# inherit E_Strings,
--#         SPARK_IO;
package ScreenEcho is

   procedure Put_Char (Item : in Character);
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Item;

   procedure Put_Integer (Item  : in Integer;
                          Width : in Natural;
                          Base  : in SPARK_IO.Number_Base);
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Base,
   --#                                Item,
   --#                                Width;

   procedure Put_String (Item : in String);
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Item;

   procedure Put_Line (Item : in String);
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Item;

   procedure Put_StringWithLength (Item : in String;
                                   Stop : in Natural);
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Item,
   --#                                Stop;

   procedure Put_LineWithLength (Item : in String;
                                 Stop : in Natural);
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Item,
   --#                                Stop;

   procedure New_Line (Spacing : in Positive);
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Spacing;

   procedure Set_Col (Posn : in Positive);
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Posn;

   procedure Put_ExaminerString (Item : in E_Strings.T);
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Item;

   procedure Put_ExaminerLine (Item : in E_Strings.T);
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Item;

   -- Prints the given message to the screen, followed by " ..."
   -- indented at the 12th column, and possibly adding line-breaks at
   -- spaces.  Used in MainLoop to generate the Examiner's analysis running
   -- commentary.
   procedure Echo (Str : in E_Strings.T);
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Str;

end ScreenEcho;
