-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with Unit;
with Units;

--# inherit E_Strings,
--#         Unit,
--#         UnitManager,
--#         Units;

private package UnitManager.UnitStore
--# own State;
--# initializes State;
is

   procedure Add (The_Unit : in     Unit.Object;
                  Added    :    out Boolean);
   --# global in out State;
   --# derives Added,
   --#         State from State,
   --#                    The_Unit;

   function Get (The_Unit : Unit.Id) return Unit.Object;
   --# global in State;

   function Get_Body_Unit (With_Name : in E_Strings.T) return Unit.Object;
   --# global in State;

   function Get_Specification_Unit (With_Name : in E_Strings.T) return Unit.Object;
   --# global in State;

   function Get_All_Units return  Units.Stack;
   --# global in State;

end UnitManager.UnitStore;
