/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Wed May 27 18:50:23 2015

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_13 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 3346, "epsg", 3346,
        "LKS94 / Lithuania TM", 0, 1,
        "GRS 1980", "Greenwich",
        "Lithuania_1994_ETRS89", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9998 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"LKS94 / Lithuania TM\",GEOGCS[\"LKS94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Lithuania_1994_ETRS89\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 2,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,");
    add_srs_wkt (p, 3,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"6126\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 6,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4669\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",24],PARAMETER[\"scale_factor\",0.9998],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",");
    add_srs_wkt (p, 12,
        "NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"3346\"]]");
    p = add_epsg_def_ex (filter, first, last, 3347, "epsg", 3347,
        "NAD83 / Statistics Canada Lambert", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49 +lat_2=77 +lat_0=63.390675 +lon_0=-9");
    add_proj4text (p, 1,
        "1.86666666666666 +x_0=6200000 +y_0=3000000 +ellps=GRS80 ");
    add_proj4text (p, 2,
        "+towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Statistics Canada Lambert\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 8,
        "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",49],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_2\",77],PARAMETER[\"latitu");
    add_srs_wkt (p, 10,
        "de_of_origin\",63.390675],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 11,
        ",-91.86666666666666],PARAMETER[\"false_easting\",6200000");
    add_srs_wkt (p, 12,
        "],PARAMETER[\"false_northing\",3000000],UNIT[\"metre\",1");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 14,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3347\"]]");
    p = add_epsg_def_ex (filter, first, last, 3348, "epsg", 3348,
        "NAD83(CSRS) / Statistics Canada Lambert", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49 +lat_2=77 +lat_0=63.390675 +lon_0=-9");
    add_proj4text (p, 1,
        "1.86666666666666 +x_0=6200000 +y_0=3000000 +ellps=GRS80 ");
    add_proj4text (p, 2,
        "+towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / Statistics Canada Lambert\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_1\",49],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 10,
        "2\",77],PARAMETER[\"latitude_of_origin\",63.390675],PARA");
    add_srs_wkt (p, 11,
        "METER[\"central_meridian\",-91.86666666666666],PARAMETER");
    add_srs_wkt (p, 12,
        "[\"false_easting\",6200000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 13,
        ",3000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 14,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 15,
        "TY[\"EPSG\",\"3348\"]]");
    p = add_epsg_def_ex (filter, first, last, 3349, "epsg", 3349,
        "WGS 84 / PDC Mercator (deprecated)", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Mercator_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=-150 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / PDC Mercator (deprecated)\",GEOGCS[\"W");
    add_srs_wkt (p, 1,
        "GS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 6,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Mercator_1SP\"],PARAMETER[\"central_meridian\",-150]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 10,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3349\"]]");
    p = add_epsg_def_ex (filter, first, last, 3350, "epsg", 3350,
        "Pulkovo 1942 / CS63 zone C0", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0.1 +lon_0=21.95 +k=1 +x_0=250000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.8");
    add_proj4text (p, 2,
        "2,-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / CS63 zone C0\",GEOGCS[\"Pulkovo ");
    add_srs_wkt (p, 1,
        "1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassowsky 1940");
    add_srs_wkt (p, 2,
        "\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[2");
    add_srs_wkt (p, 3,
        "3.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        ".1],PARAMETER[\"central_meridian\",21.95],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",250000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"3350\"]]");
    p = add_epsg_def_ex (filter, first, last, 3351, "epsg", 3351,
        "Pulkovo 1942 / CS63 zone C1", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0.1 +lon_0=24.95 +k=1 +x_0=1250000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.");
    add_proj4text (p, 2,
        "82,-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / CS63 zone C1\",GEOGCS[\"Pulkovo ");
    add_srs_wkt (p, 1,
        "1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassowsky 1940");
    add_srs_wkt (p, 2,
        "\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[2");
    add_srs_wkt (p, 3,
        "3.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        ".1],PARAMETER[\"central_meridian\",24.95],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",1250000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"3351\"]]");
    p = add_epsg_def_ex (filter, first, last, 3352, "epsg", 3352,
        "Pulkovo 1942 / CS63 zone C2", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0.1 +lon_0=27.95 +k=1 +x_0=2250000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.");
    add_proj4text (p, 2,
        "82,-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / CS63 zone C2\",GEOGCS[\"Pulkovo ");
    add_srs_wkt (p, 1,
        "1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassowsky 1940");
    add_srs_wkt (p, 2,
        "\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[2");
    add_srs_wkt (p, 3,
        "3.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        ".1],PARAMETER[\"central_meridian\",27.95],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",2250000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"3352\"]]");
    p = add_epsg_def_ex (filter, first, last, 3353, "epsg", 3353,
        "Mhast (onshore) / UTM zone 32S", 0, 0,
        "International 1924", "Greenwich",
        "Mhast_onshore", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +south +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Mhast (onshore) / UTM zone 32S\",GEOGCS[\"Mhast");
    add_srs_wkt (p, 1,
        " (onshore)\",DATUM[\"Mhast_onshore\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6704\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 6,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4704\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",9],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",10000000],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "353\"]]");
    p = add_epsg_def_ex (filter, first, last, 3354, "epsg", 3354,
        "Mhast (offshore) / UTM zone 32S", 0, 0,
        "International 1924", "Greenwich",
        "Mhast_offshore", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +south +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Mhast (offshore) / UTM zone 32S\",GEOGCS[\"Mhas");
    add_srs_wkt (p, 1,
        "t (offshore)\",DATUM[\"Mhast_offshore\",SPHEROID[\"Inter");
    add_srs_wkt (p, 2,
        "national 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6705\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 6,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"470");
    add_srs_wkt (p, 7,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",9],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",500000],PARAMETER[\"false_northing\",10000000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"3354\"]]");
    p = add_epsg_def_ex (filter, first, last, 3355, "epsg", 3355,
        "Egypt Gulf of Suez S-650 TL / Red Belt", 0, 0,
        "Helmert 1906", "Greenwich",
        "Egypt_Gulf_of_Suez_S_650_TL", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=31 +k=1 +x_0=615000 +y_0=81");
    add_proj4text (p, 1,
        "0000 +ellps=helmert +towgs84=-146.21,112.63,4.05,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Egypt Gulf of Suez S-650 TL / Red Belt\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Egypt Gulf of Suez S-650 TL\",DATUM[\"Egypt_Gulf_of_S");
    add_srs_wkt (p, 2,
        "uez_S_650_TL\",SPHEROID[\"Helmert 1906\",6378200,298.3,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7020\"]],TOWGS84[-146.21,112.63,4.05");
    add_srs_wkt (p, 4,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6706\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 7,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 8,
        "\",\"4706\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",30],PARAMETER[\"central_merid");
    add_srs_wkt (p, 10,
        "ian\",31],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",615000],PARAMETER[\"false_northing\",810000]");
    add_srs_wkt (p, 12,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 13,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"3355\"]]");
    p = add_epsg_def_ex (filter, first, last, 3356, "epsg", 3356,
        "Grand Cayman 1959 / UTM zone 17N (deprecated)", 0, 0,
        "Clarke 1866", "Greenwich",
        "Grand_Cayman_Geodetic_Datum_1959", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=clrk66 +towgs84=-179.483,-69.3");
    add_proj4text (p, 1,
        "79,-27.584,-7.862,8.163,6.042,-13.925 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Grand Cayman 1959 / UTM zone 17N (deprecated)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"GCGD59\",DATUM[\"Grand_Cayman_Geodetic_Datum_1");
    add_srs_wkt (p, 2,
        "959\",SPHEROID[\"Clarke 1866\",6378206.4,294.97869821389");
    add_srs_wkt (p, 3,
        "82,AUTHORITY[\"EPSG\",\"7008\"]],TOWGS84[-179.483,-69.37");
    add_srs_wkt (p, 4,
        "9,-27.584,-7.862,8.163,6.042,-13.925],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"6723\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 8,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4723\"]],PROJECTION[\"T");
    add_srs_wkt (p, 9,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"central_meridian\",-81],PARAMETER[\"scale_");
    add_srs_wkt (p, 11,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 12,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 14,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"3356\"]]");
    p = add_epsg_def_ex (filter, first, last, 3357, "epsg", 3357,
        "Little Cayman 1961 / UTM zone 17N (deprecated)", 0, 0,
        "Clarke 1866", "Greenwich",
        "Sister_Islands_Geodetic_Datum_1961", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=clrk66 +towgs84=8.853,-52.644,");
    add_proj4text (p, 1,
        "180.304,-0.393,-2.323,2.96,-24.081 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Little Cayman 1961 / UTM zone 17N (deprecated)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"SIGD61\",DATUM[\"Sister_Islands_Geodetic_Datum");
    add_srs_wkt (p, 2,
        "_1961\",SPHEROID[\"Clarke 1866\",6378206.4,294.978698213");
    add_srs_wkt (p, 3,
        "8982,AUTHORITY[\"EPSG\",\"7008\"]],TOWGS84[8.853,-52.644");
    add_srs_wkt (p, 4,
        ",180.304,-0.393,-2.323,2.96,-24.081],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"6726\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 6,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 8,
        "de\",EAST],AUTHORITY[\"EPSG\",\"4726\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 9,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"central_meridian\",-81],PARAMETER[\"scale_f");
    add_srs_wkt (p, 11,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 12,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 14,
        "\",NORTH],AUTHORITY[\"EPSG\",\"3357\"]]");
    p = add_epsg_def_ex (filter, first, last, 3358, "epsg", 3358,
        "NAD83(HARN) / North Carolina", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=33.75 +lon_0=-79 +x_0=609601.22 +y_0=0 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / North Carolina\",GEOGCS[\"NAD83(H");
    add_srs_wkt (p, 1,
        "ARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 7,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"");
    add_srs_wkt (p, 8,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 9,
        "llel_1\",36.16666666666666],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 10,
        "l_2\",34.33333333333334],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 11,
        ",33.75],PARAMETER[\"central_meridian\",-79],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_easting\",609601.22],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 13,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 14,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3358\"]");
    add_srs_wkt (p, 15,
        "]");
    p = add_epsg_def_ex (filter, first, last, 3359, "epsg", 3359,
        "NAD83(HARN) / North Carolina (ftUS) (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=33.75 +lon_0=-79 +x_0=609601.2192024385 +y_0=");
    add_proj4text (p, 2,
        "0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / North Carolina (ftUS) (deprecated");
    add_srs_wkt (p, 1,
        ")\",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_R");
    add_srs_wkt (p, 2,
        "eference_Network\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 8,
        "52\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"standard_parallel_1\",36.16666666666666],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"standard_parallel_2\",34.33333333333334],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "latitude_of_origin\",33.75],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 12,
        "\",-79],PARAMETER[\"false_easting\",2000004.000008],PARA");
    add_srs_wkt (p, 13,
        "METER[\"false_northing\",0],UNIT[\"foot\",0.3048,AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"9002\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH");
    add_srs_wkt (p, 15,
        "],AUTHORITY[\"EPSG\",\"3359\"]]");
    p = add_epsg_def_ex (filter, first, last, 3360, "epsg", 3360,
        "NAD83(HARN) / South Carolina", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.83333333333334 +lat_2=32.5 +lat_0=31");
    add_proj4text (p, 1,
        ".83333333333333 +lon_0=-81 +x_0=609600 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / South Carolina\",GEOGCS[\"NAD83(H");
    add_srs_wkt (p, 1,
        "ARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 7,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"");
    add_srs_wkt (p, 8,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 9,
        "llel_1\",34.83333333333334],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 10,
        "l_2\",32.5],PARAMETER[\"latitude_of_origin\",31.83333333");
    add_srs_wkt (p, 11,
        "333333],PARAMETER[\"central_meridian\",-81],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_easting\",609600],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 13,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 14,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3360\"]]");
    p = add_epsg_def_ex (filter, first, last, 3361, "epsg", 3361,
        "NAD83(HARN) / South Carolina (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.83333333333334 +lat_2=32.5 +lat_0=31");
    add_proj4text (p, 1,
        ".83333333333333 +lon_0=-81 +x_0=609600 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / South Carolina (ft)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 9,
        "_parallel_1\",34.83333333333334],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 10,
        "rallel_2\",32.5],PARAMETER[\"latitude_of_origin\",31.833");
    add_srs_wkt (p, 11,
        "33333333333],PARAMETER[\"central_meridian\",-81],PARAMET");
    add_srs_wkt (p, 12,
        "ER[\"false_easting\",2000000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 13,
        "\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]]");
    add_srs_wkt (p, 14,
        ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 15,
        "3361\"]]");
    p = add_epsg_def_ex (filter, first, last, 3362, "epsg", 3362,
        "NAD83(HARN) / Pennsylvania North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.95 +lat_2=40.88333333333333 +lat_0=4");
    add_proj4text (p, 1,
        "0.16666666666666 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Pennsylvania North\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 9,
        "_parallel_1\",41.95],PARAMETER[\"standard_parallel_2\",4");
    add_srs_wkt (p, 10,
        "0.88333333333333],PARAMETER[\"latitude_of_origin\",40.16");
    add_srs_wkt (p, 11,
        "666666666666],PARAMETER[\"central_meridian\",-77.75],PAR");
    add_srs_wkt (p, 12,
        "AMETER[\"false_easting\",600000],PARAMETER[\"false_north");
    add_srs_wkt (p, 13,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 14,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 15,
        "3362\"]]");
    p = add_epsg_def_ex (filter, first, last, 3363, "epsg", 3363,
        "NAD83(HARN) / Pennsylvania North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.95 +lat_2=40.88333333333333 +lat_0=4");
    add_proj4text (p, 1,
        "0.16666666666666 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Pennsylvania North (ftUS)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_");
    add_srs_wkt (p, 2,
        "Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "tandard_parallel_1\",41.95],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 10,
        "l_2\",40.88333333333333],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 11,
        ",40.16666666666666],PARAMETER[\"central_meridian\",-77.7");
    add_srs_wkt (p, 12,
        "5],PARAMETER[\"false_easting\",1968500],PARAMETER[\"fals");
    add_srs_wkt (p, 13,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 14,
        "92,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 15,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"3363\"]]");
    p = add_epsg_def_ex (filter, first, last, 3364, "epsg", 3364,
        "NAD83(HARN) / Pennsylvania South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=600000 +");
    add_proj4text (p, 2,
        "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Pennsylvania South\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 9,
        "_parallel_1\",40.96666666666667],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 10,
        "rallel_2\",39.93333333333333],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 11,
        "igin\",39.33333333333334],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 12,
        ",-77.75],PARAMETER[\"false_easting\",600000],PARAMETER[\"");
    add_srs_wkt (p, 13,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 15,
        "\"EPSG\",\"3364\"]]");
    p = add_epsg_def_ex (filter, first, last, 3365, "epsg", 3365,
        "NAD83(HARN) / Pennsylvania South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=600000 +");
    add_proj4text (p, 2,
        "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Pennsylvania South (ftUS)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_");
    add_srs_wkt (p, 2,
        "Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "tandard_parallel_1\",40.96666666666667],PARAMETER[\"stan");
    add_srs_wkt (p, 10,
        "dard_parallel_2\",39.93333333333333],PARAMETER[\"latitud");
    add_srs_wkt (p, 11,
        "e_of_origin\",39.33333333333334],PARAMETER[\"central_mer");
    add_srs_wkt (p, 12,
        "idian\",-77.75],PARAMETER[\"false_easting\",1968500],PAR");
    add_srs_wkt (p, 13,
        "AMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 14,
        "048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\"");
    add_srs_wkt (p, 15,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3365\"]]");
    p = add_epsg_def_ex (filter, first, last, 3366, "epsg", 3366,
        "Hong Kong 1963 Grid System (deprecated)", 0, 1,
        "Clarke 1858", "Greenwich",
        "Hong_Kong_1963", "Cassini_Soldner", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=22.31213333333334 +lon_0=114.178555555");
    add_proj4text (p, 1,
        "5556 +x_0=40243.57775604237 +y_0=19069.93351512578 +a=63");
    add_proj4text (p, 2,
        "78293.645208759 +b=6356617.987679838 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Hong Kong 1963 Grid System (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"Hong Kong 1963\",DATUM[\"Hong_Kong_1963\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Clarke 1858\",6378293.645208759,294.2606763692606,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7007\"]],AUTHORITY[\"EPSG\",\"6738\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4738\"]],PROJECTION[\"Cassini_Soldner\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"latitude_of_origin\",22.31213333333334],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"central_meridian\",114.1785555555556],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",40243.57775604237],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",19069.93351512578],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 13,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"3366\"]]");
    p = add_epsg_def_ex (filter, first, last, 3367, "epsg", 3367,
        "IGN Astro 1960 / UTM zone 28N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "IGN_Astro_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +ellps=clrk80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGN Astro 1960 / UTM zone 28N\",GEOGCS[\"IGN As");
    add_srs_wkt (p, 1,
        "tro 1960\",DATUM[\"IGN_Astro_1960\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "80 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6700\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 6,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4700\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "15],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "367\"]]");
    p = add_epsg_def_ex (filter, first, last, 3368, "epsg", 3368,
        "IGN Astro 1960 / UTM zone 29N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "IGN_Astro_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=clrk80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGN Astro 1960 / UTM zone 29N\",GEOGCS[\"IGN As");
    add_srs_wkt (p, 1,
        "tro 1960\",DATUM[\"IGN_Astro_1960\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "80 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6700\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 6,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4700\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"336");
    add_srs_wkt (p, 13,
        "8\"]]");
    p = add_epsg_def_ex (filter, first, last, 3369, "epsg", 3369,
        "IGN Astro 1960 / UTM zone 30N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "IGN_Astro_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +ellps=clrk80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGN Astro 1960 / UTM zone 30N\",GEOGCS[\"IGN As");
    add_srs_wkt (p, 1,
        "tro 1960\",DATUM[\"IGN_Astro_1960\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "80 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6700\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 6,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4700\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"336");
    add_srs_wkt (p, 13,
        "9\"]]");
    p = add_epsg_def_ex (filter, first, last, 3370, "epsg", 3370,
        "NAD27 / UTM zone 59N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=59 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 59N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 6,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",171],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3370\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 3371, "epsg", 3371,
        "NAD27 / UTM zone 60N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=60 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 60N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 6,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",177],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3371\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 3372, "epsg", 3372,
        "NAD83 / UTM zone 59N", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=59 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / UTM zone 59N\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",171],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"3372\"]]");
    p = add_epsg_def_ex (filter, first, last, 3373, "epsg", 3373,
        "NAD83 / UTM zone 60N", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=60 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / UTM zone 60N\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",177],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"3373\"]]");
    p = add_epsg_def_ex (filter, first, last, 3374, "epsg", 3374,
        "FD54 / UTM zone 29N", 0, 0,
        "International 1924", "Greenwich",
        "Faroe_Datum_1954", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"FD54 / UTM zone 29N\",GEOGCS[\"FD54\",DATUM[\"F");
    add_srs_wkt (p, 1,
        "aroe_Datum_1954\",SPHEROID[\"International 1924\",637838");
    add_srs_wkt (p, 2,
        "8,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6741\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 6,
        "\",EAST],AUTHORITY[\"EPSG\",\"4741\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-9],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"3374\"]]");
    p = add_epsg_def_ex (filter, first, last, 3375, "epsg", 3375,
        "GDM2000 / Peninsula RSO", 0, 0,
        "GRS 1980", "Greenwich",
        "Geodetic_Datum_of_Malaysia_2000", "Hotine_Oblique_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=4 +lonc=102.25 +alpha=323.02579646666");
    add_proj4text (p, 1,
        "66 +k=0.99984 +x_0=804671 +y_0=0 +no_uoff +gamma=323.130");
    add_proj4text (p, 2,
        "1023611111 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDM2000 / Peninsula RSO\",GEOGCS[\"GDM2000\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Geodetic_Datum_of_Malaysia_2000\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6742\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 6,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"474");
    add_srs_wkt (p, 7,
        "2\"]],PROJECTION[\"Hotine_Oblique_Mercator\"],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"latitude_of_center\",4],PARAMETER[\"longitude_of_cente");
    add_srs_wkt (p, 9,
        "r\",102.25],PARAMETER[\"azimuth\",323.0257964666666],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"rectified_grid_angle\",323.1301023611111],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"scale_factor\",0.99984],PARAMETER[\"false_easting");
    add_srs_wkt (p, 12,
        "\",804671],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 13,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 14,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3375\"]]");
    p = add_epsg_def_ex (filter, first, last, 3376, "epsg", 3376,
        "GDM2000 / East Malaysia BRSO", 0, 0,
        "GRS 1980", "Greenwich",
        "Geodetic_Datum_of_Malaysia_2000", "Hotine_Oblique_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=4 +lonc=115 +alpha=53.31580995 +k=0.9");
    add_proj4text (p, 1,
        "9984 +x_0=0 +y_0=0 +no_uoff +gamma=53.13010236111111 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDM2000 / East Malaysia BRSO\",GEOGCS[\"GDM2000");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Geodetic_Datum_of_Malaysia_2000\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],AUTHORITY[\"EPSG\",\"6742\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 6,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4742\"]],PROJECTION[\"Hotine_Oblique_Mercator\"],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"latitude_of_center\",4],PARAMETER[\"longitude_of_ce");
    add_srs_wkt (p, 9,
        "nter\",115],PARAMETER[\"azimuth\",53.31580995],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"rectified_grid_angle\",53.13010236111111],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "scale_factor\",0.99984],PARAMETER[\"false_easting\",0],P");
    add_srs_wkt (p, 12,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 14,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"3376\"]]");
    p = add_epsg_def_ex (filter, first, last, 3377, "epsg", 3377,
        "GDM2000 / Johor Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "Geodetic_Datum_of_Malaysia_2000", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=2.121679744444445 +lon_0=103.427936236");
    add_proj4text (p, 1,
        "1111 +x_0=-14810.562 +y_0=8758.32 +ellps=GRS80 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDM2000 / Johor Grid\",GEOGCS[\"GDM2000\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Geodetic_Datum_of_Malaysia_2000\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6742\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 6,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4742\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Cassini_Soldner\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 8,
        "of_origin\",2.121679744444445],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",103.4279362361111],PARAMETER[\"false_easting\",-14");
    add_srs_wkt (p, 10,
        "810.562],PARAMETER[\"false_northing\",8758.32],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3377\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 3378, "epsg", 3378,
        "GDM2000 / Sembilan and Melaka Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "Geodetic_Datum_of_Malaysia_2000", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=2.682347636111111 +lon_0=101.974905041");
    add_proj4text (p, 1,
        "6667 +x_0=3673.785 +y_0=-4240.573 +ellps=GRS80 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDM2000 / Sembilan and Melaka Grid\",GEOGCS[\"G");
    add_srs_wkt (p, 1,
        "DM2000\",DATUM[\"Geodetic_Datum_of_Malaysia_2000\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6742\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 6,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4742\"]],PROJECTION[\"Cassini_Soldner\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",2.682347636111111],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",101.9749050416667],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",3673.785],PARAMETER[\"false_northing\",-4240.5");
    add_srs_wkt (p, 11,
        "73],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"3378\"]]");
    p = add_epsg_def_ex (filter, first, last, 3379, "epsg", 3379,
        "GDM2000 / PahangGrid", 0, 0,
        "GRS 1980", "Greenwich",
        "Geodetic_Datum_of_Malaysia_2000", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=3.769388088888889 +lon_0=102.368298983");
    add_proj4text (p, 1,
        "3333 +x_0=-7368.228 +y_0=6485.858 +ellps=GRS80 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDM2000 / PahangGrid\",GEOGCS[\"GDM2000\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Geodetic_Datum_of_Malaysia_2000\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6742\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 6,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4742\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Cassini_Soldner\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 8,
        "of_origin\",3.769388088888889],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",102.3682989833333],PARAMETER[\"false_easting\",-73");
    add_srs_wkt (p, 10,
        "68.228],PARAMETER[\"false_northing\",6485.858],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3379\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 3380, "epsg", 3380,
        "GDM2000 / Selangor Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "Geodetic_Datum_of_Malaysia_2000", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=3.68464905 +lon_0=101.3891079138889 +x");
    add_proj4text (p, 1,
        "_0=-34836.161 +y_0=56464.049 +ellps=GRS80 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDM2000 / Selangor Grid\",GEOGCS[\"GDM2000\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Geodetic_Datum_of_Malaysia_2000\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6742\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 6,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"474");
    add_srs_wkt (p, 7,
        "2\"]],PROJECTION[\"Cassini_Soldner\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",3.68464905],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",101.3891079138889],PARAMETER[\"false_easting\",-34836.1");
    add_srs_wkt (p, 10,
        "61],PARAMETER[\"false_northing\",56464.049],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3380\"]]");
    p = add_epsg_def_ex (filter, first, last, 3381, "epsg", 3381,
        "GDM2000 / Terengganu Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "Geodetic_Datum_of_Malaysia_2000", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=4.9762852 +lon_0=103.070275625 +x_0=19");
    add_proj4text (p, 1,
        "594.245 +y_0=3371.895 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDM2000 / Terengganu Grid\",GEOGCS[\"GDM2000\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Geodetic_Datum_of_Malaysia_2000\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6742\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 7,
        "42\"]],PROJECTION[\"Cassini_Soldner\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",4.9762852],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",103.070275625],PARAMETER[\"false_easting\",19594.245],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",3371.895],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3381\"]]");
    p = add_epsg_def_ex (filter, first, last, 3382, "epsg", 3382,
        "GDM2000 / Pinang Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "Geodetic_Datum_of_Malaysia_2000", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=5.421517541666667 +lon_0=100.344376963");
    add_proj4text (p, 1,
        "8889 +x_0=-23.414 +y_0=62.283 +ellps=GRS80 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDM2000 / Pinang Grid\",GEOGCS[\"GDM2000\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geodetic_Datum_of_Malaysia_2000\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 2,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6742\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NO");
    add_srs_wkt (p, 6,
        "RTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4742\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Cassini_Soldner\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 8,
        "of_origin\",5.421517541666667],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",100.3443769638889],PARAMETER[\"false_easting\",-23");
    add_srs_wkt (p, 10,
        ".414],PARAMETER[\"false_northing\",62.283],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3382\"]]");
    p = add_epsg_def_ex (filter, first, last, 3383, "epsg", 3383,
        "GDM2000 / Kedah and Perlis Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "Geodetic_Datum_of_Malaysia_2000", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=5.964672713888889 +lon_0=100.636371111");
    add_proj4text (p, 1,
        "1111 +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDM2000 / Kedah and Perlis Grid\",GEOGCS[\"GDM2");
    add_srs_wkt (p, 1,
        "000\",DATUM[\"Geodetic_Datum_of_Malaysia_2000\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6742\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 6,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4742\"]],PROJECTION[\"Cassini_Soldner\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",5.964672713888889],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",100.6363711111111],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3383\"]]");
    p = add_epsg_def_ex (filter, first, last, 3384, "epsg", 3384,
        "GDM2000 / Perak Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "Geodetic_Datum_of_Malaysia_2000", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=4.859063022222222 +lon_0=100.815410586");
    add_proj4text (p, 1,
        "1111 +x_0=-1.769 +y_0=133454.779 +ellps=GRS80 +units=m +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDM2000 / Perak Grid\",GEOGCS[\"GDM2000\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Geodetic_Datum_of_Malaysia_2000\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6742\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 6,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4742\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Cassini_Soldner\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 8,
        "of_origin\",4.859063022222222],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",100.8154105861111],PARAMETER[\"false_easting\",-1.");
    add_srs_wkt (p, 10,
        "769],PARAMETER[\"false_northing\",133454.779],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3384\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 3385, "epsg", 3385,
        "GDM2000 / Kelantan Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "Geodetic_Datum_of_Malaysia_2000", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=5.972543658333334 +lon_0=102.295241669");
    add_proj4text (p, 1,
        "4444 +x_0=13227.851 +y_0=8739.894 +ellps=GRS80 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDM2000 / Kelantan Grid\",GEOGCS[\"GDM2000\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Geodetic_Datum_of_Malaysia_2000\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6742\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 6,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"474");
    add_srs_wkt (p, 7,
        "2\"]],PROJECTION[\"Cassini_Soldner\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",5.972543658333334],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",102.2952416694444],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "13227.851],PARAMETER[\"false_northing\",8739.894],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"338");
    add_srs_wkt (p, 13,
        "5\"]]");
    p = add_epsg_def_ex (filter, first, last, 3386, "epsg", 3386,
        "KKJ / Finland zone 0", 0, 1,
        "International 1924", "Greenwich",
        "Kartastokoordinaattijarjestelma_1966", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.345");
    add_proj4text (p, 2,
        ",-1.376,1.496 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"KKJ / Finland zone 0\",GEOGCS[\"KKJ\",DATUM[\"K");
    add_srs_wkt (p, 1,
        "artastokoordinaattijarjestelma_1966\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.49");
    add_srs_wkt (p, 4,
        "6],AUTHORITY[\"EPSG\",\"6123\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 8,
        "23\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",18");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXI");
    add_srs_wkt (p, 13,
        "S[\"Y\",EAST],AUTHORITY[\"EPSG\",\"3386\"]]");
    p = add_epsg_def_ex (filter, first, last, 3387, "epsg", 3387,
        "KKJ / Finland zone 5", 0, 1,
        "International 1924", "Greenwich",
        "Kartastokoordinaattijarjestelma_1966", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.34");
    add_proj4text (p, 2,
        "5,-1.376,1.496 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"KKJ / Finland zone 5\",GEOGCS[\"KKJ\",DATUM[\"K");
    add_srs_wkt (p, 1,
        "artastokoordinaattijarjestelma_1966\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.49");
    add_srs_wkt (p, 4,
        "6],AUTHORITY[\"EPSG\",\"6123\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 8,
        "23\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",33");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",5500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 12,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 13,
        "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"3387\"]]");
    p = add_epsg_def_ex (filter, first, last, 3388, "epsg", 3388,
        "Pulkovo 1942 / Caspian Sea Mercator", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Mercator_2SP", "metre",
        "none", "North", "none", "East");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=51 +lat_ts=42 +x_0=0 +y_0=0 +ellps=kra");
    add_proj4text (p, 1,
        "ss +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Caspian Sea Mercator\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Mercator_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 9,
        ",42],PARAMETER[\"central_meridian\",51],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"none\",NORT");
    add_srs_wkt (p, 12,
        "H],AXIS[\"none\",EAST],AUTHORITY[\"EPSG\",\"3388\"]]");
    p = add_epsg_def_ex (filter, first, last, 3389, "epsg", 3389,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 60", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=60500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 60\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",180],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",60500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[");
    add_srs_wkt (p, 13,
        "\"Y\",EAST],AUTHORITY[\"EPSG\",\"3389\"]]");
    p = add_epsg_def_ex (filter, first, last, 3390, "epsg", 3390,
        "Pulkovo 1995 / 3-degree Gauss-Kruger zone 60", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=60500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 60\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",180],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",6");
    add_srs_wkt (p, 11,
        "0500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"3390\"]]");
    p = add_epsg_def_ex (filter, first, last, 3391, "epsg", 3391,
        "Karbala 1979 / UTM zone 37N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Karbala_1979", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=clrk80 +towgs84=70.995,-335.91");
    add_proj4text (p, 1,
        "6,262.898,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Karbala 1979 / UTM zone 37N\",GEOGCS[\"Karbala ");
    add_srs_wkt (p, 1,
        "1979\",DATUM[\"Karbala_1979\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[70.995,-335.916,262.898,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6743\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 7,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"4743\"]],PROJECTION[\"");
    add_srs_wkt (p, 8,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"central_meridian\",39],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"3391\"]]");
    p = add_epsg_def_ex (filter, first, last, 3392, "epsg", 3392,
        "Karbala 1979 / UTM zone 38N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Karbala_1979", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=clrk80 +towgs84=70.995,-335.91");
    add_proj4text (p, 1,
        "6,262.898,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Karbala 1979 / UTM zone 38N\",GEOGCS[\"Karbala ");
    add_srs_wkt (p, 1,
        "1979\",DATUM[\"Karbala_1979\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[70.995,-335.916,262.898,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6743\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 7,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"4743\"]],PROJECTION[\"");
    add_srs_wkt (p, 8,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"central_meridian\",45],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"3392\"]]");
    p = add_epsg_def_ex (filter, first, last, 3393, "epsg", 3393,
        "Karbala 1979 / UTM zone 39N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Karbala_1979", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=clrk80 +towgs84=70.995,-335.91");
    add_proj4text (p, 1,
        "6,262.898,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Karbala 1979 / UTM zone 39N\",GEOGCS[\"Karbala ");
    add_srs_wkt (p, 1,
        "1979\",DATUM[\"Karbala_1979\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[70.995,-335.916,262.898,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6743\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 7,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"4743\"]],PROJECTION[\"");
    add_srs_wkt (p, 8,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"central_meridian\",51],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"3393\"]]");
    p = add_epsg_def_ex (filter, first, last, 3394, "epsg", 3394,
        "Nahrwan 1934 / Iraq zone", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nahrwan_1934", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=45 +k_0=0.99878");
    add_proj4text (p, 1,
        "64078000001 +x_0=1500000 +y_0=1166200 +ellps=clrk80 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nahrwan 1934 / Iraq zone\",GEOGCS[\"Nahrwan 193");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"Nahrwan_1934\",SPHEROID[\"Clarke 1880 (RGS)\"");
    add_srs_wkt (p, 2,
        ",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6744\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 6,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4744\"]],P");
    add_srs_wkt (p, 7,
        "ROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",32.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",45],PARAMETER[\"scale_factor\",0.9987864078],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",1500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "1166200],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"3394\"]]");
    p = add_epsg_def_ex (filter, first, last, 3395, "epsg", 3395,
        "WGS 84 / World Mercator", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Mercator_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=0 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +uni");
    add_proj4text (p, 1,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / World Mercator\",GEOGCS[\"WGS 84\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.25722356");
    add_srs_wkt (p, 2,
        "3,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"632");
    add_srs_wkt (p, 3,
        "6\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Mercato");
    add_srs_wkt (p, 7,
        "r_1SP\"],PARAMETER[\"central_meridian\",0],PARAMETER[\"s");
    add_srs_wkt (p, 8,
        "cale_factor\",1],PARAMETER[\"false_easting\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 10,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AUTHORITY[\"EPSG\",\"3395\"]]");
    p = add_epsg_def_ex (filter, first, last, 3396, "epsg", 3396,
        "PD/83 / 3-degree Gauss-Kruger zone 3", 0, 1,
        "Bessel 1841", "Greenwich",
        "Potsdam_Datum_83", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PD/83 / 3-degree Gauss-Kruger zone 3\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "PD/83\",DATUM[\"Potsdam_Datum_83\",SPHEROID[\"Bessel 184");
    add_srs_wkt (p, 2,
        "1\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6746\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 6,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"474");
    add_srs_wkt (p, 7,
        "6\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",9],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",3500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[");
    add_srs_wkt (p, 12,
        "\"Y\",EAST],AUTHORITY[\"EPSG\",\"3396\"]]");
    p = add_epsg_def_ex (filter, first, last, 3397, "epsg", 3397,
        "PD/83 / 3-degree Gauss-Kruger zone 4", 0, 1,
        "Bessel 1841", "Greenwich",
        "Potsdam_Datum_83", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PD/83 / 3-degree Gauss-Kruger zone 4\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "PD/83\",DATUM[\"Potsdam_Datum_83\",SPHEROID[\"Bessel 184");
    add_srs_wkt (p, 2,
        "1\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6746\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 6,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"474");
    add_srs_wkt (p, 7,
        "6\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",12]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",4500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXI");
    add_srs_wkt (p, 12,
        "S[\"Y\",EAST],AUTHORITY[\"EPSG\",\"3397\"]]");
    p = add_epsg_def_ex (filter, first, last, 3398, "epsg", 3398,
        "RD/83 / 3-degree Gauss-Kruger zone 4", 0, 1,
        "Bessel 1841", "Greenwich",
        "Rauenberg_Datum_83", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RD/83 / 3-degree Gauss-Kruger zone 4\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "RD/83\",DATUM[\"Rauenberg_Datum_83\",SPHEROID[\"Bessel 1");
    add_srs_wkt (p, 2,
        "841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6745\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 7,
        "45\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",12");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",4500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"3398\"]]");
    p = add_epsg_def_ex (filter, first, last, 3399, "epsg", 3399,
        "RD/83 / 3-degree Gauss-Kruger zone 5", 0, 1,
        "Bessel 1841", "Greenwich",
        "Rauenberg_Datum_83", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RD/83 / 3-degree Gauss-Kruger zone 5\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "RD/83\",DATUM[\"Rauenberg_Datum_83\",SPHEROID[\"Bessel 1");
    add_srs_wkt (p, 2,
        "841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6745\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 7,
        "45\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",15");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",5500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"3399\"]]");
    p = add_epsg_def_ex (filter, first, last, 3400, "epsg", 3400,
        "NAD83 / Alberta 10-TM (Forest)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-115 +k=0.9992 +x_0=500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Alberta 10-TM (Forest)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-115],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 10,
        "2],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"3400\"]]");
    p = add_epsg_def_ex (filter, first, last, 3401, "epsg", 3401,
        "NAD83 / Alberta 10-TM (Resource)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-115 +k=0.9992 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Alberta 10-TM (Resource)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",-115],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 10,
        "9992],PARAMETER[\"false_easting\",0],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"3401\"]]");
    p = add_epsg_def_ex (filter, first, last, 3402, "epsg", 3402,
        "NAD83(CSRS) / Alberta 10-TM (Forest)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-115 +k=0.9992 +x_0=500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / Alberta 10-TM (Forest)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 7,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PRO");
    add_srs_wkt (p, 8,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 9,
        "_origin\",0],PARAMETER[\"central_meridian\",-115],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"scale_factor\",0.9992],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3402\"]]");
    p = add_epsg_def_ex (filter, first, last, 3403, "epsg", 3403,
        "NAD83(CSRS) / Alberta 10-TM (Resource)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-115 +k=0.9992 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / Alberta 10-TM (Resource)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 7,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],");
    add_srs_wkt (p, 8,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_origin\",0],PARAMETER[\"central_meridian\",-115],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",0.9992],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 13,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3403\"]]");
    p = add_epsg_def_ex (filter, first, last, 3404, "epsg", 3404,
        "NAD83(HARN) / North Carolina (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=33.75 +lon_0=-79 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
        "0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / North Carolina (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 7,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_1\",36.16666666666666],PARAMETER[\"standard");
    add_srs_wkt (p, 10,
        "_parallel_2\",34.33333333333334],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 11,
        "_origin\",33.75],PARAMETER[\"central_meridian\",-79],PAR");
    add_srs_wkt (p, 12,
        "AMETER[\"false_easting\",2000000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 13,
        "hing\",0],UNIT[\"US survey foot\",0.3048006096012192,AUT");
    add_srs_wkt (p, 14,
        "HORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",N");
    add_srs_wkt (p, 15,
        "ORTH],AUTHORITY[\"EPSG\",\"3404\"]]");
    p = add_epsg_def_ex (filter, first, last, 3405, "epsg", 3405,
        "VN-2000 / UTM zone 48N", 0, 0,
        "WGS 84", "Greenwich",
        "Vietnam_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +ellps=WGS84 +towgs84=-192.873,-39.38");
    add_proj4text (p, 1,
        "2,-111.202,-0.00205,-0.0005,0.00335,0.0188 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / UTM zone 48N\",GEOGCS[\"VN-2000\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Vietnam_2000\",SPHEROID[\"WGS 84\",6378137,298.2572");
    add_srs_wkt (p, 2,
        "23563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[-192.873,-39");
    add_srs_wkt (p, 3,
        ".382,-111.202,-0.00205,-0.0005,0.00335,0.0188],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6756\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 7,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4756\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 9,
        "rigin\",0],PARAMETER[\"central_meridian\",105],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3405\"]]");
    p = add_epsg_def_ex (filter, first, last, 3406, "epsg", 3406,
        "VN-2000 / UTM zone 49N", 0, 0,
        "WGS 84", "Greenwich",
        "Vietnam_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +ellps=WGS84 +towgs84=-192.873,-39.38");
    add_proj4text (p, 1,
        "2,-111.202,-0.00205,-0.0005,0.00335,0.0188 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / UTM zone 49N\",GEOGCS[\"VN-2000\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Vietnam_2000\",SPHEROID[\"WGS 84\",6378137,298.2572");
    add_srs_wkt (p, 2,
        "23563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[-192.873,-39");
    add_srs_wkt (p, 3,
        ".382,-111.202,-0.00205,-0.0005,0.00335,0.0188],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6756\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 7,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4756\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 9,
        "rigin\",0],PARAMETER[\"central_meridian\",111],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3406\"]]");
    p = add_epsg_def_ex (filter, first, last, 3407, "epsg", 3407,
        "Hong Kong 1963 Grid System", 0, 1,
        "Clarke 1858", "Greenwich",
        "Hong_Kong_1963", "Cassini_Soldner", "Clarke's foot",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=22.31213333333334 +lon_0=114.178555555");
    add_proj4text (p, 1,
        "5556 +x_0=40243.57775604237 +y_0=19069.93351512578 +a=63");
    add_proj4text (p, 2,
        "78293.645208759 +b=6356617.987679838 +to_meter=0.3047972");
    add_proj4text (p, 3,
        "654 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Hong Kong 1963 Grid System\",GEOGCS[\"Hong Kong");
    add_srs_wkt (p, 1,
        " 1963\",DATUM[\"Hong_Kong_1963\",SPHEROID[\"Clarke 1858\"");
    add_srs_wkt (p, 2,
        ",6378293.645208759,294.2606763692606,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7007\"]],AUTHORITY[\"EPSG\",\"6738\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 6,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4738\"]],PROJECTION[\"Cassini_Soldner\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",22.31213333333334],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",114.1785555555556],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",132033.92],PARAMETER[\"false_northing\",62565.9");
    add_srs_wkt (p, 11,
        "6],UNIT[\"Clarke's foot\",0.3047972654,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9005\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 13,
        "ST],AUTHORITY[\"EPSG\",\"3407\"]]");
    p = add_epsg_def_ex (filter, first, last, 3408, "epsg", 3408,
        "NSIDC EASE-Grid North", 0, 0,
        "International 1924 Authalic Sphere", "Greenwich",
        "Not_specified_based_on_International_1924_Authalic_Sphere", "Lambert_Azimuthal_Equal_Area", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=6371228 +");
    add_proj4text (p, 1,
        "b=6371228 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NSIDC EASE-Grid North\",GEOGCS[\"Unspecified da");
    add_srs_wkt (p, 1,
        "tum based upon the International 1924 Authalic Sphere\",");
    add_srs_wkt (p, 2,
        "DATUM[\"Not_specified_based_on_International_1924_Authal");
    add_srs_wkt (p, 3,
        "ic_Sphere\",SPHEROID[\"International 1924 Authalic Spher");
    add_srs_wkt (p, 4,
        "e\",6371228,0,AUTHORITY[\"EPSG\",\"7057\"]],AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"6053\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 8,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4053\"]],PROJECTI");
    add_srs_wkt (p, 9,
        "ON[\"Lambert_Azimuthal_Equal_Area\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 10,
        "e_of_center\",90],PARAMETER[\"longitude_of_center\",0],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_easting\",0],PARAMETER[\"false_northing");
    add_srs_wkt (p, 12,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 13,
        "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"340");
    add_srs_wkt (p, 14,
        "8\"]]");
    p = add_epsg_def_ex (filter, first, last, 3409, "epsg", 3409,
        "NSIDC EASE-Grid South", 0, 0,
        "International 1924 Authalic Sphere", "Greenwich",
        "Not_specified_based_on_International_1924_Authalic_Sphere", "Lambert_Azimuthal_Equal_Area", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=laea +lat_0=-90 +lon_0=0 +x_0=0 +y_0=0 +a=6371228 ");
    add_proj4text (p, 1,
        "+b=6371228 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NSIDC EASE-Grid South\",GEOGCS[\"Unspecified da");
    add_srs_wkt (p, 1,
        "tum based upon the International 1924 Authalic Sphere\",");
    add_srs_wkt (p, 2,
        "DATUM[\"Not_specified_based_on_International_1924_Authal");
    add_srs_wkt (p, 3,
        "ic_Sphere\",SPHEROID[\"International 1924 Authalic Spher");
    add_srs_wkt (p, 4,
        "e\",6371228,0,AUTHORITY[\"EPSG\",\"7057\"]],AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"6053\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 8,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4053\"]],PROJECTI");
    add_srs_wkt (p, 9,
        "ON[\"Lambert_Azimuthal_Equal_Area\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 10,
        "e_of_center\",-90],PARAMETER[\"longitude_of_center\",0],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_easting\",0],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"34");
    add_srs_wkt (p, 14,
        "09\"]]");
    p = add_epsg_def_ex (filter, first, last, 3410, "epsg", 3410,
        "NSIDC EASE-Grid Global", 0, 0,
        "International 1924 Authalic Sphere", "Greenwich",
        "Not_specified_based_on_International_1924_Authalic_Sphere", "Cylindrical_Equal_Area", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=cea +lon_0=0 +lat_ts=30 +x_0=0 +y_0=0 +a=6371228 +");
    add_proj4text (p, 1,
        "b=6371228 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NSIDC EASE-Grid Global\",GEOGCS[\"Unspecified d");
    add_srs_wkt (p, 1,
        "atum based upon the International 1924 Authalic Sphere\"");
    add_srs_wkt (p, 2,
        ",DATUM[\"Not_specified_based_on_International_1924_Autha");
    add_srs_wkt (p, 3,
        "lic_Sphere\",SPHEROID[\"International 1924 Authalic Sphe");
    add_srs_wkt (p, 4,
        "re\",6371228,0,AUTHORITY[\"EPSG\",\"7057\"]],AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"6053\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 8,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4053\"]],PROJECTI");
    add_srs_wkt (p, 9,
        "ON[\"Cylindrical_Equal_Area\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 10,
        "llel_1\",30],PARAMETER[\"central_meridian\",0],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_easting\",0],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 12,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",");
    add_srs_wkt (p, 13,
        "EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3410\"]]");
    p = add_epsg_def_ex (filter, first, last, 3411, "epsg", 3411,
        "NSIDC Sea Ice Polar Stereographic North", 0, 0,
        "Hughes 1980", "Greenwich",
        "Not_specified_based_on_Hughes_1980_ellipsoid", "Polar_Stereographic", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=90 +lat_ts=70 +lon_0=-45 +k=1 +x_0=0 ");
    add_proj4text (p, 1,
        "+y_0=0 +a=6378273 +b=6356889.449 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NSIDC Sea Ice Polar Stereographic North\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"Unspecified datum based upon the Hughes 1980 ellipso");
    add_srs_wkt (p, 2,
        "id\",DATUM[\"Not_specified_based_on_Hughes_1980_ellipsoi");
    add_srs_wkt (p, 3,
        "d\",SPHEROID[\"Hughes 1980\",6378273,298.279411123064,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"7058\"]],AUTHORITY[\"EPSG\",\"6054\"]");
    add_srs_wkt (p, 5,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 6,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 7,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 8,
        "],AUTHORITY[\"EPSG\",\"4054\"]],PROJECTION[\"Polar_Stere");
    add_srs_wkt (p, 9,
        "ographic\"],PARAMETER[\"latitude_of_origin\",70],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"central_meridian\",-45],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 11,
        "1],PARAMETER[\"false_easting\",0],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 13,
        ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "3411\"]]");
    p = add_epsg_def_ex (filter, first, last, 3412, "epsg", 3412,
        "NSIDC Sea Ice Polar Stereographic South", 0, 0,
        "Hughes 1980", "Greenwich",
        "Not_specified_based_on_Hughes_1980_ellipsoid", "Polar_Stereographic", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=-90 +lat_ts=-70 +lon_0=0 +k=1 +x_0=0 ");
    add_proj4text (p, 1,
        "+y_0=0 +a=6378273 +b=6356889.449 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NSIDC Sea Ice Polar Stereographic South\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"Unspecified datum based upon the Hughes 1980 ellipso");
    add_srs_wkt (p, 2,
        "id\",DATUM[\"Not_specified_based_on_Hughes_1980_ellipsoi");
    add_srs_wkt (p, 3,
        "d\",SPHEROID[\"Hughes 1980\",6378273,298.279411123064,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"7058\"]],AUTHORITY[\"EPSG\",\"6054\"]");
    add_srs_wkt (p, 5,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 6,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 7,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 8,
        "],AUTHORITY[\"EPSG\",\"4054\"]],PROJECTION[\"Polar_Stere");
    add_srs_wkt (p, 9,
        "ographic\"],PARAMETER[\"latitude_of_origin\",-70],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"central_meridian\",0],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",0],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "3412\"]]");
    p = add_epsg_def_ex (filter, first, last, 3413, "epsg", 3413,
        "WGS 84 / NSIDC Sea Ice Polar Stereographic North", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Polar_Stereographic", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=90 +lat_ts=70 +lon_0=-45 +k=1 +x_0=0 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / NSIDC Sea Ice Polar Stereographic Nort");
    add_srs_wkt (p, 1,
        "h\",GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS ");
    add_srs_wkt (p, 2,
        "84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 6,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4326");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Polar_Stereographic\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",70],PARAMETER[\"central_meridian\",-45");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"3413\"]]");
    p = add_epsg_def_ex (filter, first, last, 3414, "epsg", 3414,
        "SVY21 / Singapore TM", 0, 1,
        "WGS 84", "Greenwich",
        "SVY21", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=1.366666666666667 +lon_0=103.83333333");
    add_proj4text (p, 1,
        "33333 +k=1 +x_0=28001.642 +y_0=38744.572 +ellps=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SVY21 / Singapore TM\",GEOGCS[\"SVY21\",DATUM[\"");
    add_srs_wkt (p, 1,
        "SVY21\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6757\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4757\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",1.36666666666666");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"central_meridian\",103.8333333333333],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 10,
        "8001.642],PARAMETER[\"false_northing\",38744.572],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"3414");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 3415, "epsg", 3415,
        "WGS 72BE / South China Sea Lambert", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_1972_Transit_Broadcast_Ephemeris", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=18 +lat_2=24 +lat_0=21 +lon_0=114 +x_0=");
    add_proj4text (p, 1,
        "500000 +y_0=500000 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 2,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / South China Sea Lambert\",GEOGCS[\"W");
    add_srs_wkt (p, 1,
        "GS 72BE\",DATUM[\"WGS_1972_Transit_Broadcast_Ephemeris\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7043\"]],TOWGS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_1\",18],PARAMETER[\"standard_parallel_2\",24],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"latitude_of_origin\",21],PARAMETER[\"central_me");
    add_srs_wkt (p, 11,
        "ridian\",114],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 12,
        "TER[\"false_northing\",500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 14,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"3415\"]]");
    p = add_epsg_def_ex (filter, first, last, 3416, "epsg", 3416,
        "ETRS89 / Austria Lambert", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49 +lat_2=46 +lat_0=47.5 +lon_0=13.3333");
    add_proj4text (p, 1,
        "3333333333 +x_0=400000 +y_0=400000 +ellps=GRS80 +towgs84");
    add_proj4text (p, 2,
        "=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / Austria Lambert\",GEOGCS[\"ETRS89\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"European_Terrestrial_Reference_System_1989\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 8,
        "ert_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_1\",49],PARAMETER[\"standard_parallel_2\",46],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"latitude_of_origin\",47.5],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 11,
        "an\",13.33333333333333],PARAMETER[\"false_easting\",4000");
    add_srs_wkt (p, 12,
        "00],PARAMETER[\"false_northing\",400000],UNIT[\"metre\",");
    add_srs_wkt (p, 13,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 14,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"3416\"]]");
    p = add_epsg_def_ex (filter, first, last, 3417, "epsg", 3417,
        "NAD83 / Iowa North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=41.5 +lon_0=-93.5 +x_0=1500000 +y_0=999999.99");
    add_proj4text (p, 2,
        "99898402 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-f");
    add_proj4text (p, 3,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Iowa North (ftUS)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "XIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Co");
    add_srs_wkt (p, 8,
        "nic_2SP\"],PARAMETER[\"standard_parallel_1\",43.26666666");
    add_srs_wkt (p, 9,
        "666667],PARAMETER[\"standard_parallel_2\",42.06666666666");
    add_srs_wkt (p, 10,
        "667],PARAMETER[\"latitude_of_origin\",41.5],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "central_meridian\",-93.5],PARAMETER[\"false_easting\",49");
    add_srs_wkt (p, 12,
        "21250],PARAMETER[\"false_northing\",3280833.333300001],U");
    add_srs_wkt (p, 13,
        "NIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EP");
    add_srs_wkt (p, 14,
        "SG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 15,
        "RITY[\"EPSG\",\"3417\"]]");
    p = add_epsg_def_ex (filter, first, last, 3418, "epsg", 3418,
        "NAD83 / Iowa South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666");
    add_proj4text (p, 1,
        "667 +lat_0=40 +lon_0=-93.5 +x_0=500000.00001016 +y_0=0 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Iowa South (ftUS)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "XIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Co");
    add_srs_wkt (p, 8,
        "nic_2SP\"],PARAMETER[\"standard_parallel_1\",41.78333333");
    add_srs_wkt (p, 9,
        "333333],PARAMETER[\"standard_parallel_2\",40.61666666666");
    add_srs_wkt (p, 10,
        "667],PARAMETER[\"latitude_of_origin\",40],PARAMETER[\"ce");
    add_srs_wkt (p, 11,
        "ntral_meridian\",-93.5],PARAMETER[\"false_easting\",1640");
    add_srs_wkt (p, 12,
        "416.6667],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 13,
        "ey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 14,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 15,
        ",\"3418\"]]");
    p = add_epsg_def_ex (filter, first, last, 3419, "epsg", 3419,
        "NAD83 / Kansas North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=399999.9999");
    add_proj4text (p, 2,
        "8984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=u");
    add_proj4text (p, 3,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Kansas North (ftUS)\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 8,
        "onic_2SP\"],PARAMETER[\"standard_parallel_1\",39.7833333");
    add_srs_wkt (p, 9,
        "3333333],PARAMETER[\"standard_parallel_2\",38.7166666666");
    add_srs_wkt (p, 10,
        "6667],PARAMETER[\"latitude_of_origin\",38.33333333333334");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"central_meridian\",-98],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "easting\",1312333.3333],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 13,
        "UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 15,
        "ORITY[\"EPSG\",\"3419\"]]");
    p = add_epsg_def_ex (filter, first, last, 3420, "epsg", 3420,
        "NAD83 / Kansas South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=399999.99");
    add_proj4text (p, 2,
        "998984 +y_0=399999.99998984 +ellps=GRS80 +towgs84=0,0,0,");
    add_proj4text (p, 3,
        "0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Kansas South (ftUS)\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 8,
        "onic_2SP\"],PARAMETER[\"standard_parallel_1\",38.5666666");
    add_srs_wkt (p, 9,
        "6666667],PARAMETER[\"standard_parallel_2\",37.2666666666");
    add_srs_wkt (p, 10,
        "6667],PARAMETER[\"latitude_of_origin\",36.66666666666666");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"central_meridian\",-98.5],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_easting\",1312333.3333],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 13,
        "312333.3333],UNIT[\"US survey foot\",0.3048006096012192,");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 15,
        ",NORTH],AUTHORITY[\"EPSG\",\"3420\"]]");
    p = add_epsg_def_ex (filter, first, last, 3421, "epsg", 3421,
        "NAD83 / Nevada East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-115.5833333333333 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=200000.00001016 +y_0=8000000.000010163 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Nevada East (ftUS)\",GEOGCS[\"NAD83\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",34.75],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",-115.5833333333333],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",0.9999],PARAMETER[\"false_easting\",656166.666");
    add_srs_wkt (p, 11,
        "7],PARAMETER[\"false_northing\",26246666.66670001],UNIT[");
    add_srs_wkt (p, 12,
        "\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"3421\"]]");
    p = add_epsg_def_ex (filter, first, last, 3422, "epsg", 3422,
        "NAD83 / Nevada Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-116.6666666666667 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=500000.00001016 +y_0=6000000 +ellps=GRS80 +tow");
    add_proj4text (p, 2,
        "gs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Nevada Central (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",34.75],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",-116.6666666666667],PARAMETER[\"sca");
    add_srs_wkt (p, 10,
        "le_factor\",0.9999],PARAMETER[\"false_easting\",1640416.");
    add_srs_wkt (p, 11,
        "6667],PARAMETER[\"false_northing\",19685000],UNIT[\"US s");
    add_srs_wkt (p, 12,
        "urvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "3\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"3422\"]]");
    p = add_epsg_def_ex (filter, first, last, 3423, "epsg", 3423,
        "NAD83 / Nevada West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-118.5833333333333 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=800000.0000101599 +y_0=3999999.99998984 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Nevada West (ftUS)\",GEOGCS[\"NAD83\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",34.75],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",-118.5833333333333],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",0.9999],PARAMETER[\"false_easting\",2624666.66");
    add_srs_wkt (p, 11,
        "67],PARAMETER[\"false_northing\",13123333.3333],UNIT[\"U");
    add_srs_wkt (p, 12,
        "S survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"3423\"]]");
    p = add_epsg_def_ex (filter, first, last, 3424, "epsg", 3424,
        "NAD83 / New Jersey (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / New Jersey (ftUS)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "XIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"latitude_of_origin\",38.83333333333334],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"central_meridian\",-74.5],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 10,
        "ctor\",0.9999],PARAMETER[\"false_easting\",492125],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",0],UNIT[\"US survey foot\",0.304");
    add_srs_wkt (p, 12,
        "8006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3424\"]]");
    p = add_epsg_def_ex (filter, first, last, 3425, "epsg", 3425,
        "NAD83(HARN) / Iowa North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=41.5 +lon_0=-93.5 +x_0=1500000 +y_0=999999.99");
    add_proj4text (p, 2,
        "99898402 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-f");
    add_proj4text (p, 3,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Iowa North (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_1\",43.26666666666667],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 10,
        "lel_2\",42.06666666666667],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 11,
        "n\",41.5],PARAMETER[\"central_meridian\",-93.5],PARAMETE");
    add_srs_wkt (p, 12,
        "R[\"false_easting\",4921250],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 13,
        ",3280833.333300001],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 14,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 15,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3425\"]]");
    p = add_epsg_def_ex (filter, first, last, 3426, "epsg", 3426,
        "NAD83(HARN) / Iowa South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666");
    add_proj4text (p, 1,
        "667 +lat_0=40 +lon_0=-93.5 +x_0=500000.00001016 +y_0=0 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Iowa South (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_1\",41.78333333333333],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 10,
        "lel_2\",40.61666666666667],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 11,
        "n\",40],PARAMETER[\"central_meridian\",-93.5],PARAMETER[");
    add_srs_wkt (p, 12,
        "\"false_easting\",1640416.6667],PARAMETER[\"false_northi");
    add_srs_wkt (p, 13,
        "ng\",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 15,
        "TH],AUTHORITY[\"EPSG\",\"3426\"]]");
    p = add_epsg_def_ex (filter, first, last, 3427, "epsg", 3427,
        "NAD83(HARN) / Kansas North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=399999.9999");
    add_proj4text (p, 2,
        "8984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=u");
    add_proj4text (p, 3,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Kansas North (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 9,
        "_parallel_1\",39.78333333333333],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 10,
        "rallel_2\",38.71666666666667],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 11,
        "igin\",38.33333333333334],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 12,
        ",-98],PARAMETER[\"false_easting\",1312333.3333],PARAMETE");
    add_srs_wkt (p, 13,
        "R[\"false_northing\",0],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 14,
        "6096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST");
    add_srs_wkt (p, 15,
        "],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3427\"]]");
    p = add_epsg_def_ex (filter, first, last, 3428, "epsg", 3428,
        "NAD83(HARN) / Kansas South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=399999.99");
    add_proj4text (p, 2,
        "998984 +y_0=399999.99998984 +ellps=GRS80 +towgs84=0,0,0,");
    add_proj4text (p, 3,
        "0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Kansas South (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 9,
        "_parallel_1\",38.56666666666667],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 10,
        "rallel_2\",37.26666666666667],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 11,
        "igin\",36.66666666666666],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 12,
        ",-98.5],PARAMETER[\"false_easting\",1312333.3333],PARAME");
    add_srs_wkt (p, 13,
        "TER[\"false_northing\",1312333.3333],UNIT[\"US survey fo");
    add_srs_wkt (p, 14,
        "ot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AX");
    add_srs_wkt (p, 15,
        "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"34");
    add_srs_wkt (p, 16,
        "28\"]]");
    p = add_epsg_def_ex (filter, first, last, 3429, "epsg", 3429,
        "NAD83(HARN) / Nevada East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-115.5833333333333 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=200000.00001016 +y_0=8000000.000010163 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Nevada East (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",34.75],PARAMETER[\"central_meridian\",-115.58333333");
    add_srs_wkt (p, 10,
        "33333],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",656166.6667],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 12,
        "26246666.66670001],UNIT[\"US survey foot\",0.30480060960");
    add_srs_wkt (p, 13,
        "12192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXI");
    add_srs_wkt (p, 14,
        "S[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3429\"]]");
    p = add_epsg_def_ex (filter, first, last, 3430, "epsg", 3430,
        "NAD83(HARN) / Nevada Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-116.6666666666667 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=500000.00001016 +y_0=6000000 +ellps=GRS80 +tow");
    add_proj4text (p, 2,
        "gs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Nevada Central (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 7,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 9,
        "rigin\",34.75],PARAMETER[\"central_meridian\",-116.66666");
    add_srs_wkt (p, 10,
        "66666667],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",1640416.6667],PARAMETER[\"false_northing");
    add_srs_wkt (p, 12,
        "\",19685000],UNIT[\"US survey foot\",0.3048006096012192,");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"3430\"]]");
    p = add_epsg_def_ex (filter, first, last, 3431, "epsg", 3431,
        "NAD83(HARN) / Nevada West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-118.5833333333333 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=800000.0000101599 +y_0=3999999.99998984 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Nevada West (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",34.75],PARAMETER[\"central_meridian\",-118.58333333");
    add_srs_wkt (p, 10,
        "33333],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",2624666.6667],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",13123333.3333],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 13,
        "92,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"3431\"]]");
    p = add_epsg_def_ex (filter, first, last, 3432, "epsg", 3432,
        "NAD83(HARN) / New Jersey (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / New Jersey (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 9,
        ",38.83333333333334],PARAMETER[\"central_meridian\",-74.5");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_e");
    add_srs_wkt (p, 11,
        "asting\",492125],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 12,
        "US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"3432\"]]");
    p = add_epsg_def_ex (filter, first, last, 3433, "epsg", 3433,
        "NAD83 / Arkansas North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=399999.9999");
    add_proj4text (p, 2,
        "8984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=u");
    add_proj4text (p, 3,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Arkansas North (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 8,
        "_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",36.23333");
    add_srs_wkt (p, 9,
        "333333333],PARAMETER[\"standard_parallel_2\",34.93333333");
    add_srs_wkt (p, 10,
        "333333],PARAMETER[\"latitude_of_origin\",34.333333333333");
    add_srs_wkt (p, 11,
        "34],PARAMETER[\"central_meridian\",-92],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_easting\",1312333.3333],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 13,
        "],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"3433\"]]");
    p = add_epsg_def_ex (filter, first, last, 3434, "epsg", 3434,
        "NAD83 / Arkansas South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-92 +x_0=399999.99998984 +y_0=399");
    add_proj4text (p, 2,
        "999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 3,
        "us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Arkansas South (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 8,
        "_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",34.76666");
    add_srs_wkt (p, 9,
        "666666667],PARAMETER[\"standard_parallel_2\",33.3],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"latitude_of_origin\",32.66666666666666],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"central_meridian\",-92],PARAMETER[\"false_easting\",1");
    add_srs_wkt (p, 12,
        "312333.3333],PARAMETER[\"false_northing\",1312333.3333],");
    add_srs_wkt (p, 13,
        "UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 15,
        "ORITY[\"EPSG\",\"3434\"]]");
    p = add_epsg_def_ex (filter, first, last, 3435, "epsg", 3435,
        "NAD83 / Illinois East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333");
    add_proj4text (p, 1,
        "333333 +k=0.9999749999999999 +x_0=300000.0000000001 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_");
    add_proj4text (p, 3,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Illinois East (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",36.66666666666666");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-88.33333333333333],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",0.999975],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",984250.0000000002],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 12,
        ",UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 14,
        "HORITY[\"EPSG\",\"3435\"]]");
    p = add_epsg_def_ex (filter, first, last, 3436, "epsg", 3436,
        "NAD83 / Illinois West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999941177 +x_0=699999.9999898402 +y_0=0 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Illinois West (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",36.66666666666666");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-90.16666666666667],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",0.999941177],PARAMETER[\"false_e");
    add_srs_wkt (p, 11,
        "asting\",2296583.333300001],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"3436\"]]");
    p = add_epsg_def_ex (filter, first, last, 3437, "epsg", 3437,
        "NAD83 / New Hampshire (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-71.66666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +tow");
    add_proj4text (p, 2,
        "gs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / New Hampshire (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",42.5],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",-71.66666666666667],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",0.999966667],PARAMETER[\"false_easting\",98425");
    add_srs_wkt (p, 11,
        "0.0000000002],PARAMETER[\"false_northing\",0],UNIT[\"US ");
    add_srs_wkt (p, 12,
        "survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "03\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EP");
    add_srs_wkt (p, 14,
        "SG\",\"3437\"]]");
    p = add_epsg_def_ex (filter, first, last, 3438, "epsg", 3438,
        "NAD83 / Rhode Island (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.9");
    add_proj4text (p, 1,
        "9999375 +x_0=99999.99998983997 +y_0=0 +ellps=GRS80 +towg");
    add_proj4text (p, 2,
        "s84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Rhode Island (ftUS)\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",41.08333333333334],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",-71.5],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.99999375],PARAMETER[\"false_easting\",328083.");
    add_srs_wkt (p, 11,
        "3333],PARAMETER[\"false_northing\",0],UNIT[\"US survey f");
    add_srs_wkt (p, 12,
        "oot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 14,
        "438\"]]");
    p = add_epsg_def_ex (filter, first, last, 3439, "epsg", 3439,
        "PSD93 / UTM zone 39N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "PDO_Survey_Datum_1993", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=clrk80 +towgs84=-180.624,-225.");
    add_proj4text (p, 1,
        "516,173.919,-0.81,-1.898,8.336,16.71006 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSD93 / UTM zone 39N\",GEOGCS[\"PSD93\",DATUM[\"");
    add_srs_wkt (p, 1,
        "PDO_Survey_Datum_1993\",SPHEROID[\"Clarke 1880 (RGS)\",6");
    add_srs_wkt (p, 2,
        "378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[-180.624,-225.516,173.919,-0.81,-1.898,8.336,16.71006],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6134\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NO");
    add_srs_wkt (p, 7,
        "RTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4134\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",51],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 12,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3439\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 3440, "epsg", 3440,
        "PSD93 / UTM zone 40N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "PDO_Survey_Datum_1993", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=clrk80 +towgs84=-180.624,-225.");
    add_proj4text (p, 1,
        "516,173.919,-0.81,-1.898,8.336,16.71006 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSD93 / UTM zone 40N\",GEOGCS[\"PSD93\",DATUM[\"");
    add_srs_wkt (p, 1,
        "PDO_Survey_Datum_1993\",SPHEROID[\"Clarke 1880 (RGS)\",6");
    add_srs_wkt (p, 2,
        "378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[-180.624,-225.516,173.919,-0.81,-1.898,8.336,16.71006],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6134\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NO");
    add_srs_wkt (p, 7,
        "RTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4134\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",57],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 12,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3440\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 3441, "epsg", 3441,
        "NAD83(HARN) / Arkansas North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=399999.9999");
    add_proj4text (p, 2,
        "8984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=u");
    add_proj4text (p, 3,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Arkansas North (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 7,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_1\",36.23333333333333],PARAMETER[\"standard");
    add_srs_wkt (p, 10,
        "_parallel_2\",34.93333333333333],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 11,
        "_origin\",34.33333333333334],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 12,
        "n\",-92],PARAMETER[\"false_easting\",1312333.3333],PARAM");
    add_srs_wkt (p, 13,
        "ETER[\"false_northing\",0],UNIT[\"US survey foot\",0.304");
    add_srs_wkt (p, 14,
        "8006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 15,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3441\"]]");
    p = add_epsg_def_ex (filter, first, last, 3442, "epsg", 3442,
        "NAD83(HARN) / Arkansas South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-92 +x_0=399999.99998984 +y_0=399");
    add_proj4text (p, 2,
        "999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 3,
        "us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Arkansas South (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 7,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_1\",34.76666666666667],PARAMETER[\"standard");
    add_srs_wkt (p, 10,
        "_parallel_2\",33.3],PARAMETER[\"latitude_of_origin\",32.");
    add_srs_wkt (p, 11,
        "66666666666666],PARAMETER[\"central_meridian\",-92],PARA");
    add_srs_wkt (p, 12,
        "METER[\"false_easting\",1312333.3333],PARAMETER[\"false_");
    add_srs_wkt (p, 13,
        "northing\",1312333.3333],UNIT[\"US survey foot\",0.30480");
    add_srs_wkt (p, 14,
        "06096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAS");
    add_srs_wkt (p, 15,
        "T],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3442\"]]");
    p = add_epsg_def_ex (filter, first, last, 3443, "epsg", 3443,
        "NAD83(HARN) / Illinois East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333");
    add_proj4text (p, 1,
        "333333 +k=0.9999749999999999 +x_0=300000.0000000001 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_");
    add_proj4text (p, 3,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Illinois East (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",36.66666666666666],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",-88.33333333333333],PARAMETER[\"scale_factor\",0.999975");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",984250.0000000002],PARAMET");
    add_srs_wkt (p, 12,
        "ER[\"false_northing\",0],UNIT[\"US survey foot\",0.30480");
    add_srs_wkt (p, 13,
        "06096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAS");
    add_srs_wkt (p, 14,
        "T],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3443\"]]");
    p = add_epsg_def_ex (filter, first, last, 3444, "epsg", 3444,
        "NAD83(HARN) / Illinois West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999941177 +x_0=699999.9999898402 +y_0=0 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Illinois West (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",36.66666666666666],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",-90.16666666666667],PARAMETER[\"scale_factor\",0.999941");
    add_srs_wkt (p, 11,
        "177],PARAMETER[\"false_easting\",2296583.333300001],PARA");
    add_srs_wkt (p, 12,
        "METER[\"false_northing\",0],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 13,
        "48006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",");
    add_srs_wkt (p, 14,
        "EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3444\"]]");
    p = add_epsg_def_ex (filter, first, last, 3445, "epsg", 3445,
        "NAD83(HARN) / New Hampshire (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-71.66666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +tow");
    add_proj4text (p, 2,
        "gs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / New Hampshire (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",42.5],PARAMETER[\"central_meridian\",-71.66666666");
    add_srs_wkt (p, 10,
        "666667],PARAMETER[\"scale_factor\",0.999966667],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",984250.0000000002],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_northing\",0],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 13,
        "2,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"3445\"]]");
    p = add_epsg_def_ex (filter, first, last, 3446, "epsg", 3446,
        "NAD83(HARN) / Rhode Island (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.9");
    add_proj4text (p, 1,
        "9999375 +x_0=99999.99998983997 +y_0=0 +ellps=GRS80 +towg");
    add_proj4text (p, 2,
        "s84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Rhode Island (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",41.08333333333334],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 10,
        "71.5],PARAMETER[\"scale_factor\",0.99999375],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",328083.3333],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"3446\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

