/*
 * JPEG Q-tables.
 */

#ifndef JPEG_QTABLES_H
#define JPEG_QTABLES_H

static unsigned char qtable_creative_pccam[2][64] =
{
  { /* Q-table Y-components */
    0x05, 0x03, 0x03, 0x05, 0x07, 0x0c, 0x0f, 0x12,
    0x04, 0x04, 0x04, 0x06, 0x08, 0x11, 0x12, 0x11,
    0x04, 0x04, 0x05, 0x07, 0x0c, 0x11, 0x15, 0x11,
    0x04, 0x05, 0x07, 0x09, 0x0f, 0x1a, 0x18, 0x13,
    0x05, 0x07, 0x0b, 0x11, 0x14, 0x21, 0x1f, 0x17,
    0x07, 0x0b, 0x11, 0x13, 0x18, 0x1f, 0x22, 0x1c,
    0x0f, 0x13, 0x17, 0x1a, 0x1f, 0x24, 0x24, 0x1e,
    0x16, 0x1c, 0x1d, 0x1d, 0x22, 0x1e, 0x1f, 0x1e
  },
  { /* Q-table C-components */
    0x05, 0x05, 0x07, 0x0e, 0x1e, 0x1e, 0x1e, 0x1e,
    0x05, 0x06, 0x08, 0x14, 0x1e, 0x1e, 0x1e, 0x1e,
    0x07, 0x08, 0x11, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e,
    0x0e, 0x14, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e,
    0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e,
    0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e,
    0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e,
    0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e
  }
};

static unsigned char qtable_kodak_ez200[2][64] =
{
  { /* Q-table Y-components */
    0x02, 0x01, 0x01, 0x02, 0x02, 0x04, 0x05, 0x06,
    0x01, 0x01, 0x01, 0x02, 0x03, 0x06, 0x06, 0x06,
    0x01, 0x01, 0x02, 0x02, 0x04, 0x06, 0x07, 0x06,
    0x01, 0x02, 0x02, 0x03, 0x05, 0x09, 0x08, 0x06,
    0x02, 0x02, 0x04, 0x06, 0x07, 0x0b, 0x0a, 0x08,
    0x02, 0x04, 0x06, 0x06, 0x08, 0x0a, 0x0b, 0x09,
    0x05, 0x06, 0x08, 0x09, 0x0a, 0x0c, 0x0c, 0x0a,
    0x07, 0x09, 0x0a, 0x0a, 0x0b, 0x0a, 0x0a, 0x0a
  },
  { /* Q-table C-components */
    0x02, 0x02, 0x02, 0x05, 0x0a, 0x0a, 0x0a, 0x0a,
    0x02, 0x02, 0x03, 0x07, 0x0a, 0x0a, 0x0a, 0x0a,
    0x02, 0x03, 0x06, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a,
    0x05, 0x07, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a,
    0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a,
    0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a,
    0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a,
    0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a
  }
};

/* FIXME: This Q-table is identical to the Creative PC-CAM one,
 *        except for one byte. Possibly a typo?
 *        NWG: 18/05/2003.
 */
static unsigned char qtable_spca504_default[2][64] =
{ 
  { /* Q-table Y-components */
    0x05, 0x03, 0x03, 0x05, 0x07, 0x0c, 0x0f, 0x12,
    0x04, 0x04, 0x04, 0x06, 0x08, 0x11, 0x12, 0x11,
    0x04, 0x04, 0x05, 0x07, 0x0c, 0x11, 0x15, 0x11,
    0x04, 0x05, 0x07, 0x09, 0x0f, 0x1a, 0x18, 0x13,
    0x05, 0x07, 0x0b, 0x11, 0x14, 0x21, 0x1f, 0x17,
    0x07, 0x0b, 0x11, 0x13, 0x18, 0x1f, 0x22, 0x1c,
    0x0f, 0x13, 0x17, 0x1a, 0x1f, 0x24, 0x24, 0x1e,
    0x16, 0x1c, 0x1d, 0x1d, 0x1d /* 0x22 */, 0x1e, 0x1f, 0x1e,
  },
  { /* Q-table C-components */
    0x05, 0x05, 0x07, 0x0e, 0x1e, 0x1e, 0x1e, 0x1e,
    0x05, 0x06, 0x08, 0x14, 0x1e, 0x1e, 0x1e, 0x1e,
    0x07, 0x08, 0x11, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e,
    0x0e, 0x14, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e,
    0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e,
    0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e,
    0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e,
    0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e
  }
};

static unsigned char qtable_pocketdv[2][64] =
{ 
  { /* Q-table Y-components start registers 0x8800 */
    0x06 ,0x04 ,0x04 ,0x06 ,0x0a ,0x10 ,0x14 ,0x18 ,
    0x05 ,0x05 ,0x06 ,0x08 ,0x0a ,0x17 ,0x18 ,0x16 ,
    0x06 ,0x05 ,0x06 ,0x0a ,0x10 ,0x17 ,0x1c ,0x16 ,
    0x06 ,0x07 ,0x09 ,0x0c ,0x14 ,0x23 ,0x20 ,0x19 ,
    0x07 ,0x09 ,0x0f ,0x16 ,0x1b ,0x2c ,0x29 ,0x1f ,
    0x0a ,0x0e ,0x16 ,0x1a ,0x20 ,0x2a ,0x2d ,0x25 ,
    0x14 ,0x1a ,0x1f ,0x23 ,0x29 ,0x30 ,0x30 ,0x28 ,
    0x1d ,0x25 ,0x26 ,0x27 ,0x2d ,0x28 ,0x29 ,0x28 ,
  },
  { /* Q-table C-components start registers 0x8840 */
    0x07 ,0x07 ,0x0a ,0x13 ,0x28 ,0x28 ,0x28 ,0x28 ,
    0x07 ,0x08 ,0x0a ,0x1a ,0x28 ,0x28 ,0x28 ,0x28 ,
    0x0a ,0x0a ,0x16 ,0x28 ,0x28 ,0x28 ,0x28 ,0x28 ,
    0x13 ,0x1a ,0x28 ,0x28 ,0x28 ,0x28 ,0x28 ,0x28 ,
    0x28 ,0x28 ,0x28 ,0x28 ,0x28 ,0x28 ,0x28 ,0x28 ,
    0x28 ,0x28 ,0x28 ,0x28 ,0x28 ,0x28 ,0x28 ,0x28 ,
    0x28 ,0x28 ,0x28 ,0x28 ,0x28 ,0x28 ,0x28 ,0x28 ,
    0x28 ,0x28 ,0x28 ,0x28 ,0x28 ,0x28 ,0x28 ,0x28 
  }

};
#endif /* JPEG_QTABLES_H */
