"""Postinstallation script for Windows setup bdis_wininst.

Created in SPE (http://www.stani.be/python/spe)
GPL License
(c)2005 www.stani.be"""

####GENERAL
import os, sys, _winreg

#---Check if not run from win32 installer
try:
    create_shortcut
    RUN_FROM_INSTALLER = True
except:
    RUN_FROM_INSTALLER = False

#---System constants
PREFIX      = sys.prefix
PYTHON      = PREFIX + r'\python.exe'
PYTHONW     = PREFIX + r'\pythonw.exe'

#---File extensions
PY          = 'Python.File'
PYW         = 'Python.NoConFile'

#---Installation class
class PostInstall:
    def __init__(self):
        if RUN_FROM_INSTALLER:
            #intializing special variables
            self.appdata            = self._get_special_folder("CSIDL_APPDATA")
            self.desktop            = self._get_special_folder("CSIDL_DESKTOPDIRECTORY")
            self.common_desktop     = self._get_special_folder("CSIDL_COMMON_DESKTOPDIRECTORY")
            self.fonts              = self._get_special_folder("CSIDL_FONTS")
            self.programs           = self._get_special_folder('CSIDL_PROGRAMS')
            self.common_programs    = self._get_special_folder('CSIDL_COMMON_PROGRAMS')
            self.startmenu          = self._get_special_folder('CSIDL_STARTMENU')
            self.common_startmenu   = self._get_special_folder('CSIDL_COMMON_STARTMENU')
            self.startup            = self._get_special_folder('CSIDL_STARTUP')
            self.common_startup     = self._get_special_folder('CSIDL_COMMON_STARTUP')
        #install or remove
        if len(sys.argv) > 1:
            if sys.argv[1] == '-install':
                self.install()
            elif sys.argv[1] == '-remove':
                self.remove()
            else:
                print "Script was called with option %s" % sys.argv[1]
                
    #---To be overwritten
    def install(self):
        """Routine to be run by the win32 installer with the -install switch."""
        pass
        
    def remove(self):
        """Routine to be run by the win32 installer with the -remove switch."""
        pass
        
    #---Safer post install functions
    def create_shortcut(self,target,description,link_file,*args,**kw):
        """Make a shortcut if it doesn't exist, and register its creation."""
        if not os.path.isfile(link_file):
            create_shortcut(target, description, link_file,*args,**kw)
            file_created(link_file)
    
    def _get_special_folder(self,folder):
        try:
            return get_special_folder_path(folder)
        except:
            if folder.find('COMMON_')>-1:
                try:
                    return get_special_folder_path(folder.replace('COMMON_',''))
                except:
                    return None
            
    #---Registry functions
    def register(self,label, action, fileType='Python.File', suffix='"%1"'):
        try:
            k       = '%s\\shell\\%s'%(fileType, label)
            key     = _winreg.CreateKey(_winreg.HKEY_CLASSES_ROOT,k)
        except:
            pass
        try:
            command = '%s %s'%(action,suffix)
            _winreg.SetValue(key,"command",_winreg.REG_SZ,command)
            return key
        except:
            print 'shit'
            return False
        
    def registerPy(self,label, action, suffix='"%1"'):
        "Registering action for python (*.py,*.pyw) in windows explorer context menu."
        keyw = {
            'label'  : label,
            'action' : '"%s" "%s"'%(PYTHONW,action),
            'suffix' : suffix
        }
        py, pyw = keys\
                = (self.register(fileType=PY,**keyw),self.register(fileType=PYW,**keyw))
        if py and pyw:
            return keys
        else:
            return False
        
    def deregister(self,label, fileType='Python.File'):
        try:
            key = '%s\\shell\\%s'%(fileType,label)
            print key
            _winreg.DeleteKey(_winreg.HKEY_CLASSES_ROOT,key+'\\command')
        except:
            pass
        try:
            _winreg.DeleteKey(_winreg.HKEY_CLASSES_ROOT,key)
            return True
        except:
            return False
            
    def deregisterPy(self,label):
        self.deregister(label=label, fileType=PY)
        self.deregister(label=label, fileType=PYW)


####SPE example
from _spe import INFO

SPE_EDIT = 'Edit with Spe'

class SpePostInstall(PostInstall):
    #---Install & uninstall
    def install(self):
        """Routine to be run by the win32 installer with the -install switch."""
        
        print '\nThank you for choosing SPE!\n\n%s\n'%INFO['contribute']
    
        #initialize
        location    = INFO['location']
        app         = os.path.join(location,'SPE.py')
        icon        = os.path.join(location,'skins','default','favicon.ico')
        title       = "Stani's Python Editor"
        
        if RUN_FROM_INSTALLER:
            # Create shortcuts
    
            # Lookup user paths ...
            programs    = os.path.join(self.common_programs,title)
            plugins     = os.path.join(programs,'Plugins')
        
            # Create SPE entry ...
            if not os.path.isdir(programs):
                os.mkdir(programs)
                directory_created(programs)
        
            if not os.path.isdir(plugins):
                os.mkdir(plugins)
                directory_created(plugins)
        
            # Create SPE self.common_desktop shortcuts
            f           = os.path.join(self.common_desktop, title+".lnk")
            self.create_shortcut(PYTHON,INFO['url'],f,app,'',icon)
        
            # Create SPE program shortcuts ...
            f           = os.path.join(programs, "SPE.lnk")
            self.create_shortcut(PYTHON,title,f,app,'',icon)
        
            target      = os.path.join(location,'SPE.py --debug')
            f           = os.path.join(programs, "SPE (debug mode).lnk")
            self.create_shortcut(PYTHON,"Use this to report errors ",f,target,'',icon)
        
            target      = os.path.join(location,'doc','manual.pdf')
            f           = os.path.join(programs, "Manual.lnk")
            self.create_shortcut(target,"Manual",f)
        
            target      = os.path.join(location,'doc','manual.odt')
            f           = os.path.join(programs, "Manual (Open Office 2.0 source).lnk")
            self.create_shortcut(target,"Use this for contributions or translations to the manual.",f)
        
            target      = os.path.join(location,'doc','donate.html')
            f           = os.path.join(programs, "Donate (thanks!).lnk")
            self.create_shortcut(target,INFO['donate'],f)
            
            f           = os.path.join(programs, "Homepage (check for updates).lnk")
            self.create_shortcut(INFO['url'],INFO['url'],f)
        
            f           = os.path.join(programs, "Author.lnk")
            self.create_shortcut('http://www.stani.be','My portfolio',f)
        
            f           = os.path.join(programs, "Mailing Lists.lnk")
            self.create_shortcut('http://www.stani.be/python/spe/page_mailman','Please subscribe...',f)
        
            # Create program shortcuts for plugins
            target      = os.path.join(location,'plugins','kiki','kiki.py')
            i           = os.path.join(location,'plugins','kiki','kiki.ico')
            f           = os.path.join(plugins, "Kiki (Regular Expression Console).lnk")
            self.create_shortcut(PYTHONW,"http://come.to/project5",f,target,'',i)    
        
            target      = os.path.join(location,'plugins','wxGlade','wxglade.py')
            i           = os.path.join(location,'plugins','wxGlade','icons','wxglade.ico')
            f           = os.path.join(plugins, "wxGlade (wxPython Gui Designer).lnk")
            self.create_shortcut(PYTHONW,"http://wxglade.sourceforge.net",f,target,'',i)    
        
            target      = os.path.join(location,'plugins','winpdb','_winpdb.py -t')
            f           = os.path.join(plugins, "WinPDB (Remote Debugger).lnk")
            self.create_shortcut(PYTHONW,"http://www.digitalpeers.com/pythondebugger/",f,target)    
        
            target      = os.path.join(location,'plugins','winpdb','_winpdb.py -t')
            f           = os.path.join(plugins, "WinPDB (Remote Debugger - encrypted).lnk")
            self.create_shortcut(PYTHONW,"http://www.digitalpeers.com/pythondebugger/",f,target)
            
            print 'Created shortcuts on desktop and start menu.'    

        # Create registry keys
        
        #removing previous registry keys
        self.deregisterPy(SPE_EDIT)
        
        #installing new registry keys
        if self.registerPy(SPE_EDIT, app):
            print "Registered SPE in windows explorer context menu."
        else:
            print "Could not register SPE in windows explorer context menu."
    
    def remove(self):
        """Routine to be run by the win32 installer with the -remove switch."""
        self.deregisterPy(SPE_EDIT)

SpePostInstall()