#include <stdio.h>
#include <gtk/gtk.h>

#include "patch.h"
#include "gui.h"
#include "specimen.h"

static GtkWidget *window;
static GtkWidget *filter_spin;
static GtkWidget *reso_spin;

static GtkAdjustment *filter_adj;
static GtkAdjustment *reso_adj;

static void cb_filter(GtkWidget *adj, gpointer data)
{
     int val;
     int cp;

     if ((cp = get_current_patch()) < 0)
	  return;

     val = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(filter_spin));
     if (patch_cutoff_set(cp, val / 100.0) < 0) {
	  errmsg("Failed to set patch %d filter to %.3f\n", cp, val/100.0);
	  return;
     }

     return;
}

static void cb_reso(GtkWidget *adj, gpointer data)
{
     int val;
     int cp;

     if ((cp = get_current_patch()) < 0)
	  return;

     val = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(reso_spin));
     if (patch_resonance_set(cp, val / 100.0) < 0) {
	  errmsg("Failed to set patch %d resonance to %.3f\n", cp, val/100.0);
	  return;
     }

     return;
}

static void cb_close()
{
     gtk_widget_hide(window);
}

void filter_settings_show()
{
     float f, r;
     int cp;

     if ((cp = get_current_patch()) < 0)
	  return;

     f = patch_cutoff_get(cp);
     r = patch_resonance_get(cp);

     gtk_spin_button_set_value(GTK_SPIN_BUTTON(filter_spin), f * 100);
     gtk_spin_button_set_value(GTK_SPIN_BUTTON(reso_spin), r * 100);
     gtk_widget_show(window);
}

void filter_settings_init(GtkWidget *parent)
{
     GtkWidget *vbox, *hbox;
     GtkWidget *button;
     GtkWidget *label;
     GtkWidget *sep;

     /* main window */
     window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
     gtk_window_set_title(GTK_WINDOW(window), "Filter");
     gtk_window_set_resizable(GTK_WINDOW(window), FALSE);
     gtk_window_set_transient_for(GTK_WINDOW(window), GTK_WINDOW(parent));
     gtk_window_set_modal(GTK_WINDOW(window), TRUE);
     g_signal_connect(GTK_WINDOW(window), "delete-event", G_CALLBACK(cb_close), NULL);

     /* vbox */
     vbox = gtk_vbox_new(FALSE, SPACING);
     gtk_container_add(GTK_CONTAINER(window), vbox);
     gtk_container_set_border_width(GTK_CONTAINER(window), SPACING);
     gtk_widget_show(vbox);

     /* hbox */
     hbox = gtk_hbox_new(FALSE, SPACING);
     gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
     gtk_widget_show(hbox);

     /* filter */
     label = gtk_label_new("Frequency:");
     gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
     gtk_widget_show(label);

     filter_adj = (GtkAdjustment *)gtk_adjustment_new(100, 0, 100, 1, 0, 0);
     filter_spin = gtk_spin_button_new(filter_adj, 0, 0);
     g_signal_connect(G_OBJECT(filter_adj), "value-changed", G_CALLBACK(cb_filter), NULL);
     gtk_box_pack_end(GTK_BOX(hbox), filter_spin, FALSE, FALSE, 0);
     gtk_widget_show(filter_spin);

     /* hbox */
     hbox = gtk_hbox_new(FALSE, SPACING);
     gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
     gtk_widget_show(hbox);

     /* resonance */
     label = gtk_label_new("Resonance:");
     gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
     gtk_widget_show(label);

     reso_adj = (GtkAdjustment *)gtk_adjustment_new(0, 0, 100, 1, 0, 0);
     reso_spin = gtk_spin_button_new(reso_adj, 0, 0);
     g_signal_connect(G_OBJECT(reso_adj), "value-changed", G_CALLBACK(cb_reso), NULL);
     gtk_box_pack_end(GTK_BOX(hbox), reso_spin, FALSE, FALSE, 0);
     gtk_widget_show(reso_spin);

     /**************/
     sep = gtk_hseparator_new();
     gtk_box_pack_start(GTK_BOX(vbox), sep, FALSE, FALSE, 0);
     gtk_widget_show(sep);
     
     /* hbox */
     hbox = gtk_hbox_new(FALSE, SPACING);
     gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
     gtk_widget_show(hbox);

     /* close button */
     button = gtk_button_new_from_stock(GTK_STOCK_CLOSE);
     g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(cb_close), NULL);
     gtk_box_pack_end(GTK_BOX(hbox), button, FALSE, FALSE, 0);
     gtk_widget_show(button);
}

     

	  
