var targetURL;
var selectionBox;
var selectionStartX;
var selectionStartY;
var selectionEndX;
var selectionEndY;
var mainArea;
var isSelecting = false;
var cropSelected;
var makeSelectionVisibleWhenLoaded = false;

function Startup() {
  targetURL = window.arguments[0];
  cropSelected = window.arguments[1];
  var initialCropX = window.arguments[2];
  var initialCropY = window.arguments[3];
  var initialCropWidth = window.arguments[4];
  var initialCropHeight = window.arguments[5];
  
  document.getElementById("selectionAreaColor").color = "#000000";
  document.getElementById("selectionAreaColorText").value = document.getElementById("selectionAreaColor").color;
  selectionBox = document.getElementById("selection-box");
  selectionBox.style.borderColor = document.getElementById("selectionAreaColor").color;
  mainArea = document.getElementById("cropCanvas");
  
  // Capture thumbnail
  var wm = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(Components.interfaces.nsIWindowMediator);
  var windowIter = wm.getEnumerator('navigator:browser');
  
  if (windowIter.hasMoreElements()) {
    var firstWindow = windowIter.getNext();
    firstWindow.SpeedDial.thumbnailGenerationListeners.push(window);
    firstWindow.SpeedDial.addPrioritySchedule(0);
  }

  // Register observers
  mainArea.addEventListener("mousedown", selectionBoxStart, false);
  mainArea.addEventListener("mouseup", selectionBoxEnd, false);
  mainArea.addEventListener("mouseout", selectionBoxOut, false);
  mainArea.addEventListener("mousemove", selectionBoxCheck, false);
  
  if (cropSelected) {
    makeSelectionVisibleWhenLoaded = true;
    selectionStartX = parseInt(initialCropX);
    selectionStartY = parseInt(initialCropY);
    selectionEndX = selectionStartX + parseInt(initialCropWidth);
    selectionEndY = selectionStartY + parseInt(initialCropHeight);
    setTimeout(refreshSelectionBox, 0);
  }
}

function refreshSelectionBox() {
    selectionBox.setAttribute("top", selectionStartY);
    selectionBox.setAttribute("left", selectionStartX);
    setSize(selectionBox, selectionEndX - selectionStartX, selectionEndY - selectionStartY);
}

function Unload() {
  mainArea.removeEventListener("mousedown", selectionBoxStart, false);
  mainArea.removeEventListener("mouseup", selectionBoxEnd, false);
  mainArea.removeEventListener("mouseout", selectionBoxOut, false);
  mainArea.removeEventListener("mousemove", selectionBoxCheck, false);
}

function onOK(event) {
  if (selectionBox.hasAttribute("hidden")) {
    var bundle = document.getElementById("bundle_cropSelector");
    alert(bundle.getString("noCropArea.warning"));
    return false;
  }
  var leftOffset, cropWidth;
  if (selectionStartX < selectionEndX) {
    leftOffset = selectionStartX;
    cropWidth = selectionEndX - selectionStartX;
  } else {
    leftOffset = selectionEndX;
    cropWidth = selectionStartX - selectionEndX;
  }
  var topOffset, cropHeight;
  if (selectionStartY < selectionEndY) {
    topOffset = selectionStartY;
    cropHeight = selectionEndY - selectionStartY;
  } else {
    topOffset = selectionEndY;
    cropHeight = selectionStartY - selectionEndY;
  }
  window.opener.setCropData(leftOffset, topOffset, cropWidth, cropHeight);

  return true;
}

function onCancel(event) {
  return true;
}

function selectionBoxStart(e) {
  if (e.button != 0) {
    return;
  }

  if (selectionBox.hasAttribute("hidden")) {
    selectionBox.removeAttribute("hidden");
  }

  selectionStartX = e.layerX;
  selectionStartY = e.layerY;
  selectionEndX = e.layerX;
  selectionEndY = e.layerY;
  selectionBox.setAttribute("top", selectionStartY);
  selectionBox.setAttribute("left", selectionStartX);
  setSize(selectionBox, 0, 0);
  isSelecting = true;
}

function selectionBoxEnd(e) {
  if (e.button != 0) {
    return;
  }
  isSelecting = false;
}

function selectionBoxOut(el) {
  if (selectionBox.hasAttribute("hidden")) return;

  var hasExited = (el.relatedTarget != el.currentTarget);
  var currentNode = el.relatedTarget;

  if (currentNode) {
    while (hasExited && currentNode.parentNode) {
      hasExited = ((el.currentTarget != currentNode.parentNode) && (currentNode.localName != "tooltip"));
      currentNode = currentNode.parentNode;
    }
  }

  if (hasExited) {
    if (!selectionBox.hasAttribute("hidden") && isSelecting)
      endSelection();
  }
}

function selectionBoxCheck(e) {
  if (e.button != 0) {
    return;
  }
  if (selectionBox.hasAttribute("hidden") || !isSelecting) {
    return;
  }

  var newWidth, newHeight;
  if (e.layerX < selectionStartX) {
    selectionBox.setAttribute("left", e.layerX);
    newWidth = selectionStartX - e.layerX;
  } else {
    selectionBox.setAttribute("left", selectionStartX);
    newWidth = e.layerX - selectionStartX - 1;
  }

  if (e.layerY < selectionStartY) {
    selectionBox.setAttribute("top", e.layerY);
    newHeight = selectionStartY - e.layerY;
  } else {
    selectionBox.setAttribute("top", selectionStartY);
    newHeight = e.layerY - selectionStartY - 1;
  }
  setSize(selectionBox, newWidth, newHeight);

  selectionEndX = e.layerX;
  selectionEndY = e.layerY;
}

function selectionAreaColorChanged() {
  var selectionAreaColorText = document.getElementById("selectionAreaColorText");
  var selectionAreaColor = document.getElementById("selectionAreaColor");
  
  if (selectionAreaColorText.value != selectionAreaColor.color) {
    selectionAreaColorText.value = selectionAreaColor.color;
  }
  
  // Refresh border color
  selectionBox.style.borderColor = selectionAreaColor.color;
}

function selectionAreaColorTextChanged() {
  var selectionAreaColorText = document.getElementById("selectionAreaColorText");
  var selectionAreaColor = document.getElementById("selectionAreaColor");
  
  if (selectionAreaColorText.value != selectionAreaColor.color) {
    selectionAreaColor.color = selectionAreaColorText.value;
  }
  
  // Refresh border color
  selectionBox.style.borderColor = selectionAreaColorText.value;
}

function endSelection() {
  if (!selectionBox.hasAttribute("hidden")) {
    selectionBox.setAttribute("hidden", true);
  }
  isSelecting = false;
}

// Call functions from thumbnail generator
function getTargetURL() {
  return targetURL;
}

function getTargetCanvas() {
  return document.getElementById("cropCanvas");
}

function thumbnailLoadError() {
  document.getElementById("cropCanvas").style.display = "none";
  document.getElementById("loadingMessage").style.display = "none";
  document.getElementById("errorMessage").style.display = "block";
}

function thumbnailLoadCompleted() {
  if ((makeSelectionVisibleWhenLoaded) && (selectionBox.hasAttribute("hidden"))) {
    selectionBox.removeAttribute("hidden");
  }
  document.getElementById("cropCanvas").style.display = "block";
  document.getElementById("loadingMessage").style.display = "none";
}

function setSize(targetElement,width,height) {
  targetElement.setAttribute("width", width);
  targetElement.setAttribute("height", height);

  targetElement.style.width = width+"px";
  targetElement.style.height = height+"px";
//  targetElement.style.minWidth = targetElement.style.width;
//  targetElement.style.minHeight = targetElement.style.height;
  targetElement.style.maxWidth = targetElement.style.width;
  targetElement.style.maxHeight = targetElement.style.height;
}
